/*
 * Decompiled with CFR 0.152.
 */
package io.github.schntgaispock.gastronomicon.api.loot;

import io.github.schntgaispock.gastronomicon.api.loot.ItemLootTableBuilder;
import io.github.schntgaispock.gastronomicon.util.collections.Pair;
import java.util.ArrayDeque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import lombok.Generated;

public class LootTable<T> {
    private final List<T> drops;
    private final int totalWeight;
    private final int[] prob;
    private final int[] alias;

    public static <T, U> LootTableBuilder<T> builder(Class<T> type) {
        return new LootTableBuilder();
    }

    public static <T, U> ItemLootTableBuilder builder() {
        return new ItemLootTableBuilder();
    }

    public T generate() {
        if (this.drops.size() == 0) {
            return null;
        }
        int roll = ThreadLocalRandom.current().nextInt(this.drops.size());
        if (ThreadLocalRandom.current().nextDouble() * (double)this.totalWeight < (double)this.prob[roll]) {
            return this.drops.get(roll);
        }
        return this.drops.get(this.alias[roll]);
    }

    public int size() {
        return this.drops.size();
    }

    public boolean isEmpty() {
        return this.drops.isEmpty();
    }

    @Nonnull
    @Generated
    public String toString() {
        return "LootTable(drops=" + this.drops + ")";
    }

    @Generated
    protected LootTable(List<T> drops, int totalWeight, int[] prob, int[] alias) {
        this.drops = drops;
        this.totalWeight = totalWeight;
        this.prob = prob;
        this.alias = alias;
    }

    public static class LootTableBuilder<T> {
        protected int totalWeight = 0;
        protected final LinkedHashMap<T, Integer> weightedDrops = new LinkedHashMap();

        @SafeVarargs
        public final LootTableBuilder<T> add(int weight, T ... drops) {
            for (T drop : drops) {
                this.weightedDrops.put(drop, weight);
                this.totalWeight += weight;
            }
            return this;
        }

        @SafeVarargs
        public final LootTableBuilder<T> add(T ... drops) {
            return this.add(1, drops);
        }

        public LootTable<T> build() {
            int length = this.weightedDrops.size();
            ArrayDeque<Pair> small = new ArrayDeque<Pair>();
            ArrayDeque<Pair> large = new ArrayDeque<Pair>();
            int[] prob = new int[length];
            int[] alias = new int[length];
            int i = 0;
            for (int chance : this.weightedDrops.values()) {
                if ((chance *= length) < this.totalWeight) {
                    small.push(Pair.of(chance, i));
                } else {
                    large.push(Pair.of(chance, i));
                }
                ++i;
            }
            while (!small.isEmpty() && !large.isEmpty()) {
                Pair l = (Pair)small.pop();
                Pair g = (Pair)large.pop();
                prob[((Integer)l.second()).intValue()] = (Integer)l.first();
                alias[((Integer)l.second()).intValue()] = (Integer)g.second();
                g.first((Integer)g.first() + (Integer)l.first() - this.totalWeight);
                if ((Integer)g.first() < this.totalWeight) {
                    small.push(g);
                    continue;
                }
                large.push(g);
            }
            while (!large.isEmpty()) {
                prob[((Integer)((Pair)large.pop()).second()).intValue()] = this.totalWeight;
            }
            while (!small.isEmpty()) {
                prob[((Integer)((Pair)small.pop()).second()).intValue()] = this.totalWeight;
            }
            return new LootTable(this.weightedDrops.keySet().stream().toList(), this.totalWeight, prob, alias);
        }

        @Generated
        protected LootTableBuilder() {
        }
    }
}

