/*
 * Decompiled with CFR 0.152.
 */
package io.github.schntgaispock.gastronomicon.api.items;

import io.github.schntgaispock.gastronomicon.api.items.GastroTheme;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.meta.ItemMeta;

public class ThemedItemStack
extends SlimefunItemStack {
    @ParametersAreNonnullByDefault
    protected ThemedItemStack(String id, Material material, String name, String ... lore) {
        super(id, material, name, lore);
    }

    @ParametersAreNonnullByDefault
    protected ThemedItemStack(String id, String texture, String name, String ... lore) {
        super(id, texture, name, lore);
    }

    @Nonnull
    public Material getType() {
        Material type = super.getType();
        return type == null ? Material.BARRIER : type;
    }

    @Nonnull
    public String getDisplayName() {
        String name = this.getDisplayName();
        return name == null ? "NO NAME GIVEN" : name;
    }

    @ParametersAreNonnullByDefault
    public static ThemedItemStack of(GastroTheme theme, String id, Material material, String name, String ... lore) {
        if (id == null || material == null) {
            return null;
        }
        if (lore.length > 0) {
            String[] fLore = new String[lore.length + 1];
            fLore[0] = "";
            for (int i = 0; i < lore.length; ++i) {
                fLore[i + 1] = theme.getLoreColor() + lore[i].replace("&r", theme.getLoreColor().toString());
            }
            return new ThemedItemStack(id, material, theme.getColor() + name, fLore);
        }
        return new ThemedItemStack(id, material, theme.getColor() + name, new String[0]);
    }

    @ParametersAreNonnullByDefault
    public static ThemedItemStack of(GastroTheme theme, String id, String texture, String name, String ... lore) {
        if (id == null || texture == null) {
            return null;
        }
        if (lore.length > 0) {
            String[] fLore = new String[lore.length + 1];
            fLore[0] = "";
            for (int i = 0; i < lore.length; ++i) {
                fLore[i + 1] = theme.getLoreColor() + lore[i];
            }
            return new ThemedItemStack(id, texture, theme.getColor() + name, fLore);
        }
        return new ThemedItemStack(id, texture, theme.getColor() + name, new String[0]);
    }

    @ParametersAreNonnullByDefault
    public static ThemedItemStack ingredient(String id, Material material, String name, String ... lore) {
        return ThemedItemStack.of(GastroTheme.INGREDIENT, id, material, name, lore);
    }

    @ParametersAreNonnullByDefault
    public static ThemedItemStack ingredient(String id, String texture, String name, String ... lore) {
        return ThemedItemStack.of(GastroTheme.INGREDIENT, id, texture, name, lore);
    }

    public ThemedItemStack enchant(Enchantment ... enchantments) {
        for (Enchantment enchantment : enchantments) {
            this.enchant(enchantment, 1);
        }
        return this;
    }

    public ThemedItemStack enchant(Enchantment enchantment, int level) {
        this.addUnsafeEnchantment(enchantment, level);
        return this;
    }

    public ThemedItemStack glisten() {
        return this.enchant(Enchantment.DURABILITY).addFlags(ItemFlag.HIDE_ENCHANTS);
    }

    public ThemedItemStack addFlags(ItemFlag ... flags) {
        ItemMeta meta = this.getItemMeta();
        meta.addItemFlags(flags);
        this.setItemMeta(meta);
        return this;
    }
}

