/*
 * Decompiled with CFR 0.152.
 */
package io.github.schntgaispock.gastronomicon.core.slimefun.items.workstations.manual;

import io.github.schntgaispock.gastronomicon.Gastronomicon;
import io.github.schntgaispock.gastronomicon.core.slimefun.items.workstations.manual.GastroWorkstation;
import io.github.schntgaispock.gastronomicon.core.slimefun.recipes.GastroRecipeType;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import lombok.Generated;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Refrigerator
extends GastroWorkstation
implements EnergyNetComponent {
    private final int capacity;
    private final int energyPerUse;

    public Refrigerator(SlimefunItemStack item, ItemStack[] recipe, int capacity, int energyPerUse) {
        super(item, recipe);
        this.capacity = capacity;
        this.energyPerUse = energyPerUse;
    }

    @Override
    protected void setup(BlockMenuPreset preset) {
        super.setup(preset);
        preset.drawBackground(BACKGROUND_ITEM, new int[]{52});
    }

    @Override
    public GastroRecipeType getGastroRecipeType() {
        return GastroRecipeType.REFRIGERATOR;
    }

    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    @Override
    protected boolean canCraft(BlockMenu menu, Block b, Player p, boolean sendMessage) {
        int charge = this.getCharge(b.getLocation());
        if (charge < this.getEnergyPerUse()) {
            Gastronomicon.sendMessage(p, "&eNot enough energy!");
            return false;
        }
        return true;
    }

    @Override
    protected void onSuccessfulCraft(Block b) {
        int charge = this.getCharge(b.getLocation());
        this.setCharge(b.getLocation(), charge - this.getEnergyPerUse());
    }

    @Generated
    public int getCapacity() {
        return this.capacity;
    }

    @Generated
    public int getEnergyPerUse() {
        return this.energyPerUse;
    }
}

