/*
 * Decompiled with CFR 0.152.
 */
package io.github.schntgaispock.gastronomicon.core.slimefun.items.seeds;

import io.github.schntgaispock.gastronomicon.Gastronomicon;
import io.github.schntgaispock.gastronomicon.core.slimefun.items.seeds.SimpleSeed;
import io.github.schntgaispock.gastronomicon.util.RecipeUtil;
import io.github.schntgaispock.gastronomicon.util.item.ItemUtil;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import java.util.logging.Level;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.inventory.ItemStack;

public class FruitingSeed
extends SimpleSeed {
    private final SlimefunItem fruitingBody;

    @ParametersAreNonnullByDefault
    public FruitingSeed(SlimefunItemStack item, @Nullable Material displayBlock, ItemStack[] gatherSources, String fruitingBodyId) {
        super(item, displayBlock, gatherSources);
        if (displayBlock == null) {
            displayBlock = ItemUtil.getPlacedBlock(item.getType());
        }
        switch (displayBlock) {
            case PUMPKIN_STEM: 
            case MELON_STEM: {
                break;
            }
            default: {
                Gastronomicon.log(Level.WARNING, "Registering a FruitingSeed that isn't a pumpkin or melon seed!");
            }
        }
        this.fruitingBody = SlimefunItem.getById((String)fruitingBodyId);
    }

    @ParametersAreNonnullByDefault
    public FruitingSeed(SlimefunItemStack item, @Nullable Material displayBlock, SlimefunItemStack harvestSource, String fruitingBodyId) {
        this(item, displayBlock, RecipeUtil.singleCenter((ItemStack)harvestSource), fruitingBodyId);
    }

    @ParametersAreNonnullByDefault
    public FruitingSeed(SlimefunItemStack item, SlimefunItemStack harvestSource, String fruitingBodyId) {
        this(item, null, RecipeUtil.singleCenter((ItemStack)harvestSource), fruitingBodyId);
    }

    @Override
    public boolean isMature(BlockState b) {
        return false;
    }

    @Generated
    public SlimefunItem getFruitingBody() {
        return this.fruitingBody;
    }
}

