/*
 * Decompiled with CFR 0.152.
 */
package io.github.schntgaispock.gastronomicon.api.items;

import io.github.schntgaispock.gastronomicon.api.food.FoodEffect;
import io.github.schntgaispock.gastronomicon.api.items.GastroTheme;
import io.github.schntgaispock.gastronomicon.util.NumberUtil;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import io.github.thebusybiscuit.slimefun4.utils.LoreBuilder;
import java.util.Arrays;
import java.util.LinkedList;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import org.bukkit.Material;

public class FoodItemStack
extends SlimefunItemStack {
    private final int hunger;
    private final double saturation;
    private final String texture;
    @Nonnull
    private final FoodEffect[] effects;
    private final String[] perfectLore;
    private final boolean perfect;

    @ParametersAreNonnullByDefault
    protected FoodItemStack(String id, String texture, String name, int hunger, double saturation, FoodEffect[] effects, String[] lore, String[] perfectLore, boolean perfect) {
        super(id, texture, name, lore);
        this.hunger = hunger;
        this.saturation = saturation;
        this.texture = texture;
        this.effects = effects;
        this.perfectLore = perfectLore;
        this.perfect = perfect;
    }

    @ParametersAreNonnullByDefault
    protected FoodItemStack(String id, Material material, String name, int hunger, double saturation, FoodEffect[] effects, String[] lore, String[] perfectLore, boolean perfect) {
        super(id, material, name, lore);
        this.hunger = hunger;
        this.saturation = saturation;
        this.texture = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZTZiNTQzNDY0OTMwZThkMzg2NzZkYjZiZTk5MjBkZDgyYTU0ODU5YzM0OTdkOWZlMzFlZjkyYTg4NGM4NCJ9fX0=";
        this.effects = effects;
        this.perfectLore = perfectLore;
        this.perfect = perfect;
    }

    @ParametersAreNonnullByDefault
    protected FoodItemStack(String id, String texture, String name, int hunger, double saturation, FoodEffect[] effects, String[] lore, boolean perfect) {
        this(id, texture, name, hunger, saturation, effects, lore, lore, perfect);
    }

    @ParametersAreNonnullByDefault
    protected FoodItemStack(String id, Material material, String name, int hunger, double saturation, FoodEffect[] effects, String[] lore, boolean perfect) {
        this(id, material, name, hunger, saturation, effects, lore, lore, perfect);
    }

    private static String[] getFormattedLore(boolean isPerfect, int hunger, FoodEffect[] effects, String[] lore) {
        LinkedList<Object> fLore = new LinkedList<Object>();
        fLore.add(LoreBuilder.hunger((double)((double)hunger / 2.0)));
        if (effects != null && effects.length > 0) {
            fLore.add("");
            fLore.add("&7When consumed:");
            for (FoodEffect effect : effects) {
                fLore.add("&8\u2011 " + (isPerfect ? effect.getPerfectDescription() : effect.getDescription()));
            }
        }
        if (lore.length != 0) {
            fLore.add("");
            for (String loreLine : lore) {
                fLore.add((isPerfect ? GastroTheme.PERFECT_FOOD : GastroTheme.REGULAR_FOOD).getLoreColor() + (String)loreLine);
            }
        }
        return (String[])fLore.toArray(String[]::new);
    }

    @ParametersAreNonnullByDefault
    public static FoodItemStack of(String id, Material material, String name, int hunger, double saturationRatio, FoodEffect[] effects, String[] lore, String[] perfectLore) {
        return new FoodItemStack(id, material, GastroTheme.REGULAR_FOOD.getColor() + name, hunger, NumberUtil.roundToPrecision((double)hunger * saturationRatio, 1), effects, FoodItemStack.getFormattedLore(false, hunger, effects, lore), FoodItemStack.getFormattedLore(true, hunger, effects, perfectLore), false);
    }

    @ParametersAreNonnullByDefault
    public static FoodItemStack of(String id, String texture, String name, int hunger, double saturationRatio, FoodEffect[] effects, String[] lore, String[] perfectLore) {
        return new FoodItemStack(id, texture, GastroTheme.REGULAR_FOOD.getColor() + name, hunger, NumberUtil.roundToPrecision((double)hunger * saturationRatio, 1), effects, FoodItemStack.getFormattedLore(false, hunger, effects, lore), FoodItemStack.getFormattedLore(true, hunger, effects, perfectLore), false);
    }

    public FoodItemStack asPerfect() {
        if (this.isPerfect()) {
            return this;
        }
        return new FoodItemStack("GN_PERFECT" + this.getItemId().substring(2), this.getTexture(), GastroTheme.PERFECT_FOOD.getColor() + ChatUtils.removeColorCodes((String)this.getDisplayName()), this.hunger, this.saturation, this.effects, this.perfectLore, this.perfectLore, true);
    }

    @Generated
    public int getHunger() {
        return this.hunger;
    }

    @Generated
    public double getSaturation() {
        return this.saturation;
    }

    @Generated
    public String getTexture() {
        return this.texture;
    }

    @Nonnull
    @Generated
    public FoodEffect[] getEffects() {
        return this.effects;
    }

    @Generated
    public String[] getPerfectLore() {
        return this.perfectLore;
    }

    @Generated
    public boolean isPerfect() {
        return this.perfect;
    }

    @Nonnull
    @Generated
    public String toString() {
        return "FoodItemStack(hunger=" + this.getHunger() + ", saturation=" + this.getSaturation() + ", texture=" + this.getTexture() + ", effects=" + Arrays.deepToString(this.getEffects()) + ", perfect=" + this.isPerfect() + ")";
    }
}

