/*
 * Decompiled with CFR 0.152.
 */
package io.github.schntgaispock.gastronomicon.core.slimefun.items.workstations.manual;

import io.github.schntgaispock.gastronomicon.Gastronomicon;
import io.github.schntgaispock.gastronomicon.core.slimefun.GastroGroups;
import io.github.schntgaispock.gastronomicon.util.NumberUtil;
import io.github.thebusybiscuit.slimefun4.api.events.BlockPlacerPlaceEvent;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.handlers.SimpleBlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.block.Block;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;

public abstract class HuntingTrap
extends SimpleSlimefunItem<BlockUseHandler> {
    private final Map<Location, Boolean> triggeredTraps = new HashMap<Location, Boolean>();

    protected HuntingTrap(SlimefunItemStack item, ItemStack[] recipe) {
        super((ItemGroup)GastroGroups.TOOLS, item, RecipeType.ENHANCED_CRAFTING_TABLE, recipe);
    }

    public void preRegister() {
        super.preRegister();
        this.addItemHandler(new ItemHandler[]{new BlockPlaceHandler(true){

            public void onBlockPlacerPlace(BlockPlacerPlaceEvent e) {
                HuntingTrap.this.startCatch(e.getBlock().getLocation());
            }

            public void onPlayerPlace(BlockPlaceEvent e) {
                HuntingTrap.this.startCatch(e.getBlock().getLocation());
            }
        }});
        this.addItemHandler(new ItemHandler[]{new SimpleBlockBreakHandler(){

            public void onBlockBreak(Block b) {
                BlockStorage.clearBlockInfo((Block)b);
                if (HuntingTrap.this.triggeredTraps.containsKey(b.getLocation()) && HuntingTrap.this.triggeredTraps.get(b.getLocation()).booleanValue()) {
                    HuntingTrap.this.dropCatch(b.getLocation());
                }
                HuntingTrap.this.triggeredTraps.remove(b.getLocation());
            }
        }});
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){
            private boolean active = true;

            public void tick(Block b, SlimefunItem item, Config config) {
                if (!this.active) {
                    return;
                }
                if (HuntingTrap.this.triggeredTraps.containsKey(b.getLocation())) {
                    if (HuntingTrap.this.triggeredTraps.get(b.getLocation()).booleanValue()) {
                        b.getWorld().spawnParticle(Particle.WAX_OFF, b.getLocation().getX() + 0.5, b.getLocation().getY() + 0.25, b.getLocation().getZ() + 0.5, 4, 0.2, 0.05, 0.2, 0.0, null, true);
                    }
                } else {
                    this.active = HuntingTrap.this.startCatch(b.getLocation());
                }
            }

            public boolean isSynchronized() {
                return false;
            }
        }});
    }

    public BlockUseHandler getItemHandler() {
        return e -> {
            e.cancel();
            if (e.getClickedBlock().isEmpty()) {
                return;
            }
            Location l = ((Block)e.getClickedBlock().get()).getLocation();
            if (this.triggeredTraps.containsKey(l) && this.triggeredTraps.get(l).booleanValue()) {
                this.dropCatch(l);
                this.startCatch(l);
            }
        };
    }

    protected abstract ItemStack getCatch(Location var1);

    protected abstract boolean canCatch(Location var1);

    private boolean startCatch(Location l) {
        this.triggeredTraps.put(l, false);
        if (!this.canCatch(l)) {
            return false;
        }
        Gastronomicon.scheduleSyncDelayedTask(() -> {
            String id = BlockStorage.checkID((Location)l);
            if (id != null && id.equals(this.getId())) {
                l.getWorld().playSound(l, Sound.ENTITY_EVOKER_FANGS_ATTACK, SoundCategory.BLOCKS, 1.0f, 1.5f);
                this.triggeredTraps.put(l, true);
            }
        }, 20L * (long)NumberUtil.clamp(ThreadLocalRandom.current().nextGaussian(120.0, 30.0), 60.0, 180.0));
        return true;
    }

    private void dropCatch(Location l) {
        l.getWorld().dropItemNaturally(l, this.getCatch(l));
    }

    @Generated
    public Map<Location, Boolean> getTriggeredTraps() {
        return this.triggeredTraps;
    }
}

