/*
 * Decompiled with CFR 0.152.
 */
package io.github.schntgaispock.gastronomicon.api.food;

import io.github.schntgaispock.gastronomicon.api.recipes.GastroRecipe;
import io.github.schntgaispock.gastronomicon.api.recipes.MultiStoveRecipe;
import io.github.schntgaispock.gastronomicon.api.recipes.ShapedGastroRecipe;
import io.github.schntgaispock.gastronomicon.api.recipes.ShapelessGastroRecipe;
import io.github.schntgaispock.gastronomicon.api.recipes.components.RecipeComponent;
import io.github.schntgaispock.gastronomicon.api.recipes.components.SingleRecipeComponent;
import io.github.schntgaispock.gastronomicon.core.slimefun.GastroGroups;
import io.github.schntgaispock.gastronomicon.core.slimefun.GastroResearch;
import io.github.schntgaispock.gastronomicon.core.slimefun.items.food.SimpleGastroFood;
import io.github.schntgaispock.gastronomicon.core.slimefun.items.workstations.manual.MultiStove;
import io.github.schntgaispock.gastronomicon.core.slimefun.recipes.GastroRecipeType;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.researches.Research;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class SimpleGastroFoodBuilder {
    protected Research research = GastroResearch.PROCESSED_INGREDIENTS;
    protected ItemGroup group = GastroGroups.FOOD;
    protected SlimefunItemStack itemStack;
    protected int amount = 1;
    protected GastroRecipeType recipeType;
    protected GastroRecipe.RecipeShape shape = GastroRecipe.RecipeShape.SHAPELESS;
    protected MultiStove.Temperature temperature = MultiStove.Temperature.MEDIUM;
    protected RecipeComponent<?>[] ingredients;
    protected RecipeComponent<?> container = RecipeComponent.EMPTY;
    protected Set<ItemStack> tools = Collections.emptySet();

    public SimpleGastroFoodBuilder research(Research research) {
        this.research = research;
        return this;
    }

    public SimpleGastroFoodBuilder group(@Nonnull ItemGroup group) {
        this.group = group;
        return this;
    }

    public SimpleGastroFoodBuilder item(@Nonnull SlimefunItemStack itemStack) {
        this.itemStack = itemStack;
        return this;
    }

    public SimpleGastroFoodBuilder amount(int amount) {
        this.amount = amount;
        return this;
    }

    public SimpleGastroFoodBuilder type(@Nonnull GastroRecipeType type) {
        this.recipeType = type;
        return this;
    }

    public SimpleGastroFoodBuilder shape(@Nonnull GastroRecipe.RecipeShape shape) {
        this.shape = shape;
        return this;
    }

    public SimpleGastroFoodBuilder temperature(@Nonnull MultiStove.Temperature temperature) {
        this.temperature = temperature;
        return this;
    }

    public SimpleGastroFoodBuilder ingredients(Object ... ingredients) {
        this.ingredients = new RecipeComponent[9];
        for (int i = 0; i < Math.min(ingredients.length, 9); ++i) {
            String str;
            SlimefunItem item;
            Object object = ingredients[i];
            if (object instanceof ItemStack) {
                ItemStack stack = (ItemStack)object;
                this.ingredients[i] = new SingleRecipeComponent(stack);
                continue;
            }
            object = ingredients[i];
            if (object instanceof RecipeComponent) {
                RecipeComponent comp;
                this.ingredients[i] = comp = (RecipeComponent)object;
                continue;
            }
            object = ingredients[i];
            if (object instanceof Material) {
                Material mat = (Material)object;
                this.ingredients[i] = new SingleRecipeComponent(new ItemStack(mat));
                continue;
            }
            object = ingredients[i];
            this.ingredients[i] = object instanceof String ? ((item = SlimefunItem.getById((String)(str = (String)object))) == null ? RecipeComponent.EMPTY : new SingleRecipeComponent(item.getItem())) : RecipeComponent.EMPTY;
        }
        return this;
    }

    public SimpleGastroFoodBuilder ingredients(ItemStack ... ingredients) {
        this.ingredients = new RecipeComponent[9];
        for (int i = 0; i < Math.min(ingredients.length, 9); ++i) {
            this.ingredients[i] = ingredients[i] == null || ingredients[i].getType() == Material.AIR ? RecipeComponent.EMPTY : new SingleRecipeComponent(ingredients[i]);
        }
        return this;
    }

    public SimpleGastroFoodBuilder ingredients(RecipeComponent<?> ... ingredients) {
        this.ingredients = Arrays.copyOf(ingredients, 9);
        return this;
    }

    public SimpleGastroFoodBuilder container(@Nonnull ItemStack container) {
        this.container = new SingleRecipeComponent(container);
        return this;
    }

    public SimpleGastroFoodBuilder container(@Nonnull RecipeComponent<?> container) {
        this.container = container;
        return this;
    }

    public SimpleGastroFoodBuilder tools(ItemStack ... tools) {
        this.tools = Set.of(tools);
        return this;
    }

    public SimpleGastroFood build() {
        GastroRecipe recipe;
        ItemStack topRightDisplayItem;
        Validate.notNull((Object)this.itemStack, (String)"Must set an ItemStack!");
        Validate.notNull((Object)((Object)this.recipeType), (String)"Must set a recipe type!");
        Validate.notNull(this.ingredients, (String)"Must set ingredients!");
        ItemStack[] outputs = new ItemStack[]{this.itemStack.asQuantity(this.amount)};
        if (this.recipeType == GastroRecipeType.MULTI_STOVE) {
            topRightDisplayItem = this.temperature.getItem().clone();
            topRightDisplayItem.setLore(Collections.emptyList());
            recipe = new MultiStoveRecipe(this.ingredients, this.container, this.tools, outputs, this.temperature);
        } else {
            topRightDisplayItem = new ItemStack(Material.AIR);
            recipe = this.shape == GastroRecipe.RecipeShape.SHAPED ? new ShapedGastroRecipe(this.recipeType, this.ingredients, this.container, this.tools, outputs) : new ShapelessGastroRecipe(this.recipeType, this.ingredients, this.container, this.tools, outputs);
        }
        return new SimpleGastroFood(this.research, this.group, this.itemStack, recipe, topRightDisplayItem, outputs[0], true);
    }

    public void register(SlimefunAddon addon) {
        this.build().register(addon);
    }

    @Nonnull
    @Generated
    public String toString() {
        return "SimpleGastroFoodBuilder(research=" + this.research + ", group=" + this.group + ", itemStack=" + this.itemStack + ", amount=" + this.amount + ", recipeType=" + this.recipeType + ", shape=" + this.shape + ", temperature=" + this.temperature + ", ingredients=" + Arrays.deepToString(this.ingredients) + ", container=" + this.container + ", tools=" + this.tools + ")";
    }
}

