/*
 * Decompiled with CFR 0.152.
 */
package io.github.schntgaispock.gastronomicon.core.setup;

import io.github.schntgaispock.gastronomicon.Gastronomicon;
import io.github.schntgaispock.gastronomicon.api.food.GastroFoodBuilder;
import io.github.schntgaispock.gastronomicon.api.food.SimpleGastroFoodBuilder;
import io.github.schntgaispock.gastronomicon.api.recipes.GastroRecipe;
import io.github.schntgaispock.gastronomicon.api.recipes.MultiStoveRecipe;
import io.github.schntgaispock.gastronomicon.api.recipes.RecipeRegistry;
import io.github.schntgaispock.gastronomicon.api.recipes.ShapedGastroRecipe;
import io.github.schntgaispock.gastronomicon.core.slimefun.GastroGroups;
import io.github.schntgaispock.gastronomicon.core.slimefun.GastroStacks;
import io.github.schntgaispock.gastronomicon.core.slimefun.items.UnplaceableItem;
import io.github.schntgaispock.gastronomicon.core.slimefun.items.UnplaceableSolid;
import io.github.schntgaispock.gastronomicon.core.slimefun.items.seeds.CropSeed;
import io.github.schntgaispock.gastronomicon.core.slimefun.items.seeds.DuplicatingSeed;
import io.github.schntgaispock.gastronomicon.core.slimefun.items.seeds.FruitingSeed;
import io.github.schntgaispock.gastronomicon.core.slimefun.items.seeds.SimpleSapling;
import io.github.schntgaispock.gastronomicon.core.slimefun.items.seeds.SimpleSeed;
import io.github.schntgaispock.gastronomicon.core.slimefun.items.seeds.VineSeed;
import io.github.schntgaispock.gastronomicon.core.slimefun.items.workstations.automatic.ElectricKitchen;
import io.github.schntgaispock.gastronomicon.core.slimefun.items.workstations.automatic.FishingNet;
import io.github.schntgaispock.gastronomicon.core.slimefun.items.workstations.manual.ChefAndroidTrainer;
import io.github.schntgaispock.gastronomicon.core.slimefun.items.workstations.manual.CulinaryWorkbench;
import io.github.schntgaispock.gastronomicon.core.slimefun.items.workstations.manual.Fermenter;
import io.github.schntgaispock.gastronomicon.core.slimefun.items.workstations.manual.GrainMill;
import io.github.schntgaispock.gastronomicon.core.slimefun.items.workstations.manual.HuntingTrap;
import io.github.schntgaispock.gastronomicon.core.slimefun.items.workstations.manual.MultiStove;
import io.github.schntgaispock.gastronomicon.core.slimefun.items.workstations.manual.Refrigerator;
import io.github.schntgaispock.gastronomicon.core.slimefun.recipes.GastroRecipeType;
import io.github.schntgaispock.gastronomicon.util.RecipeUtil;
import io.github.schntgaispock.gastronomicon.util.collections.CollectionUtil;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.items.blocks.UnplaceableBlock;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.inventory.ItemStack;

public final class ItemSetup {
    public static ItemStack getItem(String id) {
        SlimefunItem item = SlimefunItem.getById((String)id);
        if (item == null) {
            return null;
        }
        return item.getItem();
    }

    public static void setup() {
        Gastronomicon gn = Gastronomicon.getInstance();
        boolean egAvailable = Gastronomicon.isPluginEnabled("ExoticGarden") && !Gastronomicon.getInstance().getConfig().getBoolean("disable-exotic-garden-recipes");
        GastroGroups.MAIN.register(gn);
        ItemStack ORANGE = ItemSetup.getItem("ORANGE");
        ItemStack LETTUCE = ItemSetup.getItem("LETTUCE");
        ItemStack GARLIC = ItemSetup.getItem("GARLIC");
        ItemStack TOMATO = ItemSetup.getItem("TOMATO");
        ItemStack ONION = ItemSetup.getItem("ONION");
        ItemStack BACON = ItemSetup.getItem("BACON");
        ItemStack MAYO = ItemSetup.getItem("MAYO");
        ItemStack CORN = ItemSetup.getItem("CORN");
        ItemStack BBQ_SAUCE = ItemSetup.getItem("BBQ_SAUCE");
        ItemStack CURRY_LEAF = ItemSetup.getItem("CURRY_LEAF");
        ItemStack CILANTRO = ItemSetup.getItem("CILANTRO");
        ItemStack BLUEBERRY = ItemSetup.getItem("BLUEBERRY");
        ItemStack CRANBERRY = ItemSetup.getItem("CRANBERRY");
        ItemStack GRAPE = ItemSetup.getItem("GRAPE");
        ItemStack TEA_LEAF = ItemSetup.getItem("TEA_LEAF");
        ItemStack STRAWBERRY = ItemSetup.getItem("STRAWBERRY");
        ItemStack COWBERRY = ItemSetup.getItem("COWBERRY");
        ItemStack COCONUT = ItemSetup.getItem("COCONUT");
        ItemStack CHERRY = ItemSetup.getItem("CHERRY");
        ItemStack RASPBERRY = ItemSetup.getItem("RASPBERRY");
        ItemStack PEACH = ItemSetup.getItem("PEACH");
        ItemStack PINEAPPLE = ItemSetup.getItem("PINEAPPLE");
        ItemStack LEMON = ItemSetup.getItem("LEMON");
        ItemStack YEAST = ItemSetup.getItem("YEAST");
        ItemStack BROWN_SUGAR = ItemSetup.getItem("BROWN_SUGAR");
        ItemStack OAK_PLANKS = new ItemStack(Material.OAK_PLANKS);
        ItemStack OAK_SLAB = new ItemStack(Material.OAK_SLAB);
        ItemStack OAK_FENCE = new ItemStack(Material.OAK_FENCE);
        ItemStack STICK = new ItemStack(Material.STICK);
        ItemStack IRON_BARS = new ItemStack(Material.IRON_BARS);
        ItemStack IRON_NUGGET = new ItemStack(Material.IRON_NUGGET);
        ItemStack IRON_TRAPDOOR = new ItemStack(Material.IRON_TRAPDOOR);
        ItemStack BUCKET = new ItemStack(Material.BUCKET);
        ItemStack BOWL = new ItemStack(Material.BOWL);
        ItemStack IRON_PP = new ItemStack(Material.HEAVY_WEIGHTED_PRESSURE_PLATE);
        ItemStack IRON_BLOCK = new ItemStack(Material.IRON_BLOCK);
        ItemStack HOPPER = new ItemStack(Material.HOPPER);
        ItemStack BARREL = new ItemStack(Material.BARREL);
        ItemStack CRAFTING_TABLE = new ItemStack(Material.CRAFTING_TABLE);
        ItemStack DISPENSER = new ItemStack(Material.DISPENSER);
        ItemStack BLAST_FURNACE = new ItemStack(Material.BLAST_FURNACE);
        ItemStack KELP = new ItemStack(Material.KELP);
        ItemStack DRIED_KELP = new ItemStack(Material.DRIED_KELP);
        ItemStack POLISHED_GRANITE = new ItemStack(Material.POLISHED_GRANITE);
        ItemStack ANDESITE_SLAB = new ItemStack(Material.ANDESITE_SLAB);
        ItemStack BREAD = new ItemStack(Material.BREAD);
        ItemStack EGG = new ItemStack(Material.EGG);
        ItemStack WATER_BUCKET = new ItemStack(Material.WATER_BUCKET);
        ItemStack MILK_BUCKET = new ItemStack(Material.WATER_BUCKET);
        ItemStack SUGAR = new ItemStack(Material.SUGAR);
        ItemStack COOKED_PORKCHOP = new ItemStack(Material.COOKED_PORKCHOP);
        ItemStack COOKED_BEEF = new ItemStack(Material.COOKED_BEEF);
        ItemStack PORKCHOP = new ItemStack(Material.PORKCHOP);
        ItemStack CHICKEN = new ItemStack(Material.CHICKEN);
        ItemStack BEEF = new ItemStack(Material.BEEF);
        ItemStack MUTTON = new ItemStack(Material.MUTTON);
        ItemStack APPLE = new ItemStack(Material.APPLE);
        ItemStack SALMON = new ItemStack(Material.SALMON);
        ItemStack INK_SAC = new ItemStack(Material.INK_SAC);
        ItemStack GLOW_INK_SAC = new ItemStack(Material.GLOW_INK_SAC);
        ItemStack CARROT = new ItemStack(Material.CARROT);
        ItemStack POTATO = new ItemStack(Material.POTATO);
        ItemStack COCOA_BEANS = new ItemStack(Material.COCOA_BEANS);
        ItemStack CHORUS_FRUIT = new ItemStack(Material.CHORUS_FRUIT);
        ItemStack ICE = new ItemStack(Material.ICE);
        ItemStack HONEY_BOTTLE = new ItemStack(Material.HONEY_BOTTLE);
        ItemStack MELON_SLICE = new ItemStack(Material.MELON_SLICE);
        ItemStack GLASS_BOTTLE = new ItemStack(Material.GLASS_BOTTLE);
        ItemStack BEETROOT = new ItemStack(Material.BEETROOT);
        ItemStack RAW_COD = new ItemStack(Material.COD);
        ItemStack BRICKS = new ItemStack(Material.BRICKS);
        ItemStack PINK_DYE = new ItemStack(Material.PINK_DYE);
        new UnplaceableSolid(GastroGroups.TOOLS, GastroStacks.ROLLING_PIN, RecipeType.ENHANCED_CRAFTING_TABLE, RecipeUtil.row(STICK, 1)).register(gn);
        new UnplaceableSolid(GastroGroups.TOOLS, GastroStacks.KITCHEN_KNIFE, RecipeType.ENHANCED_CRAFTING_TABLE, new ItemStack[]{null, null, null, null, SlimefunItems.STEEL_INGOT, null, null, STICK, null}).register(gn);
        new UnplaceableSolid(GastroGroups.TOOLS, GastroStacks.BLENDER, RecipeType.ENHANCED_CRAFTING_TABLE, new ItemStack[]{null, SlimefunItems.ELECTRIC_MOTOR, null, null, IRON_BARS, null, null, BUCKET, null}).register(gn);
        new UnplaceableSolid(GastroGroups.TOOLS, GastroStacks.MORTAR_AND_PESTLE, RecipeType.ENHANCED_CRAFTING_TABLE, new ItemStack[]{null, null, null, null, SlimefunItems.STEEL_INGOT, null, null, BOWL, null}).register(gn);
        new UnplaceableSolid(GastroGroups.TOOLS, GastroStacks.PEELER, RecipeType.ENHANCED_CRAFTING_TABLE, new ItemStack[]{null, IRON_NUGGET, null, null, IRON_NUGGET, null, null, STICK, null}).register(gn);
        new UnplaceableSolid(GastroGroups.TOOLS, GastroStacks.WHISK, RecipeType.ENHANCED_CRAFTING_TABLE, new ItemStack[]{null, GastroStacks.STEEL_WIRE, null, null, GastroStacks.STEEL_WIRE, null, null, STICK, null}).register(gn);
        new UnplaceableSolid(GastroGroups.TOOLS, GastroStacks.BAKING_TRAY, RecipeType.ENHANCED_CRAFTING_TABLE, new ItemStack[]{null, null, null, SlimefunItems.STEEL_INGOT, SlimefunItems.STEEL_PLATE, SlimefunItems.STEEL_INGOT, null, null, null}).register(gn);
        new UnplaceableSolid(GastroGroups.TOOLS, GastroStacks.FRYING_PAN, RecipeType.ENHANCED_CRAFTING_TABLE, new ItemStack[]{null, null, null, SlimefunItems.STEEL_INGOT, SlimefunItems.STEEL_PLATE, SlimefunItems.STEEL_PLATE, null, null, null}).register(gn);
        new UnplaceableSolid(GastroGroups.TOOLS, GastroStacks.STEEL_POT, RecipeType.ENHANCED_CRAFTING_TABLE, new ItemStack[]{SlimefunItems.STEEL_INGOT, null, SlimefunItems.STEEL_INGOT, SlimefunItems.STEEL_PLATE, null, SlimefunItems.STEEL_PLATE, SlimefunItems.STEEL_PLATE, SlimefunItems.STEEL_PLATE, SlimefunItems.STEEL_PLATE}).register(gn);
        new UnplaceableSolid(GastroGroups.TOOLS, GastroStacks.DISTILLATION_CHAMBER, RecipeType.ENHANCED_CRAFTING_TABLE, new ItemStack[]{SlimefunItems.STEEL_PLATE, SlimefunItems.STEEL_PLATE, SlimefunItems.STEEL_PLATE, SlimefunItems.STEEL_PLATE, null, SlimefunItems.STEEL_PLATE, SlimefunItems.STEEL_PLATE, SlimefunItems.STEEL_PLATE, SlimefunItems.STEEL_PLATE}).register(gn);
        new UnplaceableBlock((ItemGroup)GastroGroups.TOOLS, GastroStacks.STEEL_BOWL, RecipeType.ENHANCED_CRAFTING_TABLE, new ItemStack[]{null, null, null, SlimefunItems.STEEL_INGOT, null, SlimefunItems.STEEL_INGOT, null, SlimefunItems.STEEL_INGOT, null}, GastroStacks.STEEL_BOWL.asQuantity(4)).register((SlimefunAddon)gn);
        new SlimefunItem((ItemGroup)GastroGroups.TOOLS, GastroStacks.STEEL_WIRE, RecipeType.ENHANCED_CRAFTING_TABLE, RecipeUtil.row((ItemStack)SlimefunItems.STEEL_INGOT, 1), GastroStacks.STEEL_WIRE.asQuantity(8)).register((SlimefunAddon)gn);
        new SlimefunItem((ItemGroup)GastroGroups.TOOLS, GastroStacks.STEEL_SPRING, RecipeType.ENHANCED_CRAFTING_TABLE, RecipeUtil.cyclicAlternating(null, (ItemStack)GastroStacks.STEEL_WIRE)).register((SlimefunAddon)gn);
        new HuntingTrap(GastroStacks.HUNTING_TRAP, new ItemStack[]{null, SlimefunItems.STEEL_INGOT, null, SlimefunItems.STEEL_INGOT, IRON_PP, SlimefunItems.STEEL_INGOT, GastroStacks.STEEL_SPRING, GastroStacks.STEEL_SPRING, GastroStacks.STEEL_SPRING}){
            private static final Map<Biome, List<ItemStack>> dropsByBiome = new HashMap<Biome, List<ItemStack>>();

            @Override
            protected ItemStack getCatch(Location l) {
                List<ItemStack> possibleDrops = dropsByBiome.get(l.getBlock().getBiome());
                if (possibleDrops == null || possibleDrops.isEmpty()) {
                    return null;
                }
                return CollectionUtil.choice(possibleDrops);
            }

            @Override
            protected boolean canCatch(Location l) {
                return dropsByBiome.containsKey(l.getBlock().getBiome());
            }

            static {
                List<ItemStack> forestDrops = Arrays.asList(new ItemStack(Material.MUTTON), new ItemStack(Material.PORKCHOP), new ItemStack(Material.CHICKEN), new ItemStack(Material.BEEF), new ItemStack(Material.RABBIT), GastroStacks.RAW_TURKEY);
                List<ItemStack> plainsDrops = Arrays.asList(new ItemStack(Material.MUTTON), new ItemStack(Material.PORKCHOP), new ItemStack(Material.CHICKEN), new ItemStack(Material.BEEF));
                dropsByBiome.put(Biome.FOREST, forestDrops);
                dropsByBiome.put(Biome.FLOWER_FOREST, forestDrops);
                dropsByBiome.put(Biome.BIRCH_FOREST, forestDrops);
                dropsByBiome.put(Biome.OLD_GROWTH_BIRCH_FOREST, forestDrops);
                dropsByBiome.put(Biome.WINDSWEPT_FOREST, forestDrops);
                dropsByBiome.put(Biome.MEADOW, plainsDrops);
                dropsByBiome.put(Biome.PLAINS, plainsDrops);
                dropsByBiome.put(Biome.SUNFLOWER_PLAINS, plainsDrops);
            }
        }.register(gn);
        new HuntingTrap(GastroStacks.CRAB_TRAP, new ItemStack[]{STICK, STICK, STICK, STICK, GastroStacks.STEEL_WIRE, STICK, OAK_SLAB, OAK_SLAB, OAK_SLAB}){

            @Override
            protected ItemStack getCatch(Location l) {
                return GastroStacks.CRAB;
            }

            @Override
            protected boolean canCatch(Location l) {
                return switch (l.getBlock().getBiome()) {
                    case Biome.RIVER, Biome.BEACH, Biome.OCEAN, Biome.COLD_OCEAN, Biome.DEEP_OCEAN, Biome.WARM_OCEAN, Biome.FROZEN_OCEAN, Biome.LUKEWARM_OCEAN, Biome.DEEP_COLD_OCEAN, Biome.DEEP_FROZEN_OCEAN, Biome.DEEP_LUKEWARM_OCEAN -> true;
                    default -> false;
                };
            }
        }.register(gn);
        new SlimefunItem((ItemGroup)GastroGroups.TOOLS, GastroStacks.CHEFS_HAT, RecipeType.ARMOR_FORGE, new ItemStack[]{SlimefunItems.CLOTH, SlimefunItems.CLOTH, SlimefunItems.CLOTH, SlimefunItems.CLOTH, SlimefunItems.CLOTH, SlimefunItems.CLOTH, SlimefunItems.CLOTH, null, SlimefunItems.CLOTH}).register((SlimefunAddon)gn);
        new UnplaceableItem(GastroGroups.TOOLS, GastroStacks.WOODEN_SICKLE, RecipeType.ENHANCED_CRAFTING_TABLE, new ItemStack[]{null, OAK_PLANKS, OAK_PLANKS, null, STICK, null, STICK, null, null}).register(gn);
        new UnplaceableItem(GastroGroups.TOOLS, GastroStacks.STEEL_SICKLE, RecipeType.ENHANCED_CRAFTING_TABLE, new ItemStack[]{null, SlimefunItems.STEEL_PLATE, SlimefunItems.STEEL_PLATE, null, STICK, null, STICK, null, null}).register(gn);
        new UnplaceableItem(GastroGroups.TOOLS, GastroStacks.REINFORCED_SICKLE, RecipeType.ENHANCED_CRAFTING_TABLE, new ItemStack[]{null, SlimefunItems.REINFORCED_PLATE, SlimefunItems.REINFORCED_PLATE, null, STICK, null, STICK, null, null}).register(gn);
        new CulinaryWorkbench(GastroStacks.CULINARY_WORKBENCH, new ItemStack[]{POLISHED_GRANITE, POLISHED_GRANITE, POLISHED_GRANITE, BARREL, CRAFTING_TABLE, BARREL, IRON_BLOCK, DISPENSER, IRON_BLOCK}).register(gn);
        new MultiStove(GastroStacks.MULTI_STOVE, new ItemStack[]{IRON_PP, IRON_PP, IRON_PP, SlimefunItems.HEATING_COIL, BLAST_FURNACE, SlimefunItems.HEATING_COIL, SlimefunItems.HEATING_COIL, SlimefunItems.SMALL_CAPACITOR, SlimefunItems.HEATING_COIL}, 256, 16).register(gn);
        new Refrigerator(GastroStacks.REFRIGERATOR, new ItemStack[]{SlimefunItems.STEEL_INGOT, SlimefunItems.STEEL_INGOT, SlimefunItems.STEEL_INGOT, SlimefunItems.COOLING_UNIT, IRON_TRAPDOOR, SlimefunItems.COOLING_UNIT, SlimefunItems.STEEL_INGOT, SlimefunItems.SMALL_CAPACITOR, SlimefunItems.STEEL_INGOT}, 256, 16).register(gn);
        new GrainMill(GastroStacks.MILL, new ItemStack[]{null, HOPPER, null, IRON_BARS, SlimefunItems.DAMASCUS_STEEL_INGOT, IRON_BARS, null, ANDESITE_SLAB, null}).register(gn);
        new Fermenter(GastroStacks.FERMENTER, new ItemStack[]{OAK_FENCE, OAK_SLAB, OAK_FENCE, OAK_FENCE, BARREL, OAK_FENCE, OAK_FENCE, BARREL, OAK_FENCE}, 2000, 125).register(gn);
        new Fermenter(GastroStacks.LARGE_FERMENTER, new ItemStack[]{SlimefunItems.STEEL_PLATE, OAK_SLAB, SlimefunItems.STEEL_PLATE, SlimefunItems.STEEL_PLATE, GastroStacks.FERMENTER, SlimefunItems.STEEL_PLATE, SlimefunItems.STEEL_PLATE, GastroStacks.FERMENTER, SlimefunItems.STEEL_PLATE}, 16000, 125).register(gn);
        new UnplaceableSolid(GastroGroups.BASIC_MACHINES, GastroStacks.CHEF_ANDROID, RecipeType.ENHANCED_CRAFTING_TABLE, new ItemStack[]{null, GastroStacks.CHEFS_HAT, null, GastroStacks.KITCHEN_KNIFE, SlimefunItems.PROGRAMMABLE_ANDROID_2, GastroStacks.ROLLING_PIN, null, SlimefunItems.ELECTRIC_MOTOR, null}).register(gn);
        new ChefAndroidTrainer(GastroStacks.CHEF_ANDROID_TRAINER, new ItemStack[]{SlimefunItems.STEEL_PLATE, SlimefunItems.STEEL_PLATE, SlimefunItems.STEEL_PLATE, OAK_PLANKS, SlimefunItems.CARGO_MOTOR, OAK_PLANKS, OAK_PLANKS, SlimefunItems.MEDIUM_CAPACITOR, OAK_PLANKS}).register(gn);
        new FishingNet(GastroStacks.FISHING_NET_I, 1, RecipeUtil.block((ItemStack)GastroStacks.STEEL_WIRE)).register(gn);
        new FishingNet(GastroStacks.FISHING_NET_II, 2, RecipeUtil.cyclicAlternating(null, (ItemStack)SlimefunItems.REINFORCED_ALLOY_INGOT, (ItemStack)GastroStacks.FISHING_NET_I)).register(gn);
        new FishingNet(GastroStacks.FISHING_NET_III, 4, RecipeUtil.cyclic((ItemStack)SlimefunItems.REINFORCED_ALLOY_INGOT, (ItemStack)GastroStacks.FISHING_NET_II)).register(gn);
        new ElectricKitchen(GastroStacks.ELECTRIC_KITCHEN_I, 256, 16, 1, new ItemStack[]{GastroStacks.CULINARY_WORKBENCH, SlimefunItems.CARBONADO_EDGED_CAPACITOR, GastroStacks.MULTI_STOVE, GastroStacks.REFRIGERATOR, GastroStacks.MILL, GastroStacks.FERMENTER, SlimefunItems.BLISTERING_INGOT_3, SlimefunItems.CARGO_MOTOR, SlimefunItems.BLISTERING_INGOT_3}).register(gn);
        new ElectricKitchen(GastroStacks.ELECTRIC_KITCHEN_II, 1024, 64, 3, new ItemStack[]{BRICKS, SlimefunItems.POWER_CRYSTAL, BRICKS, SlimefunItems.ELECTRIC_MOTOR, GastroStacks.ELECTRIC_KITCHEN_I, SlimefunItems.ELECTRIC_MOTOR, SlimefunItems.DAMASCUS_STEEL_INGOT, SlimefunItems.HEATING_COIL, SlimefunItems.DAMASCUS_STEEL_INGOT}).register(gn);
        new ElectricKitchen(GastroStacks.ELECTRIC_KITCHEN_III, 4096, 256, 10, new ItemStack[]{SlimefunItems.REINFORCED_PLATE, GastroStacks.CHEF_ANDROID, SlimefunItems.REINFORCED_PLATE, SlimefunItems.ELECTRIC_MOTOR, GastroStacks.ELECTRIC_KITCHEN_II, SlimefunItems.ELECTRIC_MOTOR, SlimefunItems.REINFORCED_PLATE, SlimefunItems.REINFORCED_PLATE, SlimefunItems.REINFORCED_PLATE}).register(gn);
        new SimpleSeed(GastroStacks.RICE, Material.POTATOES, RecipeUtil.singleCenter(Material.GRASS)).register(gn);
        new SimpleSeed(GastroStacks.QUINOA, Material.WHEAT, RecipeUtil.singleCenter(Material.GRASS)).register(gn);
        new SimpleSeed(GastroStacks.OATS, Material.WHEAT, RecipeUtil.singleCenter(Material.GRASS)).register(gn);
        new SimpleSeed(GastroStacks.SOYBEANS, Material.POTATOES, RecipeUtil.singleCenter(Material.GRASS)).register(gn);
        new SlimefunItem((ItemGroup)GastroGroups.RAW_INGREDIENTS, GastroStacks.BARLEY, (RecipeType)GastroRecipeType.HARVEST, RecipeUtil.singleCenter((ItemStack)GastroStacks.BARLEY_SEEDS)).register((SlimefunAddon)gn);
        new CropSeed(GastroStacks.BARLEY_SEEDS, Material.WHEAT, RecipeUtil.singleCenter(Material.GRASS), (ItemStack)GastroStacks.BARLEY).register(gn);
        new SlimefunItem((ItemGroup)GastroGroups.RAW_INGREDIENTS, GastroStacks.RYE, (RecipeType)GastroRecipeType.HARVEST, RecipeUtil.singleCenter((ItemStack)GastroStacks.RYE_SEEDS)).register((SlimefunAddon)gn);
        new CropSeed(GastroStacks.RYE_SEEDS, Material.WHEAT, RecipeUtil.singleCenter(Material.GRASS), (ItemStack)GastroStacks.RYE).register(gn);
        new SlimefunItem((ItemGroup)GastroGroups.RAW_INGREDIENTS, GastroStacks.SORGHUM, (RecipeType)GastroRecipeType.HARVEST, RecipeUtil.singleCenter((ItemStack)GastroStacks.SORGHUM_SEEDS)).register((SlimefunAddon)gn);
        new CropSeed(GastroStacks.SORGHUM_SEEDS, Material.WHEAT, RecipeUtil.singleCenter(Material.GRASS), (ItemStack)GastroStacks.SORGHUM).register(gn);
        new SlimefunItem((ItemGroup)GastroGroups.RAW_INGREDIENTS, GastroStacks.TURNIP, (RecipeType)GastroRecipeType.HARVEST, RecipeUtil.singleCenter((ItemStack)GastroStacks.TURNIP_SEEDS)).register((SlimefunAddon)gn);
        new CropSeed(GastroStacks.TURNIP_SEEDS, Material.BEETROOTS, RecipeUtil.singleCenter(Material.GRASS), (ItemStack)GastroStacks.TURNIP).register(gn);
        new SlimefunItem((ItemGroup)GastroGroups.RAW_INGREDIENTS, GastroStacks.SQUASH, (RecipeType)GastroRecipeType.HARVEST, RecipeUtil.singleCenter((ItemStack)GastroStacks.SQUASH_SEEDS)).register((SlimefunAddon)gn);
        new FruitingSeed(GastroStacks.SQUASH_SEEDS, Material.MELON_STEM, RecipeUtil.singleCenter(Material.GRASS), "GN_SQUASH").register(gn);
        new DuplicatingSeed(GastroStacks.CELERY, RecipeUtil.singleCenter(Material.GRASS)).register(gn);
        new SlimefunItem((ItemGroup)GastroGroups.RAW_INGREDIENTS, GastroStacks.BOK_CHOY, (RecipeType)GastroRecipeType.HARVEST, RecipeUtil.singleCenter((ItemStack)GastroStacks.BOK_CHOY_SEEDS)).register((SlimefunAddon)gn);
        new CropSeed(GastroStacks.BOK_CHOY_SEEDS, Material.POTATOES, RecipeUtil.singleCenter(Material.GRASS), (ItemStack)GastroStacks.BOK_CHOY).register(gn);
        new SlimefunItem((ItemGroup)GastroGroups.RAW_INGREDIENTS, GastroStacks.BROCCOLI, (RecipeType)GastroRecipeType.HARVEST, RecipeUtil.singleCenter((ItemStack)GastroStacks.BROCCOLI_SEEDS)).register((SlimefunAddon)gn);
        new CropSeed(GastroStacks.BROCCOLI_SEEDS, Material.POTATOES, RecipeUtil.singleCenter(Material.GRASS), (ItemStack)GastroStacks.BROCCOLI).register(gn);
        new SlimefunItem((ItemGroup)GastroGroups.RAW_INGREDIENTS, GastroStacks.CUCUMBER, (RecipeType)GastroRecipeType.HARVEST, RecipeUtil.singleCenter((ItemStack)GastroStacks.CUCUMBER_SEEDS)).register((SlimefunAddon)gn);
        new CropSeed(GastroStacks.CUCUMBER_SEEDS, Material.POTATOES, RecipeUtil.singleCenter(Material.GRASS), (ItemStack)GastroStacks.CUCUMBER).register(gn);
        new SlimefunItem((ItemGroup)GastroGroups.RAW_INGREDIENTS, GastroStacks.BASIL, (RecipeType)GastroRecipeType.HARVEST, RecipeUtil.singleCenter((ItemStack)GastroStacks.BASIL_SEEDS)).register((SlimefunAddon)gn);
        new CropSeed(GastroStacks.BASIL_SEEDS, Material.POTATOES, RecipeUtil.singleCenter(Material.GRASS), (ItemStack)GastroStacks.BASIL).register(gn);
        new SlimefunItem((ItemGroup)GastroGroups.RAW_INGREDIENTS, GastroStacks.SPINACH, (RecipeType)GastroRecipeType.HARVEST, RecipeUtil.singleCenter((ItemStack)GastroStacks.SPINACH_SEEDS)).register((SlimefunAddon)gn);
        new CropSeed(GastroStacks.SPINACH_SEEDS, Material.POTATOES, RecipeUtil.singleCenter(Material.GRASS), (ItemStack)GastroStacks.SPINACH).register(gn);
        new SimpleSeed(GastroStacks.BRUSSLES_SPROUTS, Material.POTATOES, RecipeUtil.singleCenter(Material.GRASS)).register(gn);
        new SlimefunItem((ItemGroup)GastroGroups.RAW_INGREDIENTS, GastroStacks.MINT, (RecipeType)GastroRecipeType.HARVEST, RecipeUtil.singleCenter((ItemStack)GastroStacks.MINT_SEEDS)).register((SlimefunAddon)gn);
        new CropSeed(GastroStacks.MINT_SEEDS, Material.POTATOES, RecipeUtil.singleCenter(Material.GRASS), (ItemStack)GastroStacks.MINT).register(gn);
        new SlimefunItem((ItemGroup)GastroGroups.RAW_INGREDIENTS, GastroStacks.CHILI_PEPPER, (RecipeType)GastroRecipeType.HARVEST, RecipeUtil.singleCenter((ItemStack)GastroStacks.CHILI_PEPPER_SEEDS)).register((SlimefunAddon)gn);
        new CropSeed(GastroStacks.CHILI_PEPPER_SEEDS, Material.POTATOES, RecipeUtil.singleCenter(Material.GRASS), (ItemStack)GastroStacks.CHILI_PEPPER).register(gn);
        new SlimefunItem((ItemGroup)GastroGroups.RAW_INGREDIENTS, GastroStacks.PARSLEY, (RecipeType)GastroRecipeType.HARVEST, RecipeUtil.singleCenter((ItemStack)GastroStacks.PARSLEY_SEEDS)).register((SlimefunAddon)gn);
        new CropSeed(GastroStacks.PARSLEY_SEEDS, Material.POTATOES, RecipeUtil.singleCenter(Material.GRASS), (ItemStack)GastroStacks.PARSLEY).register(gn);
        new SimpleSeed(GastroStacks.CASSAVA, Material.BEETROOTS, RecipeUtil.singleCenter(Material.GRASS)).register(gn);
        new SimpleSeed(GastroStacks.LENTILS, Material.CARROTS, RecipeUtil.singleCenter(Material.GRASS)).register(gn);
        new SimpleSeed(GastroStacks.PEANUTS, Material.POTATOES, RecipeUtil.singleCenter(Material.GRASS)).register(gn);
        new SimpleSeed(GastroStacks.BEANS, Material.POTATOES, RecipeUtil.singleCenter(Material.GRASS)).register(gn);
        new SimpleSeed(GastroStacks.PEAS, Material.BEETROOTS, RecipeUtil.singleCenter(Material.GRASS)).register(gn);
        new SlimefunItem((ItemGroup)GastroGroups.RAW_INGREDIENTS, GastroStacks.ASPARAGUS, (RecipeType)GastroRecipeType.HARVEST, RecipeUtil.singleCenter((ItemStack)GastroStacks.ASPARAGUS_SEEDS)).register((SlimefunAddon)gn);
        new CropSeed(GastroStacks.ASPARAGUS_SEEDS, Material.CARROTS, RecipeUtil.singleCenter(Material.GRASS), (ItemStack)GastroStacks.ASPARAGUS).register(gn);
        new SlimefunItem((ItemGroup)GastroGroups.RAW_INGREDIENTS, GastroStacks.GREEN_ONION, (RecipeType)GastroRecipeType.HARVEST, RecipeUtil.singleCenter((ItemStack)GastroStacks.GREEN_ONION_SEEDS)).register((SlimefunAddon)gn);
        new CropSeed(GastroStacks.GREEN_ONION_SEEDS, Material.POTATOES, RecipeUtil.singleCenter(Material.GRASS), (ItemStack)GastroStacks.GREEN_ONION).register(gn);
        new SlimefunItem((ItemGroup)GastroGroups.RAW_INGREDIENTS, GastroStacks.CAULIFLOWER, (RecipeType)GastroRecipeType.HARVEST, RecipeUtil.singleCenter((ItemStack)GastroStacks.CAULIFLOWER_SEEDS)).register((SlimefunAddon)gn);
        new CropSeed(GastroStacks.CAULIFLOWER_SEEDS, Material.POTATOES, RecipeUtil.singleCenter(Material.GRASS), (ItemStack)GastroStacks.CAULIFLOWER).register(gn);
        new SlimefunItem((ItemGroup)GastroGroups.RAW_INGREDIENTS, GastroStacks.AVOCADO, (RecipeType)GastroRecipeType.HARVEST, RecipeUtil.singleCenter((ItemStack)GastroStacks.AVOCADO_PIT)).register((SlimefunAddon)gn);
        new CropSeed(GastroStacks.AVOCADO_PIT, Material.POTATOES, RecipeUtil.singleCenter(Material.GRASS), (ItemStack)GastroStacks.AVOCADO).register(gn);
        new SimpleSeed(GastroStacks.TURMERIC, RecipeUtil.singleCenter(Material.GRASS)).register(gn);
        new SimpleSeed(GastroStacks.CUMIN_SEEDS, Material.POTATOES, RecipeUtil.singleCenter(Material.GRASS)).register(gn);
        new SimpleSeed(GastroStacks.RED_BEANS, Material.POTATOES, RecipeUtil.singleCenter(Material.GRASS)).register(gn);
        new SlimefunItem((ItemGroup)GastroGroups.RAW_INGREDIENTS, GastroStacks.CANTALOUPE, (RecipeType)GastroRecipeType.HARVEST, RecipeUtil.singleCenter((ItemStack)GastroStacks.CANTALOUPE_SEEDS)).register((SlimefunAddon)gn);
        new FruitingSeed(GastroStacks.CANTALOUPE_SEEDS, Material.MELON_STEM, RecipeUtil.singleCenter(Material.GRASS), "GN_CANTALOUPE").register(gn);
        new SlimefunItem((ItemGroup)GastroGroups.RAW_INGREDIENTS, GastroStacks.HONEYDEW_MELON, (RecipeType)GastroRecipeType.HARVEST, RecipeUtil.singleCenter((ItemStack)GastroStacks.HONEYDEW_MELON_SEEDS)).register((SlimefunAddon)gn);
        new FruitingSeed(GastroStacks.HONEYDEW_MELON_SEEDS, Material.MELON_STEM, RecipeUtil.singleCenter(Material.GRASS), "GN_HONEYDEW_MELON").register(gn);
        new SimpleSeed(GastroStacks.SESAME_SEEDS, Material.POTATOES, RecipeUtil.singleCenter(Material.GRASS)).register(gn);
        new UnplaceableSolid(GastroGroups.RAW_INGREDIENTS, GastroStacks.VANILLA_BEANS, GastroRecipeType.BREAK, RecipeUtil.singleCenter((ItemStack)GastroStacks.VANILLA_PLANT)).register(gn);
        new VineSeed(GastroStacks.VANILLA_PLANT, RecipeUtil.singleCenter(Material.GRASS), new ItemStack[]{GastroStacks.VANILLA_BEANS}).register(gn);
        new UnplaceableSolid(GastroGroups.RAW_INGREDIENTS, GastroStacks.LYCHEE, GastroRecipeType.BREAK, RecipeUtil.singleCenter((ItemStack)GastroStacks.LYCHEE_SAPLING)).register(gn);
        new SimpleSapling(GastroGroups.RAW_INGREDIENTS, GastroStacks.LYCHEE_SAPLING, GastroRecipeType.BREAK, RecipeUtil.singleCenter(Material.GRASS)).register(gn);
        new UnplaceableSolid(GastroGroups.RAW_INGREDIENTS, GastroStacks.BANANA, GastroRecipeType.BREAK, RecipeUtil.singleCenter((ItemStack)GastroStacks.BANANA_SAPLING)).register(gn);
        new SimpleSapling(GastroGroups.RAW_INGREDIENTS, GastroStacks.BANANA_SAPLING, GastroRecipeType.BREAK, RecipeUtil.singleCenter(Material.GRASS)).register(gn);
        new UnplaceableSolid(GastroGroups.RAW_INGREDIENTS, GastroStacks.FIDDLEHEADS, GastroRecipeType.BREAK, RecipeUtil.singleCenter(Material.FERN)).register(gn);
        new UnplaceableSolid(GastroGroups.RAW_INGREDIENTS, GastroStacks.TRUFFLE, GastroRecipeType.BREAK, RecipeUtil.singleCenter(Material.PODZOL)).register(gn);
        new UnplaceableSolid(GastroGroups.RAW_INGREDIENTS, GastroStacks.ENOKI_MUSHROOMS, GastroRecipeType.BREAK, RecipeUtil.singleCenter(Material.DIRT)).register(gn);
        new UnplaceableSolid(GastroGroups.RAW_INGREDIENTS, GastroStacks.KING_OYSTER_MUSHROOM, GastroRecipeType.BREAK, RecipeUtil.singleCenter(Material.DIRT)).register(gn);
        new UnplaceableSolid(GastroGroups.RAW_INGREDIENTS, GastroStacks.BUTTON_MUSHROOM, GastroRecipeType.BREAK, RecipeUtil.singleCenter(Material.DIRT)).register(gn);
        new UnplaceableSolid(GastroGroups.RAW_INGREDIENTS, GastroStacks.CLAM, GastroRecipeType.BREAK, RecipeUtil.singleCenter(Material.SEAGRASS)).register(gn);
        new UnplaceableSolid(GastroGroups.RAW_INGREDIENTS, GastroStacks.RAW_CHEVON, GastroRecipeType.KILL, RecipeUtil.singleCenter(GastroStacks.GUIDE_KILL_GOAT)).register(gn);
        new SimpleGastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).group(GastroGroups.RAW_INGREDIENTS).item(GastroStacks.COOKED_CHEVON).ingredients(new ItemStack[]{GastroStacks.RAW_CHEVON}).tools(new ItemStack[]{GastroStacks.FRYING_PAN}).register(gn);
        new UnplaceableSolid(GastroGroups.RAW_INGREDIENTS, GastroStacks.SALMON_ROE, GastroRecipeType.KILL, RecipeUtil.singleCenter(GastroStacks.GUIDE_KILL_SALMON)).register(gn);
        new UnplaceableSolid(GastroGroups.RAW_INGREDIENTS, GastroStacks.GUARDIAN_FIN, GastroRecipeType.KILL, RecipeUtil.singleCenter(GastroStacks.GUIDE_KILL_GUARDIAN)).register(gn);
        new UnplaceableSolid(GastroGroups.RAW_INGREDIENTS, GastroStacks.RAW_SQUID, GastroRecipeType.KILL, RecipeUtil.singleCenter(GastroStacks.GUIDE_KILL_SQUID)).register(gn);
        new SimpleGastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).group(GastroGroups.RAW_INGREDIENTS).item(GastroStacks.COOKED_SQUID).ingredients(new ItemStack[]{GastroStacks.RAW_SQUID}).tools(new ItemStack[]{GastroStacks.FRYING_PAN}).register(gn);
        new UnplaceableSolid(GastroGroups.RAW_INGREDIENTS, GastroStacks.RAW_MACKEREL, GastroRecipeType.TRAP, RecipeUtil.singleCenter(GastroStacks.DUMMY_FISHING_NET)).register(gn);
        new SimpleGastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).group(GastroGroups.RAW_INGREDIENTS).item(GastroStacks.COOKED_MACKEREL).ingredients(new ItemStack[]{GastroStacks.RAW_MACKEREL}).tools(new ItemStack[]{GastroStacks.FRYING_PAN}).register(gn);
        new UnplaceableSolid(GastroGroups.RAW_INGREDIENTS, GastroStacks.RAW_EEL, GastroRecipeType.TRAP, RecipeUtil.singleCenter(GastroStacks.DUMMY_FISHING_NET)).register(gn);
        new SimpleGastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).group(GastroGroups.RAW_INGREDIENTS).item(GastroStacks.COOKED_EEL).ingredients(new ItemStack[]{GastroStacks.RAW_EEL}).tools(new ItemStack[]{GastroStacks.FRYING_PAN}).register(gn);
        new UnplaceableSolid(GastroGroups.RAW_INGREDIENTS, GastroStacks.RAW_TROUT, GastroRecipeType.TRAP, RecipeUtil.singleCenter(GastroStacks.DUMMY_FISHING_NET)).register(gn);
        new SimpleGastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).group(GastroGroups.RAW_INGREDIENTS).item(GastroStacks.COOKED_TROUT).ingredients(new ItemStack[]{GastroStacks.RAW_TROUT}).tools(new ItemStack[]{GastroStacks.FRYING_PAN}).register(gn);
        new UnplaceableSolid(GastroGroups.RAW_INGREDIENTS, GastroStacks.RAW_BASS, GastroRecipeType.TRAP, RecipeUtil.singleCenter(GastroStacks.DUMMY_FISHING_NET)).register(gn);
        new SimpleGastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).group(GastroGroups.RAW_INGREDIENTS).item(GastroStacks.COOKED_BASS).ingredients(new ItemStack[]{GastroStacks.RAW_BASS}).tools(new ItemStack[]{GastroStacks.FRYING_PAN}).register(gn);
        new UnplaceableSolid(GastroGroups.RAW_INGREDIENTS, GastroStacks.RAW_CARP, GastroRecipeType.TRAP, RecipeUtil.singleCenter(GastroStacks.DUMMY_FISHING_NET)).register(gn);
        new SimpleGastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).group(GastroGroups.RAW_INGREDIENTS).item(GastroStacks.COOKED_CARP).ingredients(new ItemStack[]{GastroStacks.RAW_CARP}).tools(new ItemStack[]{GastroStacks.FRYING_PAN}).register(gn);
        new UnplaceableSolid(GastroGroups.RAW_INGREDIENTS, GastroStacks.RAW_PIKE, GastroRecipeType.TRAP, RecipeUtil.singleCenter(GastroStacks.DUMMY_FISHING_NET)).register(gn);
        new SimpleGastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).group(GastroGroups.RAW_INGREDIENTS).item(GastroStacks.COOKED_PIKE).ingredients(new ItemStack[]{GastroStacks.RAW_PIKE}).tools(new ItemStack[]{GastroStacks.FRYING_PAN}).register(gn);
        new UnplaceableSolid(GastroGroups.RAW_INGREDIENTS, GastroStacks.RAW_TUNA, GastroRecipeType.TRAP, RecipeUtil.singleCenter(GastroStacks.DUMMY_FISHING_NET)).register(gn);
        new SimpleGastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).group(GastroGroups.RAW_INGREDIENTS).item(GastroStacks.COOKED_TUNA).ingredients(new ItemStack[]{GastroStacks.RAW_TUNA}).tools(new ItemStack[]{GastroStacks.FRYING_PAN}).register(gn);
        new UnplaceableSolid(GastroGroups.RAW_INGREDIENTS, GastroStacks.SHRIMP, GastroRecipeType.TRAP, RecipeUtil.singleCenter(GastroStacks.DUMMY_FISHING_NET)).register(gn);
        new UnplaceableSolid(GastroGroups.RAW_INGREDIENTS, GastroStacks.CRAB, GastroRecipeType.TRAP, RecipeUtil.singleCenter((ItemStack)GastroStacks.CRAB_TRAP)).register(gn);
        new UnplaceableSolid(GastroGroups.RAW_INGREDIENTS, GastroStacks.RAW_TURKEY, GastroRecipeType.TRAP, RecipeUtil.singleCenter((ItemStack)GastroStacks.HUNTING_TRAP)).register(gn);
        new SimpleGastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).group(GastroGroups.RAW_INGREDIENTS).item(GastroStacks.COOKED_TURKEY).ingredients(new ItemStack[]{GastroStacks.RAW_TURKEY}).tools(new ItemStack[]{GastroStacks.FRYING_PAN}).register(gn);
        new SimpleGastroFoodBuilder().item(GastroStacks.COOKED_RICE).type(GastroRecipeType.MULTI_STOVE).ingredients(new ItemStack[]{GastroStacks.RICE}).tools(new ItemStack[]{GastroStacks.STEEL_POT}).register(gn);
        new SimpleGastroFoodBuilder().item(GastroStacks.BARLEY_FLOUR).type(GastroRecipeType.MILL).ingredients(new ItemStack[]{GastroStacks.BARLEY}).register(gn);
        new SimpleGastroFoodBuilder().item(GastroStacks.SORGHUM_FLOUR).type(GastroRecipeType.MILL).ingredients(new ItemStack[]{GastroStacks.SORGHUM}).register(gn);
        new SimpleGastroFoodBuilder().item(GastroStacks.RYE_FLOUR).type(GastroRecipeType.MILL).ingredients(new ItemStack[]{GastroStacks.RYE}).register(gn);
        new SimpleGastroFoodBuilder().item(GastroStacks.DOUGH).type(GastroRecipeType.CULINARY_WORKBENCH).ingredients(new ItemStack[]{SlimefunItems.WHEAT_FLOUR, GastroStacks.WATER_BOTTLE}).temperature(MultiStove.Temperature.LOW).register(gn);
        RecipeRegistry.registerRecipe(new ShapedGastroRecipe(GastroRecipeType.CULINARY_WORKBENCH, RecipeUtil.collection(new ItemStack[]{GastroStacks.BARLEY_FLOUR, GastroStacks.WATER_BOTTLE}), new HashSet<ItemStack>(), new ItemStack[]{GastroStacks.DOUGH}));
        RecipeRegistry.registerRecipe(new ShapedGastroRecipe(GastroRecipeType.CULINARY_WORKBENCH, RecipeUtil.collection(new ItemStack[]{GastroStacks.RYE_FLOUR, GastroStacks.WATER_BOTTLE}), new HashSet<ItemStack>(), new ItemStack[]{GastroStacks.DOUGH}));
        RecipeRegistry.registerRecipe(new ShapedGastroRecipe(GastroRecipeType.CULINARY_WORKBENCH, RecipeUtil.collection(new ItemStack[]{GastroStacks.SORGHUM_FLOUR, GastroStacks.WATER_BOTTLE}), new HashSet<ItemStack>(), new ItemStack[]{GastroStacks.DOUGH}));
        new SimpleGastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.TOAST).ingredients(BREAD).temperature(MultiStove.Temperature.LOW).register(gn);
        new SimpleGastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.NAAN_BREAD).ingredients(new ItemStack[]{GastroStacks.DOUGH}).tools(new ItemStack[]{GastroStacks.ROLLING_PIN}).register(gn);
        new SimpleGastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.PEANUT_BUTTER).ingredients(new ItemStack[]{GastroStacks.PEANUTS}).temperature(MultiStove.Temperature.LOW).register(gn);
        new SimpleGastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.FRIED_EGG).ingredients(EGG).temperature(MultiStove.Temperature.LOW).tools(new ItemStack[]{GastroStacks.FRYING_PAN}).register(gn);
        new SimpleGastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.HARD_BOILED_EGG).ingredients(EGG, WATER_BUCKET).temperature(MultiStove.Temperature.LOW).tools(new ItemStack[]{GastroStacks.STEEL_POT}).register(gn);
        new SimpleGastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.SCRAMBLED_EGGS).ingredients(EGG).tools(new ItemStack[]{GastroStacks.FRYING_PAN, GastroStacks.WHISK}).register(gn);
        new SimpleGastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.CUSTARD).ingredients(EGG, MILK_BUCKET, SUGAR).tools(new ItemStack[]{GastroStacks.FRYING_PAN}).register(gn);
        new SimpleGastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.CARAMEL).ingredients(SUGAR).temperature(MultiStove.Temperature.LOW).tools(new ItemStack[]{GastroStacks.FRYING_PAN}).register(gn);
        if (egAvailable) {
            new SimpleGastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.MARMALADE).ingredients(ORANGE, SUGAR).container(GastroStacks.WATER_BOTTLE).temperature(MultiStove.Temperature.LOW).register(gn);
            new SimpleGastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.KETCHUP).ingredients(TOMATO, SUGAR).container(GastroStacks.WATER_BOTTLE).temperature(MultiStove.Temperature.LOW).register(gn);
        }
        new SimpleGastroFoodBuilder().type(GastroRecipeType.CULINARY_WORKBENCH).item(GastroStacks.PULLED_PORK).ingredients(COOKED_PORKCHOP).register(gn);
        new SimpleGastroFoodBuilder().type(GastroRecipeType.CULINARY_WORKBENCH).item(GastroStacks.GROUND_BEEF).ingredients(COOKED_BEEF).register(gn);
        new SimpleGastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.BAKED_BEANS).ingredients(new ItemStack[]{GastroStacks.BEANS}).temperature(MultiStove.Temperature.LOW).tools(new ItemStack[]{GastroStacks.BAKING_TRAY}).register(gn);
        new SimpleGastroFoodBuilder().type(GastroRecipeType.FERMENTER).item(GastroStacks.MISO).ingredients(new ItemStack[]{GastroStacks.SOYBEANS, SlimefunItems.SALT, GastroStacks.RICE}).register(gn);
        new SimpleGastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.TOFU).ingredients(new ItemStack[]{GastroStacks.SOYBEANS, WATER_BUCKET}).tools(new ItemStack[]{GastroStacks.BLENDER}).register(gn);
        new SimpleGastroFoodBuilder().type(GastroRecipeType.FERMENTER).item(GastroStacks.SOY_SAUCE).ingredients(new ItemStack[]{GastroStacks.SOYBEANS}).register(gn);
        new SimpleGastroFoodBuilder().type(GastroRecipeType.CULINARY_WORKBENCH).item(GastroStacks.TURMERIC_POWDER).ingredients(new ItemStack[]{GastroStacks.TURMERIC}).tools(new ItemStack[]{GastroStacks.MORTAR_AND_PESTLE}).register(gn);
        new SimpleGastroFoodBuilder().type(GastroRecipeType.CULINARY_WORKBENCH).item(GastroStacks.RED_BEAN_PASTE).ingredients(new ItemStack[]{GastroStacks.RED_BEANS}).tools(new ItemStack[]{GastroStacks.MORTAR_AND_PESTLE}).register(gn);
        new SimpleGastroFoodBuilder().type(GastroRecipeType.CULINARY_WORKBENCH).item(GastroStacks.TAPIOCA_STARCH).ingredients(new ItemStack[]{GastroStacks.CASSAVA}).tools(new ItemStack[]{GastroStacks.MORTAR_AND_PESTLE}).register(gn);
        new SimpleGastroFoodBuilder().type(GastroRecipeType.CULINARY_WORKBENCH).item(GastroStacks.TAPIOCA_PEARLS).ingredients(new ItemStack[]{GastroStacks.TAPIOCA_STARCH, WATER_BUCKET}).tools(new ItemStack[]{GastroStacks.MULTI_STOVE}).temperature(MultiStove.Temperature.LOW).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.CULINARY_WORKBENCH).item(GastroStacks.PBJ_SANDWICH).shape(GastroRecipe.RecipeShape.SHAPED).ingredients(new ItemStack[]{null, GastroStacks.TOAST, null, GastroStacks.PEANUT_BUTTER, APPLE, GastroStacks.PEANUT_BUTTER, null, GastroStacks.TOAST, null}).register(gn);
        if (egAvailable) {
            new GastroFoodBuilder().type(GastroRecipeType.CULINARY_WORKBENCH).item(GastroStacks.MARMALADE_SANDWICH).shape(GastroRecipe.RecipeShape.SHAPED).ingredients(new ItemStack[]{null, GastroStacks.TOAST, null, GastroStacks.MARMALADE, GastroStacks.MARMALADE, GastroStacks.MARMALADE, null, GastroStacks.TOAST, null}).register(gn);
        }
        new GastroFoodBuilder().type(GastroRecipeType.CULINARY_WORKBENCH).item(GastroStacks.BAKED_BEANS_AND_TOAST).shape(GastroRecipe.RecipeShape.SHAPED).ingredients(new ItemStack[]{null, null, null, null, GastroStacks.BAKED_BEANS, null, null, GastroStacks.TOAST, null}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.CULINARY_WORKBENCH).item(GastroStacks.AVOCADO_TOAST).shape(GastroRecipe.RecipeShape.SHAPED).ingredients(new ItemStack[]{null, null, null, null, GastroStacks.AVOCADO, null, null, GastroStacks.TOAST, null}).register(gn);
        if (egAvailable) {
            new GastroFoodBuilder().type(GastroRecipeType.CULINARY_WORKBENCH).item(GastroStacks.TUNA_SANDWICH).shape(GastroRecipe.RecipeShape.SHAPED).ingredients(new ItemStack[]{null, GastroStacks.TOAST, null, GastroStacks.COOKED_TUNA, LETTUCE, MAYO, null, GastroStacks.TOAST, null}).register(gn);
        }
        new GastroFoodBuilder().type(GastroRecipeType.CULINARY_WORKBENCH).item(GastroStacks.BREAKFAST_SANDWICH).shape(GastroRecipe.RecipeShape.SHAPED).ingredients(new ItemStack[]{null, GastroStacks.TOAST, null, GastroStacks.FRIED_EGG, COOKED_PORKCHOP, GastroStacks.FRIED_EGG, null, GastroStacks.TOAST, null}).register(gn);
        if (egAvailable) {
            new GastroFoodBuilder().type(GastroRecipeType.CULINARY_WORKBENCH).item(GastroStacks.HAM_SANDWICH).shape(GastroRecipe.RecipeShape.SHAPED).ingredients(new ItemStack[]{null, GastroStacks.TOAST, null, LETTUCE, COOKED_PORKCHOP, MAYO, null, GastroStacks.TOAST, null}).register(gn);
        }
        new GastroFoodBuilder().type(GastroRecipeType.CULINARY_WORKBENCH).item(GastroStacks.ROAST_BEEF_SANDWICH).shape(GastroRecipe.RecipeShape.SHAPED).ingredients(new ItemStack[]{null, GastroStacks.TOAST, null, GastroStacks.FRIED_EGG, COOKED_BEEF, GastroStacks.FRIED_EGG, null, GastroStacks.TOAST, null}).register(gn);
        if (egAvailable) {
            new GastroFoodBuilder().type(GastroRecipeType.CULINARY_WORKBENCH).item(GastroStacks.EGG_SALAD_SANDWICH).shape(GastroRecipe.RecipeShape.SHAPED).ingredients(new ItemStack[]{null, GastroStacks.TOAST, null, LETTUCE, GastroStacks.SCRAMBLED_EGGS, MAYO, null, GastroStacks.TOAST, null}).register(gn);
            new GastroFoodBuilder().type(GastroRecipeType.CULINARY_WORKBENCH).item(GastroStacks.GREEK_SALAD).shape(GastroRecipe.RecipeShape.SHAPELESS).ingredients(new ItemStack[]{TOMATO, GastroStacks.CUCUMBER, ONION, SlimefunItems.CHEESE}).container(BOWL).tools(new ItemStack[]{GastroStacks.KITCHEN_KNIFE}).register(gn);
            new GastroFoodBuilder().type(GastroRecipeType.CULINARY_WORKBENCH).item(GastroStacks.CAESAR_SALAD).shape(GastroRecipe.RecipeShape.SHAPELESS).ingredients(new ItemStack[]{LETTUCE, GastroStacks.TOAST, BACON, SlimefunItems.CHEESE}).container(BOWL).tools(new ItemStack[]{GastroStacks.KITCHEN_KNIFE}).register(gn);
        }
        new GastroFoodBuilder().type(GastroRecipeType.CULINARY_WORKBENCH).item(GastroStacks.FIDDLEHEAD_SALAD).shape(GastroRecipe.RecipeShape.SHAPELESS).ingredients(new ItemStack[]{GastroStacks.FIDDLEHEADS, GastroStacks.MINT, GastroStacks.ASPARAGUS}).container(BOWL).tools(new ItemStack[]{GastroStacks.KITCHEN_KNIFE}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.PAN_SEARED_SALMON).ingredients(SALMON).tools(new ItemStack[]{GastroStacks.FRYING_PAN}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.FRIED_SHRIMP).ingredients(new ItemStack[]{GastroStacks.SHRIMP}).tools(new ItemStack[]{GastroStacks.FRYING_PAN}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.TEMPURA_SHRIMP).ingredients(new ItemStack[]{GastroStacks.SHRIMP, BREAD}).tools(new ItemStack[]{GastroStacks.FRYING_PAN}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.TEMPURA_BROCCOLI).ingredients(new ItemStack[]{GastroStacks.BROCCOLI, BREAD}).tools(new ItemStack[]{GastroStacks.FRYING_PAN}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.CHICKEN_PESTO_PASTA).ingredients(new ItemStack[]{GastroStacks.DOUGH, GastroStacks.BASIL, CHICKEN, SlimefunItems.CHEESE, WATER_BUCKET}).container(BOWL).tools(new ItemStack[]{GastroStacks.STEEL_POT, GastroStacks.ROLLING_PIN, GastroStacks.MORTAR_AND_PESTLE}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.SQUID_INK_PASTA).ingredients(new ItemStack[]{GastroStacks.DOUGH, GastroStacks.BASIL, INK_SAC, SlimefunItems.CHEESE, WATER_BUCKET}).container(BOWL).tools(new ItemStack[]{GastroStacks.FRYING_PAN, GastroStacks.ROLLING_PIN}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.GLOWING_SQUID_INK_PASTA).ingredients(new ItemStack[]{GastroStacks.DOUGH, GastroStacks.BASIL, GLOW_INK_SAC, SlimefunItems.CHEESE, WATER_BUCKET}).container(BOWL).tools(new ItemStack[]{GastroStacks.FRYING_PAN, GastroStacks.ROLLING_PIN}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.TUNA_CASSEROLE).ingredients(new ItemStack[]{GastroStacks.DOUGH, GastroStacks.RAW_TUNA, GastroStacks.CREAM_OF_MUSHROOM_SOUP, GastroStacks.PEAS}).tools(new ItemStack[]{GastroStacks.ROLLING_PIN, GastroStacks.BAKING_TRAY}).register(gn);
        if (egAvailable) {
            new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.CHICKEN_RAVIOLI).ingredients(new ItemStack[]{GastroStacks.DOUGH, GastroStacks.BASIL, CHICKEN, SlimefunItems.CHEESE, TOMATO, WATER_BUCKET}).container(BOWL).tools(new ItemStack[]{GastroStacks.FRYING_PAN, GastroStacks.ROLLING_PIN}).register(gn);
            new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.MUSHROOM_RAVIOLI).ingredients(new ItemStack[]{GastroStacks.DOUGH, GastroStacks.BASIL, GastroStacks.BUTTON_MUSHROOM, SlimefunItems.CHEESE, TOMATO, WATER_BUCKET}).container(BOWL).tools(new ItemStack[]{GastroStacks.STEEL_POT, GastroStacks.ROLLING_PIN}).register(gn);
        }
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.OATMEAL).ingredients(new ItemStack[]{WATER_BUCKET, GastroStacks.OATS}).container(BOWL).temperature(MultiStove.Temperature.LOW).tools(new ItemStack[]{GastroStacks.STEEL_POT}).register(gn);
        RecipeRegistry.registerRecipe(new MultiStoveRecipe(RecipeUtil.collection(new ItemStack[]{MILK_BUCKET, GastroStacks.OATS}), BOWL, Set.of(GastroStacks.STEEL_POT), MultiStove.Temperature.LOW, new ItemStack[]{GastroStacks.OATMEAL}));
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.BARLEY_PORRIDGE).ingredients(new ItemStack[]{WATER_BUCKET, GastroStacks.BARLEY}).container(BOWL).temperature(MultiStove.Temperature.LOW).tools(new ItemStack[]{GastroStacks.STEEL_POT}).register(gn);
        RecipeRegistry.registerRecipe(new MultiStoveRecipe(RecipeUtil.collection(new ItemStack[]{MILK_BUCKET, GastroStacks.BARLEY}), BOWL, Set.of(GastroStacks.STEEL_POT), MultiStove.Temperature.LOW, new ItemStack[]{GastroStacks.BARLEY_PORRIDGE}));
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.CONGEE).ingredients(new ItemStack[]{WATER_BUCKET, GastroStacks.RICE}).container(BOWL).temperature(MultiStove.Temperature.LOW).tools(new ItemStack[]{GastroStacks.STEEL_POT}).register(gn);
        RecipeRegistry.registerRecipe(new MultiStoveRecipe(RecipeUtil.collection(new ItemStack[]{MILK_BUCKET, GastroStacks.RICE}), BOWL, Set.of(GastroStacks.STEEL_POT), MultiStove.Temperature.LOW, new ItemStack[]{GastroStacks.CONGEE}));
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.CHICKEN_SOUP).ingredients(new ItemStack[]{WATER_BUCKET, CHICKEN, CARROT, GastroStacks.PEAS}).container(BOWL).tools(new ItemStack[]{GastroStacks.STEEL_POT, GastroStacks.KITCHEN_KNIFE, GastroStacks.PEELER}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.CHICKEN_AND_QUINOA_SOUP).ingredients(new ItemStack[]{WATER_BUCKET, CHICKEN, CARROT, GastroStacks.PEAS, GastroStacks.QUINOA}).container(BOWL).tools(new ItemStack[]{GastroStacks.STEEL_POT, GastroStacks.KITCHEN_KNIFE, GastroStacks.PEELER}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.CHICKEN_NOODLE_SOUP).ingredients(new ItemStack[]{WATER_BUCKET, CHICKEN, CARROT, GastroStacks.PEAS, GastroStacks.DOUGH}).container(BOWL).tools(new ItemStack[]{GastroStacks.STEEL_POT, GastroStacks.KITCHEN_KNIFE, GastroStacks.PEELER}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.CHICKEN_NOODLE_SOUP_WITH_BOK_HOY).ingredients(new ItemStack[]{WATER_BUCKET, CHICKEN, CARROT, GastroStacks.PEAS, GastroStacks.DOUGH, GastroStacks.BOK_CHOY}).container(BOWL).tools(new ItemStack[]{GastroStacks.STEEL_POT, GastroStacks.KITCHEN_KNIFE, GastroStacks.PEELER}).register(gn);
        if (egAvailable) {
            new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.SPLIT_PEA_SOUP).ingredients(new ItemStack[]{WATER_BUCKET, CARROT, GastroStacks.PEAS, ONION}).container(BOWL).tools(new ItemStack[]{GastroStacks.STEEL_POT, GastroStacks.KITCHEN_KNIFE, GastroStacks.PEELER}).register(gn);
            new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.HAM_AND_SPLIT_PEA_SOUP).ingredients(new ItemStack[]{WATER_BUCKET, CARROT, GastroStacks.PEAS, ONION, PORKCHOP}).container(BOWL).tools(new ItemStack[]{GastroStacks.STEEL_POT, GastroStacks.KITCHEN_KNIFE, GastroStacks.PEELER}).register(gn);
        }
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.LENTIL_SOUP).ingredients(new ItemStack[]{WATER_BUCKET, CARROT, GastroStacks.LENTILS, GastroStacks.CELERY, GastroStacks.BASIL}).container(BOWL).tools(new ItemStack[]{GastroStacks.STEEL_POT, GastroStacks.KITCHEN_KNIFE, GastroStacks.PEELER}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.BEEF_AND_LENTIL_SOUP).ingredients(new ItemStack[]{WATER_BUCKET, CARROT, GastroStacks.LENTILS, GastroStacks.CELERY, GastroStacks.BASIL, BEEF}).container(BOWL).tools(new ItemStack[]{GastroStacks.STEEL_POT, GastroStacks.KITCHEN_KNIFE, GastroStacks.PEELER}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.CARROT_SOUP).ingredients(new ItemStack[]{WATER_BUCKET, CARROT, POTATO, GastroStacks.PEAS, GastroStacks.CELERY}).container(BOWL).tools(new ItemStack[]{GastroStacks.STEEL_POT, GastroStacks.KITCHEN_KNIFE, GastroStacks.PEELER}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.MUSHROOM_BARLEY_SOUP).ingredients(new ItemStack[]{WATER_BUCKET, GastroStacks.BARLEY, GastroStacks.BUTTON_MUSHROOM, GastroStacks.PEAS, GastroStacks.CELERY}).container(BOWL).tools(new ItemStack[]{GastroStacks.STEEL_POT, GastroStacks.KITCHEN_KNIFE}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.CHICKEN_BARLEY_SOUP).ingredients(new ItemStack[]{WATER_BUCKET, GastroStacks.BARLEY, CHICKEN, GastroStacks.PEAS, CARROT}).container(BOWL).tools(new ItemStack[]{GastroStacks.STEEL_POT, GastroStacks.KITCHEN_KNIFE, GastroStacks.PEELER}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.BEEF_BARLEY_SOUP).ingredients(new ItemStack[]{WATER_BUCKET, GastroStacks.BARLEY, COOKED_BEEF, GastroStacks.BROCCOLI, GastroStacks.CELERY}).container(BOWL).tools(new ItemStack[]{GastroStacks.STEEL_POT, GastroStacks.KITCHEN_KNIFE}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.CREAM_OF_MUSHROOM_SOUP).ingredients(new ItemStack[]{MILK_BUCKET, SlimefunItems.BUTTER, GastroStacks.BUTTON_MUSHROOM, GastroStacks.CELERY}).container(BOWL).tools(new ItemStack[]{GastroStacks.STEEL_POT, GastroStacks.KITCHEN_KNIFE}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.CREAM_OF_BROCCOLI_SOUP).ingredients(new ItemStack[]{MILK_BUCKET, SlimefunItems.BUTTER, GastroStacks.BROCCOLI, GastroStacks.CELERY}).container(BOWL).tools(new ItemStack[]{GastroStacks.STEEL_POT, GastroStacks.KITCHEN_KNIFE}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.CREAM_OF_ASPARAGUS_SOUP).ingredients(new ItemStack[]{MILK_BUCKET, SlimefunItems.BUTTER, GastroStacks.ASPARAGUS, GastroStacks.CELERY}).container(BOWL).tools(new ItemStack[]{GastroStacks.STEEL_POT, GastroStacks.KITCHEN_KNIFE}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.CREAM_OF_CAULIFLOWER_SOUP).ingredients(new ItemStack[]{MILK_BUCKET, SlimefunItems.BUTTER, GastroStacks.CAULIFLOWER, GastroStacks.CELERY}).container(BOWL).tools(new ItemStack[]{GastroStacks.STEEL_POT, GastroStacks.KITCHEN_KNIFE}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.MISO_SOUP).ingredients(new ItemStack[]{WATER_BUCKET, KELP, GastroStacks.MISO}).container(BOWL).tools(new ItemStack[]{GastroStacks.STEEL_POT, GastroStacks.KITCHEN_KNIFE}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.GUARDIAN_FIN_SOUP).ingredients(new ItemStack[]{WATER_BUCKET, CARROT, GastroStacks.PEAS, GastroStacks.GUARDIAN_FIN}).container(BOWL).tools(new ItemStack[]{GastroStacks.STEEL_POT, GastroStacks.KITCHEN_KNIFE}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.BROCCOLI_CHOWDER).ingredients(new ItemStack[]{MILK_BUCKET, SlimefunItems.HEAVY_CREAM, GastroStacks.SHRIMP, GastroStacks.BASIL, GastroStacks.BROCCOLI}).container(BOWL).tools(new ItemStack[]{GastroStacks.STEEL_POT, GastroStacks.KITCHEN_KNIFE}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.SALMON_CHOWDER).ingredients(new ItemStack[]{MILK_BUCKET, SlimefunItems.HEAVY_CREAM, GastroStacks.SHRIMP, GastroStacks.BASIL, SALMON}).container(BOWL).tools(new ItemStack[]{GastroStacks.STEEL_POT, GastroStacks.KITCHEN_KNIFE}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.POTATO_CHOWDER).ingredients(new ItemStack[]{MILK_BUCKET, SlimefunItems.HEAVY_CREAM, GastroStacks.SHRIMP, GastroStacks.BASIL, POTATO}).container(BOWL).tools(new ItemStack[]{GastroStacks.STEEL_POT, GastroStacks.KITCHEN_KNIFE, GastroStacks.PEELER}).register(gn);
        if (egAvailable) {
            new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.CORN_CHOWDER).ingredients(new ItemStack[]{MILK_BUCKET, SlimefunItems.HEAVY_CREAM, GastroStacks.SHRIMP, GastroStacks.BASIL, CORN}).container(BOWL).tools(new ItemStack[]{GastroStacks.STEEL_POT, GastroStacks.KITCHEN_KNIFE}).register(gn);
        }
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.BEEF_STEW).ingredients(new ItemStack[]{WATER_BUCKET, POTATO, CARROT, BEEF, GastroStacks.CELERY}).container(BOWL).tools(new ItemStack[]{GastroStacks.STEEL_POT, GastroStacks.KITCHEN_KNIFE, GastroStacks.PEELER}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.CLAM_STEW).ingredients(new ItemStack[]{WATER_BUCKET, POTATO, CARROT, GastroStacks.CLAM, GastroStacks.CELERY}).container(BOWL).tools(new ItemStack[]{GastroStacks.STEEL_POT, GastroStacks.KITCHEN_KNIFE, GastroStacks.PEELER}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.CRAB_HOTPOT).ingredients(new ItemStack[]{WATER_BUCKET, GastroStacks.ENOKI_MUSHROOMS, GastroStacks.KING_OYSTER_MUSHROOM, CARROT, GastroStacks.CRAB, EGG, GastroStacks.GREEN_ONION}).container(BOWL).tools(new ItemStack[]{GastroStacks.STEEL_POT, GastroStacks.KITCHEN_KNIFE, GastroStacks.PEELER}).register(gn);
        if (egAvailable) {
            new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.BBQ_STEAK).ingredients(BBQ_SAUCE, BEEF).temperature(MultiStove.Temperature.HIGH).register(gn);
            new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.BBQ_PORK).ingredients(BBQ_SAUCE, PORKCHOP).temperature(MultiStove.Temperature.HIGH).register(gn);
            new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.BBQ_CHICKEN).ingredients(BBQ_SAUCE, CHICKEN).temperature(MultiStove.Temperature.HIGH).register(gn);
            new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.BBQ_MUTTON).ingredients(BBQ_SAUCE, MUTTON).temperature(MultiStove.Temperature.HIGH).register(gn);
            new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.BUTTER_CHICKEN).ingredients(new ItemStack[]{CHICKEN, CARROT, GastroStacks.TURMERIC_POWDER, GARLIC, TOMATO, GastroStacks.CUMIN_SEEDS, GastroStacks.CHILI_PEPPER}).container(BOWL).tools(new ItemStack[]{GastroStacks.STEEL_POT, GastroStacks.KITCHEN_KNIFE, GastroStacks.PEELER}).register(gn);
            new GastroFoodBuilder().type(GastroRecipeType.CULINARY_WORKBENCH).item(GastroStacks.BUTTER_CHICKEN_WITH_NAAN_BREAD).ingredients(new ItemStack[]{GastroStacks.BUTTER_CHICKEN, CILANTRO, GastroStacks.NAAN_BREAD}).register(gn);
            new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.SHRIMP_FRIED_RICE).ingredients(new ItemStack[]{GastroStacks.SHRIMP, GastroStacks.COOKED_RICE, CARROT, GastroStacks.PEAS, CORN, GastroStacks.GREEN_ONION}).container(BOWL).tools(new ItemStack[]{GastroStacks.FRYING_PAN, GastroStacks.KITCHEN_KNIFE, GastroStacks.PEELER}).register(gn);
            new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.CURRY_RICE).ingredients(new ItemStack[]{POTATO, GastroStacks.COOKED_RICE, CARROT, CURRY_LEAF, COOKED_BEEF}).container(BOWL).tools(new ItemStack[]{GastroStacks.FRYING_PAN, GastroStacks.KITCHEN_KNIFE, GastroStacks.PEELER}).register(gn);
            new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.RICE_OMELETTE).ingredients(new ItemStack[]{GastroStacks.COOKED_RICE, EGG, GastroStacks.KETCHUP}).container(BOWL).tools(new ItemStack[]{GastroStacks.FRYING_PAN, GastroStacks.KITCHEN_KNIFE, GastroStacks.PEELER}).register(gn);
        }
        new GastroFoodBuilder().type(GastroRecipeType.CULINARY_WORKBENCH).item(GastroStacks.RICE_BALL).amount(3).ingredients(new ItemStack[]{GastroStacks.COOKED_RICE, DRIED_KELP}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.BEEF_UDON).ingredients(new ItemStack[]{GastroStacks.DOUGH, BEEF, GastroStacks.SOY_SAUCE, GastroStacks.GREEN_ONION}).container(BOWL).tools(new ItemStack[]{GastroStacks.FRYING_PAN}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.CHICKEN_UDON).ingredients(new ItemStack[]{GastroStacks.DOUGH, CHICKEN, GastroStacks.SOY_SAUCE, GastroStacks.GREEN_ONION}).container(BOWL).tools(new ItemStack[]{GastroStacks.FRYING_PAN}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.VEGETABLE_UDON).ingredients(new ItemStack[]{GastroStacks.DOUGH, GastroStacks.BROCCOLI, CARROT, GastroStacks.SOY_SAUCE, GastroStacks.GREEN_ONION}).container(BOWL).tools(new ItemStack[]{GastroStacks.FRYING_PAN, GastroStacks.PEELER}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.STIR_FRY_NOODLES).ingredients(new ItemStack[]{GastroStacks.DOUGH, CHICKEN, GastroStacks.BROCCOLI, CARROT, GastroStacks.BUTTON_MUSHROOM, GastroStacks.GREEN_ONION}).container(BOWL).tools(new ItemStack[]{GastroStacks.FRYING_PAN, GastroStacks.PEELER}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.SHRIMP_DUMPLINGS).ingredients(new ItemStack[]{GastroStacks.COOKED_RICE, GastroStacks.SHRIMP, GastroStacks.GREEN_ONION}).tools(new ItemStack[]{GastroStacks.ROLLING_PIN, GastroStacks.STEEL_POT}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.CHICKEN_POTSTICKERS).ingredients(new ItemStack[]{CHICKEN, GastroStacks.DOUGH, GastroStacks.SOY_SAUCE, GastroStacks.GREEN_ONION}).tools(new ItemStack[]{GastroStacks.ROLLING_PIN, GastroStacks.FRYING_PAN}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.BEEF_POTSTICKERS).ingredients(new ItemStack[]{BEEF, GastroStacks.DOUGH, GastroStacks.SOY_SAUCE, GastroStacks.GREEN_ONION}).tools(new ItemStack[]{GastroStacks.ROLLING_PIN, GastroStacks.FRYING_PAN}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.PIEROGIES).ingredients(new ItemStack[]{POTATO, GastroStacks.DOUGH, SlimefunItems.BUTTER}).tools(new ItemStack[]{GastroStacks.ROLLING_PIN, GastroStacks.PEELER, GastroStacks.BAKING_TRAY}).register(gn);
        if (egAvailable) {
            new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.BACON_PIEROGIES).ingredients(new ItemStack[]{BACON, POTATO, GastroStacks.DOUGH, SlimefunItems.BUTTER}).tools(new ItemStack[]{GastroStacks.ROLLING_PIN, GastroStacks.PEELER, GastroStacks.BAKING_TRAY}).register(gn);
        }
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.CUSTARD_BUNS).ingredients(new ItemStack[]{GastroStacks.DOUGH, GastroStacks.CUSTARD}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.RED_BEAN_BUNS).ingredients(new ItemStack[]{GastroStacks.DOUGH, GastroStacks.RED_BEAN_PASTE}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.TAIYAKI).ingredients(new ItemStack[]{GastroStacks.DOUGH, GastroStacks.RED_BEAN_PASTE, SUGAR}).tools(new ItemStack[]{GastroStacks.BAKING_TRAY}).temperature(MultiStove.Temperature.LOW).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.CULINARY_WORKBENCH).item(GastroStacks.TEMPURA_SHRIMP_ROLL).amount(3).shape(GastroRecipe.RecipeShape.SHAPED).ingredients(new ItemStack[]{GastroStacks.TEMPURA_SHRIMP, GastroStacks.TEMPURA_SHRIMP, GastroStacks.TEMPURA_SHRIMP, GastroStacks.COOKED_RICE, GastroStacks.COOKED_RICE, GastroStacks.COOKED_RICE, DRIED_KELP, DRIED_KELP, DRIED_KELP}).tools(new ItemStack[]{GastroStacks.KITCHEN_KNIFE}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.CULINARY_WORKBENCH).item(GastroStacks.DYNAMITE_ROLL).amount(3).shape(GastroRecipe.RecipeShape.SHAPED).ingredients(new ItemStack[]{GastroStacks.TEMPURA_SHRIMP, GastroStacks.AVOCADO, GastroStacks.CUCUMBER, GastroStacks.COOKED_RICE, GastroStacks.COOKED_RICE, GastroStacks.COOKED_RICE, DRIED_KELP, DRIED_KELP, DRIED_KELP}).tools(new ItemStack[]{GastroStacks.KITCHEN_KNIFE}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.CULINARY_WORKBENCH).item(GastroStacks.KAPPA_ROLL).amount(3).shape(GastroRecipe.RecipeShape.SHAPED).ingredients(new ItemStack[]{GastroStacks.CUCUMBER, GastroStacks.AVOCADO, GastroStacks.CUCUMBER, GastroStacks.COOKED_RICE, GastroStacks.COOKED_RICE, GastroStacks.COOKED_RICE, DRIED_KELP, DRIED_KELP, DRIED_KELP}).tools(new ItemStack[]{GastroStacks.KITCHEN_KNIFE}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.CULINARY_WORKBENCH).item(GastroStacks.CALIFORNIA_ROLL).amount(3).shape(GastroRecipe.RecipeShape.SHAPED).ingredients(new ItemStack[]{GastroStacks.CRAB, GastroStacks.AVOCADO, GastroStacks.CUCUMBER, GastroStacks.COOKED_RICE, GastroStacks.COOKED_RICE, GastroStacks.COOKED_RICE, DRIED_KELP, DRIED_KELP, DRIED_KELP}).tools(new ItemStack[]{GastroStacks.KITCHEN_KNIFE}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.CULINARY_WORKBENCH).item(GastroStacks.SALMON_ROE_SUSHI_ROLL).amount(3).shape(GastroRecipe.RecipeShape.SHAPED).ingredients(new ItemStack[]{null, null, null, GastroStacks.SALMON_ROE, GastroStacks.SALMON_ROE, GastroStacks.SALMON_ROE, DRIED_KELP, DRIED_KELP, DRIED_KELP}).tools(new ItemStack[]{GastroStacks.KITCHEN_KNIFE}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.RED_BEAN_GLUTINOUS_RICE_BALLS).amount(3).ingredients(new ItemStack[]{WATER_BUCKET, GastroStacks.COOKED_RICE, GastroStacks.RED_BEAN_PASTE, SUGAR}).tools(new ItemStack[]{GastroStacks.STEEL_POT}).temperature(MultiStove.Temperature.LOW).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.PEANUT_GLUTINOUS_RICE_BALLS).amount(3).ingredients(new ItemStack[]{WATER_BUCKET, GastroStacks.COOKED_RICE, GastroStacks.PEANUTS, SUGAR}).tools(new ItemStack[]{GastroStacks.STEEL_POT}).temperature(MultiStove.Temperature.LOW).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.SESAME_GLUTINOUS_RICE_BALLS).amount(3).ingredients(new ItemStack[]{WATER_BUCKET, GastroStacks.COOKED_RICE, GastroStacks.SESAME_SEEDS, SUGAR}).tools(new ItemStack[]{GastroStacks.STEEL_POT}).temperature(MultiStove.Temperature.LOW).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.CULINARY_WORKBENCH).item(GastroStacks.MASHED_POTATOES).ingredients(POTATO, MILK_BUCKET).tools(new ItemStack[]{GastroStacks.MORTAR_AND_PESTLE}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.CULINARY_WORKBENCH).item(GastroStacks.MASHED_TURNIPS).ingredients(new ItemStack[]{GastroStacks.TURNIP, MILK_BUCKET}).tools(new ItemStack[]{GastroStacks.MORTAR_AND_PESTLE}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.FISH_AND_CHIPS).ingredients(new ItemStack[]{RAW_COD, POTATO, SlimefunItems.SALT}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.TURKEY_ROAST).ingredients(new ItemStack[]{GastroStacks.RAW_TURKEY, GastroStacks.MASHED_POTATOES, GastroStacks.BRUSSLES_SPROUTS}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.CULINARY_WORKBENCH).item(GastroStacks.CHOCOLATE_TRUFFLE).ingredients(new ItemStack[]{GastroStacks.TRUFFLE, COCOA_BEANS}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.DOUBLE_CHOCOLATE_MUFFIN).ingredients(new ItemStack[]{GastroStacks.DOUGH, MILK_BUCKET, SlimefunItems.BUTTER, EGG, SUGAR, COCOA_BEANS, COCOA_BEANS}).tools(new ItemStack[]{GastroStacks.BAKING_TRAY, GastroStacks.WHISK}).amount(3).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.CARROT_MUFFIN).ingredients(new ItemStack[]{GastroStacks.DOUGH, MILK_BUCKET, SlimefunItems.BUTTER, EGG, SUGAR, CARROT}).tools(new ItemStack[]{GastroStacks.BAKING_TRAY, GastroStacks.WHISK}).amount(3).register(gn);
        if (egAvailable) {
            new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.CRANBERRY_MUFFIN).ingredients(new ItemStack[]{GastroStacks.DOUGH, MILK_BUCKET, SlimefunItems.BUTTER, EGG, SUGAR, CRANBERRY}).tools(new ItemStack[]{GastroStacks.BAKING_TRAY, GastroStacks.WHISK}).amount(3).register(gn);
            new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.RAISIN_MUFFIN).ingredients(new ItemStack[]{GastroStacks.DOUGH, MILK_BUCKET, SlimefunItems.BUTTER, EGG, SUGAR, GRAPE}).tools(new ItemStack[]{GastroStacks.BAKING_TRAY, GastroStacks.WHISK}).amount(3).register(gn);
        }
        new GastroFoodBuilder().type(GastroRecipeType.REFRIGERATOR).item(GastroStacks.VANILLA_ICE_CREAM).amount(2).ingredients(new ItemStack[]{MILK_BUCKET, SlimefunItems.HEAVY_CREAM, SUGAR, GastroStacks.VANILLA_BEANS}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.REFRIGERATOR).item(GastroStacks.CHOCOLATE_ICE_CREAM).amount(2).ingredients(new ItemStack[]{MILK_BUCKET, SlimefunItems.HEAVY_CREAM, SUGAR, COCOA_BEANS}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.REFRIGERATOR).item(GastroStacks.MINT_CHOCOLATE_ICE_CREAM).amount(2).ingredients(new ItemStack[]{MILK_BUCKET, SlimefunItems.HEAVY_CREAM, SUGAR, GastroStacks.MINT, COCOA_BEANS}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.REFRIGERATOR).item(GastroStacks.COOKIE_DOUGH_ICE_CREAM).amount(2).ingredients(new ItemStack[]{MILK_BUCKET, SlimefunItems.HEAVY_CREAM, SUGAR, GastroStacks.DOUGH}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.REFRIGERATOR).item(GastroStacks.PEANUT_BUTTER_ICE_CREAM).amount(2).ingredients(new ItemStack[]{MILK_BUCKET, SlimefunItems.HEAVY_CREAM, SUGAR, GastroStacks.PEANUT_BUTTER}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.REFRIGERATOR).item(GastroStacks.RED_BEAN_ICE_CREAM).amount(2).ingredients(new ItemStack[]{MILK_BUCKET, SlimefunItems.HEAVY_CREAM, SUGAR, GastroStacks.RED_BEAN_PASTE}).register(gn);
        if (egAvailable) {
            new GastroFoodBuilder().type(GastroRecipeType.REFRIGERATOR).item(GastroStacks.GREEN_TEA_ICE_CREAM).amount(2).ingredients(new ItemStack[]{MILK_BUCKET, SlimefunItems.HEAVY_CREAM, SUGAR, TEA_LEAF}).register(gn);
            new GastroFoodBuilder().type(GastroRecipeType.REFRIGERATOR).item(GastroStacks.STRAWBERRY_ICE_CREAM).amount(2).ingredients(new ItemStack[]{MILK_BUCKET, SlimefunItems.HEAVY_CREAM, SUGAR, STRAWBERRY}).register(gn);
            new GastroFoodBuilder().type(GastroRecipeType.REFRIGERATOR).item(GastroStacks.BLUEBERRY_ICE_CREAM).amount(2).ingredients(new ItemStack[]{MILK_BUCKET, SlimefunItems.HEAVY_CREAM, SUGAR, BLUEBERRY}).register(gn);
            new GastroFoodBuilder().type(GastroRecipeType.REFRIGERATOR).item(GastroStacks.CRANBERRY_ICE_CREAM).amount(2).ingredients(new ItemStack[]{MILK_BUCKET, SlimefunItems.HEAVY_CREAM, SUGAR, CRANBERRY}).register(gn);
            new GastroFoodBuilder().type(GastroRecipeType.REFRIGERATOR).item(GastroStacks.COWBERRY_ICE_CREAM).amount(2).ingredients(new ItemStack[]{MILK_BUCKET, SlimefunItems.HEAVY_CREAM, SUGAR, COWBERRY}).register(gn);
            new GastroFoodBuilder().type(GastroRecipeType.REFRIGERATOR).item(GastroStacks.COCONUT_ICE_CREAM).amount(2).ingredients(new ItemStack[]{MILK_BUCKET, SlimefunItems.HEAVY_CREAM, SUGAR, COCONUT}).register(gn);
            new GastroFoodBuilder().type(GastroRecipeType.REFRIGERATOR).item(GastroStacks.CHERRY_ICE_CREAM).amount(2).ingredients(new ItemStack[]{MILK_BUCKET, SlimefunItems.HEAVY_CREAM, SUGAR, CHERRY}).register(gn);
            new GastroFoodBuilder().type(GastroRecipeType.REFRIGERATOR).item(GastroStacks.RASPBERRY_ICE_CREAM).amount(2).ingredients(new ItemStack[]{MILK_BUCKET, SlimefunItems.HEAVY_CREAM, SUGAR, RASPBERRY}).register(gn);
            new GastroFoodBuilder().type(GastroRecipeType.REFRIGERATOR).item(GastroStacks.CARAMEL_ICE_CREAM).amount(2).ingredients(new ItemStack[]{MILK_BUCKET, SlimefunItems.HEAVY_CREAM, SUGAR, GastroStacks.CARAMEL}).register(gn);
            new GastroFoodBuilder().type(GastroRecipeType.REFRIGERATOR).item(GastroStacks.ORANGE_ICE_CREAM).amount(2).ingredients(new ItemStack[]{MILK_BUCKET, SlimefunItems.HEAVY_CREAM, SUGAR, ORANGE}).register(gn);
            new GastroFoodBuilder().type(GastroRecipeType.REFRIGERATOR).item(GastroStacks.PEACH_ICE_CREAM).amount(2).ingredients(new ItemStack[]{MILK_BUCKET, SlimefunItems.HEAVY_CREAM, SUGAR, PEACH}).register(gn);
            new GastroFoodBuilder().type(GastroRecipeType.REFRIGERATOR).item(GastroStacks.PINEAPPLE_ICE_CREAM).amount(2).ingredients(new ItemStack[]{MILK_BUCKET, SlimefunItems.HEAVY_CREAM, SUGAR, PINEAPPLE}).register(gn);
        }
        new GastroFoodBuilder().type(GastroRecipeType.REFRIGERATOR).item(GastroStacks.CHORUS_ICE_CREAM).amount(2).ingredients(new ItemStack[]{MILK_BUCKET, SlimefunItems.HEAVY_CREAM, SUGAR, CHORUS_FRUIT}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.CULINARY_WORKBENCH).item(GastroStacks.SHAVED_ICE).ingredients(ICE).container((ItemStack)GastroStacks.STEEL_BOWL).tools(new ItemStack[]{GastroStacks.BLENDER}).register(gn);
        if (egAvailable) {
            new GastroFoodBuilder().type(GastroRecipeType.CULINARY_WORKBENCH).item(GastroStacks.STRAWBERRY_SHAVED_ICE).ingredients(ICE, STRAWBERRY).container((ItemStack)GastroStacks.STEEL_BOWL).tools(new ItemStack[]{GastroStacks.BLENDER}).register(gn);
        }
        new GastroFoodBuilder().type(GastroRecipeType.CULINARY_WORKBENCH).item(GastroStacks.BANANA_SHAVED_ICE).ingredients(new ItemStack[]{ICE, GastroStacks.BANANA}).container((ItemStack)GastroStacks.STEEL_BOWL).tools(new ItemStack[]{GastroStacks.BLENDER}).register(gn);
        if (egAvailable) {
            new GastroFoodBuilder().type(GastroRecipeType.CULINARY_WORKBENCH).item(GastroStacks.LEMON_SHAVED_ICE).ingredients(ICE, LEMON).container((ItemStack)GastroStacks.STEEL_BOWL).tools(new ItemStack[]{GastroStacks.BLENDER}).register(gn);
        }
        new GastroFoodBuilder().type(GastroRecipeType.CULINARY_WORKBENCH).item(GastroStacks.CANDY_APPLE).shape(GastroRecipe.RecipeShape.SHAPED).ingredients(null, HONEY_BOTTLE, null, null, APPLE, null, null, STICK, null).register(gn);
        if (egAvailable) {
            new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.DONUT).ingredients(new ItemStack[]{GastroStacks.DOUGH, YEAST, MILK_BUCKET, SlimefunItems.BUTTER, SUGAR, PINK_DYE}).tools(new ItemStack[]{GastroStacks.BAKING_TRAY}).amount(2).register(gn);
            new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.HONEY_DIP_DONUT).ingredients(new ItemStack[]{GastroStacks.DOUGH, YEAST, MILK_BUCKET, SlimefunItems.BUTTER, SUGAR, HONEY_BOTTLE}).tools(new ItemStack[]{GastroStacks.BAKING_TRAY}).amount(2).register(gn);
            new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.GOLDEN_CHOCOLATE_DONUT).ingredients(new ItemStack[]{GastroStacks.DOUGH, YEAST, MILK_BUCKET, SlimefunItems.BUTTER, SUGAR, HONEY_BOTTLE, COCOA_BEANS}).tools(new ItemStack[]{GastroStacks.BAKING_TRAY}).amount(2).register(gn);
            new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.STRAWBERRY_CHEESECAKE).ingredients(new ItemStack[]{GastroStacks.DOUGH, YEAST, MILK_BUCKET, SlimefunItems.BUTTER, SUGAR, SlimefunItems.CHEESE, STRAWBERRY}).tools(new ItemStack[]{GastroStacks.BAKING_TRAY}).register(gn);
            new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.STRAWBERRY_CUPCAKE).ingredients(new ItemStack[]{GastroStacks.DOUGH, YEAST, MILK_BUCKET, SlimefunItems.BUTTER, SUGAR, STRAWBERRY}).tools(new ItemStack[]{GastroStacks.BAKING_TRAY}).amount(2).register(gn);
            new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.LEMON_TART).ingredients(LEMON, SUGAR, EGG).tools(new ItemStack[]{GastroStacks.BAKING_TRAY}).amount(3).register(gn);
        }
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.CHORUS_PIE).ingredients(CHORUS_FRUIT, SUGAR, EGG).tools(new ItemStack[]{GastroStacks.BAKING_TRAY}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.MULTI_STOVE).item(GastroStacks.POPPED_SORGHUM).ingredients(new ItemStack[]{GastroStacks.SORGHUM}).tools(new ItemStack[]{GastroStacks.BAKING_TRAY}).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.CULINARY_WORKBENCH).item(GastroStacks.ENCHANTED_GOLDEN_CARROT).shape(GastroRecipe.RecipeShape.SHAPED).ingredients(RecipeUtil.cyclic((ItemStack)SlimefunItems.GOLD_24K_BLOCK, CARROT)).register(gn);
        new GastroFoodBuilder().type(GastroRecipeType.CULINARY_WORKBENCH).item(GastroStacks.ENCHANTED_GLISTERING_MELON_SLICE).shape(GastroRecipe.RecipeShape.SHAPED).ingredients(RecipeUtil.cyclic((ItemStack)SlimefunItems.GOLD_24K_BLOCK, MELON_SLICE)).register(gn);
        if (egAvailable) {
            new GastroFoodBuilder().type(GastroRecipeType.CULINARY_WORKBENCH).item(GastroStacks.V7).shape(GastroRecipe.RecipeShape.SHAPELESS).ingredients(new ItemStack[]{TOMATO, CARROT, GastroStacks.CELERY, BEETROOT, LETTUCE, GastroStacks.PARSLEY, GastroStacks.SPINACH}).tools(new ItemStack[]{GastroStacks.BLENDER}).container((ItemStack)SlimefunItems.TIN_CAN).register(gn);
            new GastroFoodBuilder().type(GastroRecipeType.CULINARY_WORKBENCH).item(GastroStacks.BUBBLE_MILK_TEA).shape(GastroRecipe.RecipeShape.SHAPELESS).ingredients(new ItemStack[]{TEA_LEAF, MILK_BUCKET, BROWN_SUGAR, GastroStacks.TAPIOCA_PEARLS}).container(GLASS_BOTTLE).register(gn);
            new GastroFoodBuilder().type(GastroRecipeType.CULINARY_WORKBENCH).item(GastroStacks.APPLE_BUBBLE_TEA).shape(GastroRecipe.RecipeShape.SHAPELESS).ingredients(new ItemStack[]{TEA_LEAF, APPLE, GastroStacks.TAPIOCA_PEARLS, GastroStacks.LYCHEE}).container(GLASS_BOTTLE).tools(new ItemStack[]{GastroStacks.BLENDER, GastroStacks.KITCHEN_KNIFE}).register(gn);
            new GastroFoodBuilder().type(GastroRecipeType.CULINARY_WORKBENCH).item(GastroStacks.CANTALOUPE_BUBBLE_TEA).shape(GastroRecipe.RecipeShape.SHAPELESS).ingredients(new ItemStack[]{TEA_LEAF, GastroStacks.CANTALOUPE, GastroStacks.TAPIOCA_PEARLS, GastroStacks.LYCHEE}).container(GLASS_BOTTLE).tools(new ItemStack[]{GastroStacks.BLENDER, GastroStacks.KITCHEN_KNIFE}).register(gn);
            new GastroFoodBuilder().type(GastroRecipeType.CULINARY_WORKBENCH).item(GastroStacks.HONEYDEW_MELON_BUBBLE_TEA).shape(GastroRecipe.RecipeShape.SHAPELESS).ingredients(new ItemStack[]{TEA_LEAF, GastroStacks.HONEYDEW_MELON, GastroStacks.TAPIOCA_PEARLS, GastroStacks.LYCHEE}).container(GLASS_BOTTLE).tools(new ItemStack[]{GastroStacks.BLENDER, GastroStacks.KITCHEN_KNIFE}).register(gn);
            new GastroFoodBuilder().type(GastroRecipeType.FERMENTER).item(GastroStacks.RED_WINE).shape(GastroRecipe.RecipeShape.SHAPED).container(GLASS_BOTTLE).ingredients(GRAPE, YEAST).tools(new ItemStack[]{GastroStacks.DISTILLATION_CHAMBER}).register(gn);
            new GastroFoodBuilder().type(GastroRecipeType.FERMENTER).item(GastroStacks.BEER).shape(GastroRecipe.RecipeShape.SHAPED).container(GLASS_BOTTLE).ingredients(new ItemStack[]{GastroStacks.BARLEY, YEAST}).tools(new ItemStack[]{GastroStacks.DISTILLATION_CHAMBER}).register(gn);
            new GastroFoodBuilder().type(GastroRecipeType.FERMENTER).item(GastroStacks.APPLE_CIDER).shape(GastroRecipe.RecipeShape.SHAPED).container(GLASS_BOTTLE).ingredients(APPLE, YEAST).tools(new ItemStack[]{GastroStacks.DISTILLATION_CHAMBER}).register(gn);
            new GastroFoodBuilder().type(GastroRecipeType.FERMENTER).item(GastroStacks.RICE_WINE).shape(GastroRecipe.RecipeShape.SHAPED).container(GLASS_BOTTLE).ingredients(new ItemStack[]{GastroStacks.RICE, YEAST}).tools(new ItemStack[]{GastroStacks.DISTILLATION_CHAMBER}).register(gn);
            new GastroFoodBuilder().type(GastroRecipeType.FERMENTER).item(GastroStacks.VODKA).shape(GastroRecipe.RecipeShape.SHAPED).container(GLASS_BOTTLE).ingredients(POTATO, YEAST).tools(new ItemStack[]{GastroStacks.DISTILLATION_CHAMBER}).register(gn);
            new GastroFoodBuilder().type(GastroRecipeType.FERMENTER).item(GastroStacks.RUM).shape(GastroRecipe.RecipeShape.SHAPED).container(GLASS_BOTTLE).ingredients(SUGAR, YEAST).tools(new ItemStack[]{GastroStacks.DISTILLATION_CHAMBER}).register(gn);
            new GastroFoodBuilder().type(GastroRecipeType.FERMENTER).item(GastroStacks.WHISKEY).shape(GastroRecipe.RecipeShape.SHAPED).container(GLASS_BOTTLE).ingredients(new ItemStack[]{GastroStacks.RYE, YEAST}).tools(new ItemStack[]{GastroStacks.DISTILLATION_CHAMBER}).register(gn);
        }
    }

    @Generated
    private ItemSetup() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

