/*
 * Decompiled with CFR 0.152.
 */
package io.github.schntgaispock.gastronomicon.api.trees;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.github.schntgaispock.gastronomicon.Gastronomicon;
import io.github.schntgaispock.gastronomicon.util.NumberUtil;
import io.github.thebusybiscuit.slimefun4.libraries.dough.skins.PlayerHead;
import io.github.thebusybiscuit.slimefun4.libraries.dough.skins.PlayerSkin;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;

public final class TreeStructure {
    private static final ObjectMapper JSONObjectMapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
    private static final String TREE_SCHEMATIC_PATH = "plugins/Gastronomicon/schematics/";
    private static final Map<String, TreeStructure> loadedTrees = new HashMap<String, TreeStructure>();
    private final int[][][] blocks;
    private final String sapling;
    private final String fruit;
    private final String[] palette;
    private final int[] root;
    private final String fruitTexture;

    public static void loadTrees() {
        File treePath = new File(TREE_SCHEMATIC_PATH);
        for (File treeFile : treePath.listFiles()) {
            try {
                TreeStructure tree = JSONObjectMapper.readValue(treeFile, TreeStructure.class);
                loadedTrees.put(tree.getSapling(), tree);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Gastronomicon.info("Loaded all trees");
    }

    public TreeStructure(@JsonProperty(value="blocks") int[][][] blocks, @JsonProperty(value="sapling") String sapling, @JsonProperty(value="fruit") String fruit, @JsonProperty(value="palette") String[] palette, @JsonProperty(value="root") int[] root) {
        this.blocks = blocks;
        this.sapling = sapling;
        this.fruit = fruit;
        this.palette = palette;
        this.root = root;
        this.fruitTexture = switch (fruit) {
            case "GN_BANANA" -> "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMmYwZWE5YWNjOTdjOTg3YWI0NWQxNjZhYTdkZmU0ZGRiMjNhYjY1M2EwNjllYmJjYzQxZjYzY2Y0YTZlZjQ0MSJ9fX0=";
            case "GN_LYCHEE" -> "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYzQ4MGFkY2EzYjlkNTY3ZTI0NWJkOGRjYzY2ODY5ZjhmYTA4Nzk3MjhhOTllNzAxYTIxYTFlMTM5NzI2MDE1ZCJ9fX0=";
            case "GN_VANILLA_BEANS" -> "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNDQ4ZmFhMzkwYjFiZjM1NjExZTZiY2EwOGM3NjAwMTdiNDlmOWI0Y2UwMzE2YmNiYmM0MGNiMGZiMGM4NWYwMSJ9fX0=";
            default -> null;
        };
    }

    public void build(Location l, String sapling) {
        int[][][] structure = this.getBlocks();
        int[] root = this.getRoot();
        for (int y = 0; y < structure.length; ++y) {
            for (int z = 0; z < structure[0].length; ++z) {
                block6: for (int x = 0; x < structure[0][0].length; ++x) {
                    int id = structure[y][z][x];
                    int newX = l.getBlockX() + x - root[0];
                    int newY = l.getBlockY() + y;
                    int newZ = l.getBlockZ() + z - root[1];
                    switch (id) {
                        case 0: {
                            continue block6;
                        }
                        case 1: {
                            Block b = l.getWorld().getBlockAt(newX, newY, newZ);
                            b.setType(Material.PLAYER_HEAD);
                            if (this.fruitTexture != null) {
                                PlayerHead.setSkin((Block)b, (PlayerSkin)PlayerSkin.fromBase64((String)this.fruitTexture), (boolean)false);
                            }
                            BlockStorage.store((Block)b, (String)this.getFruit());
                            continue block6;
                        }
                        default: {
                            String palette = this.getPalette()[id - 2];
                            Block b2 = l.getWorld().getBlockAt(newX, newY, newZ);
                            if (palette.endsWith("LEAVES") && NumberUtil.flip(0.1)) {
                                BlockStorage.store((Block)b2, (String)sapling);
                            }
                            b2.setType(Material.valueOf((String)palette));
                        }
                    }
                }
            }
        }
    }

    public int[][][] getBlocks() {
        return this.blocks;
    }

    public String getSapling() {
        return this.sapling;
    }

    public String getFruit() {
        return this.fruit;
    }

    public String[] getPalette() {
        return this.palette;
    }

    public int[] getRoot() {
        return this.root;
    }

    public String getFruitTexture() {
        return this.fruitTexture;
    }

    @Nonnull
    public String toString() {
        return "TreeStructure(blocks=" + Arrays.deepToString((Object[])this.getBlocks()) + ", sapling=" + this.getSapling() + ", fruit=" + this.getFruit() + ", palette=" + Arrays.deepToString(this.getPalette()) + ", root=" + Arrays.toString(this.getRoot()) + ", fruitTexture=" + this.getFruitTexture() + ")";
    }

    public static Map<String, TreeStructure> getLoadedTrees() {
        return loadedTrees;
    }
}

