/*
 * Decompiled with CFR 0.152.
 */
package io.github.schntgaispock.gastronomicon.util.item;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.WordUtils;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;

public final class ItemUtil {
    public static int hashIgnoreAmount(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        int hash = 1;
        hash = hash * 31 + stack.getType().hashCode();
        hash = hash * 31 + (stack.hasItemMeta() ? stack.getItemMeta().hashCode() : 0);
        return hash;
    }

    public static int getSickleTier(@Nonnull ItemStack item) {
        SlimefunItem sfItem = SlimefunItem.getByItem((ItemStack)item);
        if (sfItem != null) {
            return switch (sfItem.getId()) {
                case "GN_WOODEN_SICKLE" -> 1;
                case "GN_STEEL_SICKLE" -> 2;
                case "GN_REINFORCED_SICKLE" -> 3;
                default -> 0;
            };
        }
        return 0;
    }

    public static boolean isSeed(@Nonnull Material material) {
        return switch (material) {
            case Material.WHEAT_SEEDS, Material.POTATO, Material.CARROT, Material.BEETROOT_SEEDS, Material.PUMPKIN_SEEDS, Material.MELON_SEEDS -> true;
            default -> false;
        };
    }

    @Nonnull
    public static Material getPlacedBlock(@Nonnull Material seed) {
        return switch (seed) {
            case Material.WHEAT_SEEDS -> Material.WHEAT;
            case Material.POTATO -> Material.POTATOES;
            case Material.CARROT -> Material.CARROTS;
            case Material.BEETROOT_SEEDS -> Material.BEETROOTS;
            case Material.PUMPKIN_SEEDS -> Material.PUMPKIN_STEM;
            case Material.MELON_SEEDS -> Material.MELON_STEM;
            default -> Material.AIR;
        };
    }

    @ParametersAreNonnullByDefault
    public static void giveItems(Player player, ItemStack[] items) {
        player.getInventory().addItem(items).forEach((__, item) -> player.getWorld().dropItemNaturally(player.getLocation(), item));
    }

    public static String getPotionName(PotionEffectType type) {
        return switch (type.getName()) {
            case "SLOW" -> "Slowness";
            case "FAST_DIGGING" -> "Haste";
            case "SLOW_DIGGING" -> "Mining Fatigue";
            case "INCREASE_DAMAGE" -> "Strength";
            case "HEAL" -> "Instant Health";
            case "HARM" -> "Instant Damage";
            case "CONFUSION" -> "Nausea";
            case "DAMAGE_RESISTANCE" -> "Resistance";
            case "UNLUCK" -> "Bad Luck";
            default -> WordUtils.capitalizeFully((String)type.getName().replaceAll("_", " "));
        };
    }

    private ItemUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

