/*
 * Decompiled with CFR 0.152.
 */
package io.github.schntgaispock.gastronomicon.core.slimefun.items.food;

import io.github.schntgaispock.gastronomicon.api.events.PlayerGastroFoodConsumeEvent;
import io.github.schntgaispock.gastronomicon.api.food.FoodEffect;
import io.github.schntgaispock.gastronomicon.api.items.FoodItemStack;
import io.github.schntgaispock.gastronomicon.api.recipes.GastroRecipe;
import io.github.schntgaispock.gastronomicon.core.slimefun.items.food.SimpleGastroFood;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.events.PlayerRightClickEvent;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.researches.Research;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.kyori.adventure.text.Component;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class GastroFood
extends SimpleGastroFood {
    private static final Set<String> gastroFoodIds = new HashSet<String>();
    private final FoodItemStack item;
    private final boolean perfect;
    private final ItemStack recipeDisplayOutput;

    public GastroFood(Research research, ItemGroup group, FoodItemStack item, GastroRecipe recipe, ItemStack topRightDisplayItem, ItemStack recipeDisplayOutput, boolean perfect) {
        super(research, group, item, recipe, topRightDisplayItem, recipeDisplayOutput, !perfect);
        this.item = item;
        this.perfect = perfect;
        this.recipeDisplayOutput = recipeDisplayOutput;
    }

    @Override
    public void preRegister() {
        this.addItemHandler(new ItemHandler[]{this::onRightClick});
        super.preRegister();
    }

    public void onRightClick(@Nonnull PlayerRightClickEvent e) {
        if (e.getPlayer().getFoodLevel() >= 20) {
            e.cancel();
            return;
        }
        SlimefunItem sfItem = SlimefunItem.getByItem((ItemStack)e.getItem());
        if (sfItem == null) {
            return;
        }
        if (sfItem instanceof GastroFood) {
            GastroFood food = (GastroFood)sfItem;
            e.cancel();
            PlayerGastroFoodConsumeEvent consumeEvent = new PlayerGastroFoodConsumeEvent(e.getPlayer(), food, e.getItem(), e.getHand());
            consumeEvent.callEvent();
            if (consumeEvent.isCancelled()) {
                if (consumeEvent.getMessage() != null) {
                    e.getPlayer().sendMessage((Component)Component.text((String)consumeEvent.getMessage()));
                }
                return;
            }
            Player p = e.getPlayer();
            for (FoodEffect effect : food.getItem().getEffects()) {
                effect.apply(p, food.isPerfect());
            }
            p.setFoodLevel(Math.min(p.getFoodLevel() + food.getItem().getHunger(), 20));
            p.setSaturation((float)Math.min((double)p.getSaturation() + food.getItem().getSaturation(), (double)p.getFoodLevel()));
            Object obj = this.getGastroRecipe().getInputs().getContainer().getComponent();
            if (obj instanceof ItemStack) {
                ItemStack stack = (ItemStack)obj;
                p.getInventory().addItem(new ItemStack[]{stack});
            }
            p.getWorld().playSound(p.getLocation(), Sound.ENTITY_PLAYER_BURP, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        e.getItem().subtract();
    }

    public void register(@Nonnull SlimefunAddon addon) {
        super.register(addon);
        if (!this.isPerfect()) {
            GastroFood.getGastroFoodIds().add(this.getId());
            new GastroFood(this.getResearch(), this.getItemGroup(), this.item.asPerfect(), this.getGastroRecipe(), this.topRightDisplayItem, this.recipeDisplayOutput, true).hide().register(addon);
        }
    }

    public static Set<String> getGastroFoodIds() {
        return gastroFoodIds;
    }

    public FoodItemStack getItem() {
        return this.item;
    }

    public boolean isPerfect() {
        return this.perfect;
    }
}

