/*
 * Decompiled with CFR 0.152.
 */
package io.github.schntgaispock.gastronomicon.core.slimefun.items.workstations.manual;

import io.github.schntgaispock.gastronomicon.Gastronomicon;
import io.github.schntgaispock.gastronomicon.api.events.PlayerGastroFoodCraftEvent;
import io.github.schntgaispock.gastronomicon.api.recipes.GastroRecipe;
import io.github.schntgaispock.gastronomicon.api.recipes.RecipeRegistry;
import io.github.schntgaispock.gastronomicon.core.slimefun.GastroGroups;
import io.github.schntgaispock.gastronomicon.core.slimefun.GastroStacks;
import io.github.schntgaispock.gastronomicon.core.slimefun.recipes.GastroRecipeType;
import io.github.schntgaispock.gastronomicon.util.NumberUtil;
import io.github.schntgaispock.gastronomicon.util.RecipeUtil;
import io.github.schntgaispock.gastronomicon.util.collections.Pair;
import io.github.schntgaispock.gastronomicon.util.item.ItemUtil;
import io.github.schntgaispock.infinitylib.core.AddonConfig;
import io.github.schntgaispock.infinitylib.machines.MenuBlock;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public abstract class GastroWorkstation
extends MenuBlock {
    protected static final int[] BACKGROUND_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 13, 17, 22, 23, 24, 25, 26, 31, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44};
    protected static final int[] INGREDIENT_BORDER_SLOTS = new int[]{9, 18, 27};
    protected static final int[] CONTAINER_BORDER_SLOTS = new int[]{14};
    protected static final int[] OUTPUT_BORDER_SLOTS = new int[]{32};
    protected static final int[] TOOL_BORDER_SLOTS = new int[]{45};
    protected static final int CRAFT_BUTTON_SLOT = 53;
    private static Map<Location, Pair<Integer, GastroRecipe>> lastInputHashAndRecipe = new HashMap<Location, Pair<Integer, GastroRecipe>>();

    public GastroWorkstation(SlimefunItemStack item, ItemStack[] recipe) {
        super(GastroGroups.BASIC_MACHINES, item, RecipeType.ENHANCED_CRAFTING_TABLE, recipe);
    }

    @Override
    protected int[] getInputSlots() {
        return new int[]{10, 11, 12, 19, 20, 21, 28, 29, 30};
    }

    @Override
    protected int[] getOutputSlots() {
        return new int[]{33, 34};
    }

    protected int[] getToolSlots() {
        return new int[]{46, 47, 48, 49, 50, 51};
    }

    protected int[] getContainerSlots() {
        return new int[]{15, 16};
    }

    public abstract GastroRecipeType getGastroRecipeType();

    @Override
    protected void setup(BlockMenuPreset preset) {
        preset.drawBackground(BACKGROUND_ITEM, BACKGROUND_SLOTS);
        preset.drawBackground(GastroStacks.MENU_INGREDIENT_BORDER, INGREDIENT_BORDER_SLOTS);
        preset.drawBackground(GastroStacks.MENU_CONTAINER_BORDER, CONTAINER_BORDER_SLOTS);
        preset.drawBackground(OUTPUT_BORDER, OUTPUT_BORDER_SLOTS);
        preset.drawBackground(GastroStacks.MENU_TOOL_BORDER, TOOL_BORDER_SLOTS);
        preset.drawBackground(GastroStacks.MENU_CRAFT_BUTTON, new int[]{53});
    }

    @Override
    protected void onBreak(BlockBreakEvent e, BlockMenu menu) {
        super.onBreak(e, menu);
        Location l = menu.getLocation();
        menu.dropItems(l, this.getToolSlots());
        menu.dropItems(l, this.getContainerSlots());
    }

    protected void onSuccessfulCraft(Block b) {
    }

    @Override
    protected void onNewInstance(BlockMenu menu, Block b) {
        super.onNewInstance(menu, b);
        menu.addMenuClickHandler(53, (player, slot, item, action) -> {
            ItemStack[] toReturn;
            ItemStack output;
            ItemStack patt7793$temp;
            GastroRecipe recipe;
            if (!this.canCraft(menu, b, player, true)) {
                return false;
            }
            Integer freeSlot = null;
            for (int s2 : this.getOutputSlots()) {
                ItemStack stack = menu.getItemInSlot(s2);
                if (stack != null && stack.getType() != Material.AIR) continue;
                freeSlot = s2;
                break;
            }
            if (freeSlot == null) {
                return false;
            }
            Object[] ingredients = (ItemStack[])Arrays.stream(this.getInputSlots()).mapToObj(s -> {
                ItemStack i = menu.getItemInSlot(s);
                return i == null ? null : i.asOne();
            }).toArray(ItemStack[]::new);
            List<ItemStack> containers = Arrays.stream(this.getContainerSlots()).mapToObj(s -> {
                ItemStack i = menu.getItemInSlot(s);
                return i == null ? null : i.asOne();
            }).toList();
            List<ItemStack> tools = Arrays.stream(this.getToolSlots()).mapToObj(s -> {
                ItemStack i = menu.getItemInSlot(s);
                return i == null ? null : i.asOne();
            }).toList();
            int hash = 1;
            hash = hash * 31 + Arrays.hashCode(ingredients);
            hash = hash * 31 + containers.hashCode();
            hash = hash * 31 + tools.hashCode();
            hash = hash * 31 + this.getOtherHash(player, menu);
            Pair<Integer, GastroRecipe> hashRecipePair = lastInputHashAndRecipe.containsKey(menu.getLocation()) ? lastInputHashAndRecipe.get(menu.getLocation()) : new Pair<Integer, Object>(0, null);
            if (hashRecipePair.first() == hash && hashRecipePair.second() != null) {
                recipe = hashRecipePair.second();
            } else {
                recipe = this.findRecipe((ItemStack[])ingredients, containers, tools, player, menu);
                if (recipe == null) {
                    Gastronomicon.sendMessage(player, "&eUnknown recipe!");
                    return false;
                }
                if (lastInputHashAndRecipe.containsKey(menu.getLocation())) {
                    lastInputHashAndRecipe.get(menu.getLocation()).first(hash);
                    lastInputHashAndRecipe.get(menu.getLocation()).second(recipe);
                } else {
                    lastInputHashAndRecipe.put(menu.getLocation(), new Pair<Integer, GastroRecipe>(hash, recipe));
                }
            }
            ItemStack[] recipeOutputs = recipe.getOutputs();
            PlayerGastroFoodCraftEvent craftEvent = new PlayerGastroFoodCraftEvent(player, recipe);
            if (!craftEvent.callEvent()) {
                if (craftEvent.getMessage() != null) {
                    Gastronomicon.sendMessage(player, (Component)Component.text((String)craftEvent.getMessage()));
                }
                return false;
            }
            this.onSuccessfulCraft(b);
            if (recipeOutputs.length > 1 && (patt7793$temp = recipeOutputs[0]) instanceof SlimefunItemStack) {
                SlimefunItemStack sfItem = (SlimefunItemStack)patt7793$temp;
                AddonConfig playerData = Gastronomicon.getInstance().getPlayerData();
                String proficiencyPath = player.getUniqueId() + ".proficiencies." + sfItem.getItemId();
                int proficiency = playerData.getInt(proficiencyPath, 0);
                playerData.set(proficiencyPath, proficiency + 1);
                double perfectProbabilityMultipliers = 1.0;
                double perfectProbability = NumberUtil.clamp(NumberUtil.clamp(0.0, (double)(proficiency / 864), 0.25) * 1.0, 0.0, 1.0);
                output = recipeOutputs[NumberUtil.randomRound(perfectProbability)];
                toReturn = Arrays.copyOfRange(recipeOutputs, 2, recipeOutputs.length);
            } else {
                output = recipeOutputs[0];
                toReturn = Arrays.copyOfRange(recipeOutputs, 1, recipeOutputs.length);
            }
            Inventory inv = player.getOpenInventory().getTopInventory();
            for (int outputSlot : this.getOutputSlots()) {
                ItemStack currentlyInOutput = inv.getItem(outputSlot);
                if (currentlyInOutput == null || currentlyInOutput.getType() == Material.AIR) {
                    inv.setItem(outputSlot, output.clone());
                    break;
                }
                if (RecipeUtil.recipeHash(output) != RecipeUtil.recipeHash(currentlyInOutput) || currentlyInOutput.getMaxStackSize() == currentlyInOutput.getAmount()) continue;
                currentlyInOutput.add();
                break;
            }
            Arrays.stream(this.getInputSlots()).forEach(s -> {
                ItemStack i = menu.getItemInSlot(s);
                if (i != null) {
                    ItemUtils.consumeItem((ItemStack)i, (int)1, (boolean)true);
                }
            });
            for (int containerSlot : this.getContainerSlots()) {
                ItemStack i = menu.getItemInSlot(containerSlot);
                if (i == null || hashRecipePair.second() == null || !hashRecipePair.second().getInputs().getContainer().matches(i)) continue;
                i.subtract();
                break;
            }
            ItemUtil.giveItems(player, toReturn);
            return false;
        });
    }

    protected abstract boolean canCraft(BlockMenu var1, Block var2, Player var3, boolean var4);

    @Nullable
    @ParametersAreNonnullByDefault
    protected GastroRecipe findRecipe(ItemStack[] ingredients, List<ItemStack> containers, List<ItemStack> tools, Player player, BlockMenu menu) {
        Set<GastroRecipe> recipes = RecipeRegistry.getRecipes(this.getGastroRecipeType());
        for (GastroRecipe recipe : recipes) {
            GastroRecipe.RecipeMatchResult result = recipe.matches((ItemStack[])ingredients.clone(), containers, tools);
            if (!result.isMatch()) continue;
            if (!result.isCraftable()) break;
            return recipe;
        }
        return null;
    }

    protected int getOtherHash(Player player, BlockMenu menu) {
        return 0;
    }
}

