/*
 * Decompiled with CFR 0.152.
 */
package io.github.schntgaispock.gastronomicon.core.slimefun.items.seeds;

import io.github.schntgaispock.gastronomicon.core.slimefun.items.seeds.AbstractSeed;
import io.github.schntgaispock.gastronomicon.util.NumberUtil;
import io.github.schntgaispock.gastronomicon.util.item.ItemUtil;
import io.github.thebusybiscuit.slimefun4.api.events.BlockPlacerPlaceEvent;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;

public class SimpleSeed
extends AbstractSeed {
    @Nonnull
    private final Material displayBlock;

    @ParametersAreNonnullByDefault
    public SimpleSeed(SlimefunItemStack item, @Nullable Material displayBlock, ItemStack[] gatherSources) {
        super(item, gatherSources);
        if (displayBlock == null) {
            displayBlock = ItemUtil.getPlacedBlock(item.getType());
        }
        this.displayBlock = displayBlock;
    }

    @ParametersAreNonnullByDefault
    public SimpleSeed(SlimefunItemStack item, ItemStack[] gatherSources) {
        this(item, null, gatherSources);
    }

    @Override
    public void preRegister() {
        super.preRegister();
        if (ItemUtil.isSeed(this.getItem().getType())) {
            this.addItemHandler(new ItemHandler[]{new BlockPlaceHandler(true){

                public void onBlockPlacerPlace(BlockPlacerPlaceEvent e) {
                    if (e.getBlock().getState().getLightLevel() <= 7) {
                        e.setCancelled(true);
                        BlockStorage.clearBlockInfo((Block)e.getBlock(), (boolean)true);
                        return;
                    }
                    e.getBlock().setType(SimpleSeed.this.displayBlock);
                }

                public void onPlayerPlace(BlockPlaceEvent e) {
                    if (e.getBlock().getState().getLightLevel() <= 7 || !e.canBuild()) {
                        e.setCancelled(true);
                        BlockStorage.clearBlockInfo((Block)e.getBlock(), (boolean)true);
                        return;
                    }
                    e.getBlock().setType(SimpleSeed.this.displayBlock);
                }
            }});
        } else {
            this.addItemHandler(new ItemHandler[]{new BlockPlaceHandler(false){

                public void onPlayerPlace(@Nonnull BlockPlaceEvent e) {
                    e.setCancelled(true);
                    BlockStorage.clearBlockInfo((Block)e.getBlock(), (boolean)true);
                }
            }});
            this.addItemHandler(new ItemHandler[]{event -> {
                if (event.getClickedFace() != BlockFace.UP || !this.canUse(event.getPlayer(), true) || event.getClickedBlock().isEmpty()) {
                    return;
                }
                Block b = (Block)event.getClickedBlock().get();
                if (b.getType() != Material.FARMLAND || b.getY() >= b.getWorld().getMaxHeight()) {
                    return;
                }
                Block above = b.getLocation().add(0.0, 1.0, 0.0).getBlock();
                if (!above.isEmpty() || !Slimefun.getProtectionManager().hasPermission((OfflinePlayer)event.getPlayer(), above, Interaction.PLACE_BLOCK)) {
                    return;
                }
                if (above.getState().getLightLevel() <= 7) {
                    event.cancel();
                    BlockStorage.clearBlockInfo((Block)above, (boolean)true);
                    return;
                }
                above.setType(this.getDisplayBlock());
                BlockStorage.addBlockInfo((Block)above, (String)"id", (String)this.getId());
                event.getItem().subtract();
            }});
        }
    }

    @Override
    public List<ItemStack> getHarvestDrops(BlockState b, ItemStack item, boolean brokenByPlayer) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (!brokenByPlayer) {
            drops.add(this.getItem().clone());
        }
        if (!this.isMature(b)) {
            return drops;
        }
        int sickleTier = ItemUtil.getSickleTier(item);
        int fortuneLevel = item.getEnchantmentLevel(Enchantment.LOOT_BONUS_BLOCKS);
        ItemStack seed = this.getItem().clone();
        seed.setAmount(NumberUtil.getFortuneAmount(fortuneLevel, sickleTier, 2));
        return Arrays.asList(seed);
    }

    @Override
    public boolean isMature(BlockState b) {
        BlockData blockData = b.getBlockData();
        if (blockData instanceof Ageable) {
            Ageable cropMeta = (Ageable)blockData;
            return cropMeta.getAge() >= cropMeta.getMaximumAge();
        }
        return false;
    }

    @Nonnull
    public Material getDisplayBlock() {
        return this.displayBlock;
    }
}

