/*
 * Decompiled with CFR 0.152.
 */
package io.github.schntgaispock.gastronomicon.api.recipes.components;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public abstract class RecipeComponent<T> {
    protected final T component;
    public static final RecipeComponent<Void> EMPTY = new RecipeComponent<Void>(null){
        private final ItemStack displayItem = new ItemStack(Material.AIR);

        @Override
        public boolean matches(@Nullable ItemStack item) {
            return item == null || item.getType() == Material.AIR;
        }

        @Override
        public ItemStack getDisplayItem() {
            return this.displayItem.clone();
        }

        @Override
        public int hashCode() {
            return this.displayItem.hashCode();
        }
    };

    public abstract boolean matches(@Nullable ItemStack var1);

    public abstract ItemStack getDisplayItem();

    public abstract int hashCode();

    public T getComponent() {
        return this.component;
    }

    public RecipeComponent(T component) {
        this.component = component;
    }

    @Nonnull
    public String toString() {
        return "RecipeComponent(component=" + this.getComponent() + ")";
    }
}

