/*
 * Decompiled with CFR 0.152.
 */
package io.github.schntgaispock.gastronomicon.util.collections;

import io.github.schntgaispock.gastronomicon.util.collections.Pair;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class Counter<T> {
    private Map<Integer, Pair<T, Integer>> map = new HashMap<Integer, Pair<T, Integer>>();
    @Nullable
    private final Function<T, Integer> hashFunction;
    private Integer max;
    private Integer min;
    private int total = 0;

    public Counter(Function<T, Integer> hashFunction) {
        this.hashFunction = hashFunction;
    }

    public Counter() {
        this(null);
    }

    private int hash(T item) {
        if (item == null) {
            return 0;
        }
        if (this.hashFunction == null) {
            return item.hashCode();
        }
        return this.hashFunction.apply(item);
    }

    public void add(T item, int amount) {
        Validate.isTrue((amount > 0 ? 1 : 0) != 0, (String)"amount must be greater than zero");
        int hash = this.hash(item);
        if (this.map.containsKey(hash)) {
            this.set(hash, this.get(hash) + amount);
        } else {
            this.map.put(hash, new Pair<T, Integer>(item, amount));
        }
        if (this.min == null || this.min == hash) {
            Pair<Integer, Integer> maxMin = this.findMaxMin();
            this.max = maxMin.first();
            this.min = maxMin.second();
        } else if (this.get(hash) >= this.max().second()) {
            this.max = hash;
        }
        this.total += amount;
    }

    public void add(T item) {
        this.add(item, 1);
    }

    private void sub(int hash, int amount) {
        Validate.isTrue((amount > 0 ? 1 : 0) != 0, (String)"amount must be greater than zero");
        if (!this.map.containsKey(hash)) {
            return;
        }
        if (this.get(hash) <= amount) {
            this.remove(hash);
        } else {
            this.set(hash, this.get(hash) - amount);
            if (this.max == hash || this.max == null) {
                Pair<Integer, Integer> maxMin = this.findMaxMin();
                this.max = maxMin.first();
                this.min = maxMin.second();
            } else if (this.get(hash) <= this.min().second()) {
                this.min = hash;
            }
            this.total -= amount;
        }
    }

    public void sub(T item, int amount) {
        this.sub(this.hash(item), amount);
    }

    public void sub(T item) {
        this.sub(this.hash(item), 1);
    }

    private int get(Integer hash) {
        return this.map.containsKey(hash) ? this.map.get(hash).second() : 0;
    }

    public int get(T item) {
        return this.get(this.hash(item));
    }

    private void set(int hash, int amount) {
        Validate.isTrue((amount > 0 ? 1 : 0) != 0, (String)"amount must be greater than zero");
        this.map.get(hash).second(amount);
    }

    private void remove(int hash) {
        this.total -= this.get(hash);
        this.map.remove(hash);
        if (this.min == hash || this.max == hash) {
            Pair<Integer, Integer> maxMin = this.findMaxMin();
            this.max = maxMin.first();
            this.min = maxMin.second();
        }
    }

    public void remove(T item) {
        this.remove(this.hash(item));
    }

    public void clear() {
        this.map.clear();
        this.total = 0;
        this.max = null;
        this.min = null;
    }

    private Pair<Integer, Integer> findMaxMin() {
        int maxHash = 0;
        int maxAmount = 0;
        int minHash = 0;
        int minAmount = Integer.MAX_VALUE;
        if (this.map.size() == 0) {
            return new Pair<Object, Object>(null, null);
        }
        for (Map.Entry<Integer, Pair<T, Integer>> entry : this.map.entrySet()) {
            if (entry.getValue().second() >= maxAmount) {
                maxHash = entry.getKey();
                maxAmount = entry.getValue().second();
            }
            if (entry.getValue().second() > minAmount) continue;
            minHash = entry.getKey();
            minAmount = entry.getValue().second();
        }
        return new Pair<Integer, Integer>(maxHash, minHash);
    }

    public Pair<T, Integer> max() {
        return this.map.containsKey(this.max) ? this.map.get(this.max) : new Pair<T, Integer>(null, 0);
    }

    public Pair<T, Integer> min() {
        return this.map.containsKey(this.min) ? this.map.get(this.min) : new Pair<T, Integer>(null, Integer.MAX_VALUE);
    }

    public Collection<Pair<T, Integer>> entries() {
        return this.map.values();
    }

    public String toString() {
        StringBuilder string = new StringBuilder("{");
        for (Map.Entry<Integer, Pair<T, Integer>> key : this.map.entrySet()) {
            string.append(key.getValue().first() + ": " + key.getValue().second() + ", ");
        }
        string.delete(string.length() - 2, string.length()).append("}");
        return string.toString();
    }

    public String details() {
        StringBuilder string = new StringBuilder(this.toString());
        string.deleteCharAt(string.length() - 1).append(" | max: ").append(this.max().toString()).append(", min: ").append(this.min().toString()).append(", total: ").append(this.total).append("}");
        return string.toString();
    }

    public Stream<Pair<T, Integer>> stream() {
        return this.map.values().stream();
    }

    public int getTotal() {
        return this.total;
    }
}

