/*
 * Decompiled with CFR 0.152.
 */
package io.github.schntgaispock.gastronomicon.api.recipes;

import io.github.schntgaispock.gastronomicon.api.recipes.GastroRecipe;
import io.github.schntgaispock.gastronomicon.api.recipes.components.RecipeComponent;
import io.github.schntgaispock.gastronomicon.api.recipes.components.RecipeInput;
import io.github.schntgaispock.gastronomicon.core.slimefun.recipes.GastroRecipeType;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.bukkit.inventory.ItemStack;

public class ShapedGastroRecipe
extends GastroRecipe {
    public ShapedGastroRecipe(GastroRecipeType recipeType, RecipeComponent<?>[] ingredients, RecipeComponent<?> container, Set<ItemStack> tools, ItemStack ... outputs) {
        super(recipeType, new RecipeInput(GastroRecipe.RecipeShape.SHAPED, container, (RecipeComponent[])Arrays.stream(ingredients).map(ingredient -> ingredient == null ? RecipeComponent.EMPTY : ingredient).toArray(RecipeComponent[]::new)), tools, outputs);
    }

    public ShapedGastroRecipe(GastroRecipeType recipeType, ItemStack[] ingredients, @Nullable ItemStack container, Set<ItemStack> tools, ItemStack ... outputs) {
        super(recipeType, GastroRecipe.RecipeShape.SHAPED, ingredients, null, tools, outputs);
    }

    public ShapedGastroRecipe(GastroRecipeType recipeType, ItemStack[] ingredients, Set<ItemStack> tools, ItemStack ... outputs) {
        this(recipeType, ingredients, null, tools, outputs);
    }

    @Override
    public GastroRecipe.RecipeMatchResult matches(ItemStack[] givenIngredients, List<ItemStack> givenContainers, List<ItemStack> givenTools) {
        if (!givenContainers.stream().anyMatch(container -> this.getInputs().getContainer().matches((ItemStack)container))) {
            return GastroRecipe.RecipeMatchResult.NO_MATCH;
        }
        if (!givenTools.containsAll(this.getTools())) {
            return GastroRecipe.RecipeMatchResult.NO_MATCH;
        }
        for (int i = 0; i < givenIngredients.length; ++i) {
            if (ShapedGastroRecipe.componentMatches(this.getInputs().getIngredients()[i], givenIngredients[i])) continue;
            return GastroRecipe.RecipeMatchResult.NO_MATCH;
        }
        return GastroRecipe.RecipeMatchResult.SUCCESS;
    }
}

