/*
 * Decompiled with CFR 0.152.
 */
package io.github.schntgaispock.gastronomicon.api.recipes;

import io.github.schntgaispock.gastronomicon.api.recipes.GastroRecipe;
import io.github.schntgaispock.gastronomicon.api.recipes.components.GroupRecipeComponent;
import io.github.schntgaispock.gastronomicon.core.slimefun.recipes.GastroRecipeType;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;

public final class RecipeRegistry {
    private static final Map<GastroRecipeType, Set<GastroRecipe>> recipesByType = new HashMap<GastroRecipeType, Set<GastroRecipe>>();
    private static final Map<GastroRecipeType, Map<Integer, GastroRecipe>> savedRecipes = new HashMap<GastroRecipeType, Map<Integer, GastroRecipe>>();
    private static final Map<ItemStack, Set<GroupRecipeComponent>> groupsByItemStack = new HashMap<ItemStack, Set<GroupRecipeComponent>>();
    private static final Map<NamespacedKey, GroupRecipeComponent> groupsById = new HashMap<NamespacedKey, GroupRecipeComponent>();

    public static void registerRecipe(@Nonnull GastroRecipe recipe) {
        GastroRecipeType type = recipe.getRecipeType();
        if (recipesByType.containsKey((Object)type)) {
            recipesByType.get((Object)type).add(recipe);
        } else {
            HashSet<GastroRecipe> newSet = new HashSet<GastroRecipe>();
            newSet.add(recipe);
            recipesByType.put(type, newSet);
        }
    }

    public static void registerRecipes(GastroRecipe ... recipes) {
        for (GastroRecipe recipe : recipes) {
            RecipeRegistry.registerRecipe(recipe);
        }
    }

    private static void registerGroup(@Nonnull GroupRecipeComponent group) {
        for (ItemStack itemStack : (Set)group.getComponent()) {
            if (groupsByItemStack.containsKey(itemStack)) {
                groupsByItemStack.get(itemStack).add(group);
                continue;
            }
            HashSet<GroupRecipeComponent> groups = new HashSet<GroupRecipeComponent>();
            groups.add(group);
            groupsByItemStack.put(itemStack, groups);
        }
        groupsById.put(group.getId(), group);
    }

    public static void registerGroups(GroupRecipeComponent ... groups) {
        for (GroupRecipeComponent group : groups) {
            RecipeRegistry.registerGroup(group);
        }
    }

    @Nonnull
    public static Set<GroupRecipeComponent> getGroups(@Nonnull ItemStack item) {
        Set<GroupRecipeComponent> groups = groupsByItemStack.get(item);
        if (groups == null) {
            HashSet newGroups = new HashSet();
            groupsByItemStack.put(item, newGroups);
            return Collections.unmodifiableSet(newGroups);
        }
        return Collections.unmodifiableSet(groups);
    }

    @Nullable
    public static GroupRecipeComponent getGroupById(@Nonnull NamespacedKey name) {
        return groupsById.get(name);
    }

    @Nonnull
    public static Set<GastroRecipe> getRecipes(@Nonnull GastroRecipeType type) {
        return Collections.unmodifiableSet(recipesByType.getOrDefault((Object)type, new HashSet()));
    }

    @ParametersAreNonnullByDefault
    public static void saveRecipe(GastroRecipeType type, int hash, GastroRecipe recipe) {
        if (savedRecipes.containsKey((Object)type)) {
            savedRecipes.get((Object)type).put(hash, recipe);
        } else {
            HashMap<Integer, GastroRecipe> saved = new HashMap<Integer, GastroRecipe>();
            saved.put(hash, recipe);
            savedRecipes.put(type, saved);
        }
    }

    @Nullable
    public static GastroRecipe getSavedRecipe(GastroRecipeType type, int hash) {
        return savedRecipes.containsKey((Object)type) ? savedRecipes.get((Object)type).get(hash) : null;
    }

    private RecipeRegistry() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

