/*
 * Decompiled with CFR 0.152.
 */
package io.github.schntgaispock.gastronomicon.api.recipes;

import io.github.schntgaispock.gastronomicon.api.recipes.components.RecipeComponent;
import io.github.schntgaispock.gastronomicon.api.recipes.components.RecipeInput;
import io.github.schntgaispock.gastronomicon.api.recipes.components.SingleRecipeComponent;
import io.github.schntgaispock.gastronomicon.core.slimefun.recipes.GastroRecipeType;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNullableByDefault;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public abstract class GastroRecipe {
    private final GastroRecipeType recipeType;
    private final RecipeInput inputs;
    private final Set<ItemStack> tools;
    private final ItemStack[] outputs;

    public GastroRecipe(GastroRecipeType recipeType, RecipeInput inputs, Set<ItemStack> tools, ItemStack ... outputs) {
        this.recipeType = recipeType;
        this.inputs = inputs;
        this.tools = tools;
        this.outputs = outputs;
    }

    public GastroRecipe(GastroRecipeType recipeType, RecipeShape recipeShape, ItemStack[] ingredients, @Nullable ItemStack container, Set<ItemStack> tools, ItemStack ... outputs) {
        this(recipeType, new RecipeInput(recipeShape, container == null ? RecipeComponent.EMPTY : new SingleRecipeComponent(container), (RecipeComponent[])Arrays.stream(ingredients).map(ingredient -> ingredient == null ? RecipeComponent.EMPTY : new SingleRecipeComponent((ItemStack)ingredient)).toArray(RecipeComponent[]::new)), tools, outputs);
    }

    public GastroRecipe(GastroRecipeType recipeType, RecipeShape recipeShape, ItemStack[] ingredients, Set<ItemStack> tools, ItemStack ... outputs) {
        this(recipeType, recipeShape, ingredients, null, tools, outputs);
    }

    public abstract RecipeMatchResult matches(ItemStack[] var1, List<ItemStack> var2, List<ItemStack> var3);

    @ParametersAreNullableByDefault
    public static boolean componentMatches(RecipeComponent<?> component, ItemStack item) {
        return component == null ? item == null || item.getType() == Material.AIR : component.matches(item);
    }

    public GastroRecipeType getRecipeType() {
        return this.recipeType;
    }

    public RecipeInput getInputs() {
        return this.inputs;
    }

    public Set<ItemStack> getTools() {
        return this.tools;
    }

    public ItemStack[] getOutputs() {
        return this.outputs;
    }

    @Nonnull
    public String toString() {
        return "GastroRecipe(recipeType=" + this.getRecipeType() + ", inputs=" + this.getInputs() + ", tools=" + this.getTools() + ", outputs=" + Arrays.deepToString(this.getOutputs()) + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GastroRecipe)) {
            return false;
        }
        GastroRecipe other = (GastroRecipe)o;
        if (!other.canEqual(this)) {
            return false;
        }
        GastroRecipeType this$recipeType = this.getRecipeType();
        GastroRecipeType other$recipeType = other.getRecipeType();
        if (this$recipeType == null ? other$recipeType != null : !((Object)((Object)this$recipeType)).equals((Object)other$recipeType)) {
            return false;
        }
        RecipeInput this$inputs = this.getInputs();
        RecipeInput other$inputs = other.getInputs();
        if (this$inputs == null ? other$inputs != null : !this$inputs.equals(other$inputs)) {
            return false;
        }
        Set<ItemStack> this$tools = this.getTools();
        Set<ItemStack> other$tools = other.getTools();
        if (this$tools == null ? other$tools != null : !((Object)this$tools).equals(other$tools)) {
            return false;
        }
        return Arrays.deepEquals(this.getOutputs(), other.getOutputs());
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof GastroRecipe;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GastroRecipeType $recipeType = this.getRecipeType();
        result = result * 59 + ($recipeType == null ? 43 : ((Object)((Object)$recipeType)).hashCode());
        RecipeInput $inputs = this.getInputs();
        result = result * 59 + ($inputs == null ? 43 : ((Object)$inputs).hashCode());
        Set<ItemStack> $tools = this.getTools();
        result = result * 59 + ($tools == null ? 43 : ((Object)$tools).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getOutputs());
        return result;
    }

    public static enum RecipeShape {
        SHAPED((ItemStack)new CustomItemStack(Material.CRAFTING_TABLE, "&7This recipe is &fshaped", new String[0])),
        SHAPELESS((ItemStack)new CustomItemStack(Material.BARREL, "&7This recipe is &fshapeless", new String[0]));

        private final ItemStack guideItem;

        public ItemStack getGuideItem() {
            return this.guideItem;
        }

        private RecipeShape(ItemStack guideItem) {
            this.guideItem = guideItem;
        }
    }

    public static enum RecipeMatchResult {
        SUCCESS(true, true),
        NO_RESEARCH(true, false),
        NO_MATCH(false, false),
        OTHER(false, false);

        private final boolean match;
        private final boolean craftable;

        public boolean isMatch() {
            return this.match;
        }

        public boolean isCraftable() {
            return this.craftable;
        }

        private RecipeMatchResult(boolean match, boolean craftable) {
            this.match = match;
            this.craftable = craftable;
        }
    }
}

