/*
 * Decompiled with CFR 0.152.
 */
package io.github.schntgaispock.gastronomicon.core.listeners;

import io.github.schntgaispock.gastronomicon.Gastronomicon;
import io.github.schntgaispock.gastronomicon.api.loot.LootTable;
import io.github.schntgaispock.gastronomicon.core.Climate;
import io.github.schntgaispock.gastronomicon.core.slimefun.GastroStacks;
import io.github.schntgaispock.gastronomicon.util.NumberUtil;
import io.github.schntgaispock.gastronomicon.util.StringUtil;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class WildHarvestListener
implements Listener {
    private static final Map<Climate, Map<Material, LootTable<ItemStack>>> dropsByClimateByBlock = new HashMap<Climate, Map<Material, LootTable<ItemStack>>>();
    private static final Map<Material, LootTable<ItemStack>> dropsByBlock = new HashMap<Material, LootTable<ItemStack>>();
    private static final Map<EntityType, LootTable<ItemStack>> dropsByMob = new HashMap<EntityType, LootTable<ItemStack>>();
    private static final List<String> worldsDisabledIn = new ArrayList<String>();
    private static final Map<Material, Double> blockDropChanceCache = new HashMap<Material, Double>();
    private static final Map<EntityType, Double> mobDropChanceCache = new HashMap<EntityType, Double>();

    public static void registerBlockDrops(Material material, LootTable<ItemStack> table, Climate climate) {
        Map<Material, LootTable<ItemStack>> climateDrops = dropsByClimateByBlock.get((Object)climate);
        if (climateDrops == null) {
            climateDrops = new HashMap<Material, LootTable<ItemStack>>();
        }
        climateDrops.put(material, table);
        dropsByClimateByBlock.put(climate, climateDrops);
    }

    public static void registerBlockDrops(Material material, LootTable<ItemStack> table) {
        dropsByBlock.put(material, table);
    }

    public static void registerMobDrops(EntityType entityType, LootTable<ItemStack> table) {
        dropsByMob.put(entityType, table);
    }

    private double getDropChance(Material mat) {
        if (blockDropChanceCache.containsKey(mat)) {
            return blockDropChanceCache.get(mat);
        }
        double chance = Gastronomicon.getInstance().getConfig().getDouble("drops.block-break-chances." + StringUtil.kebabCase(mat.name()), 0.15);
        blockDropChanceCache.put(mat, chance);
        return chance;
    }

    private double getDropChance(EntityType entity) {
        if (mobDropChanceCache.containsKey(entity)) {
            return mobDropChanceCache.get(entity);
        }
        double chance = Gastronomicon.getInstance().getConfig().getDouble("drops.mob-kill-chances." + StringUtil.kebabCase(entity.name()), 0.35);
        mobDropChanceCache.put(entity, chance);
        return chance;
    }

    @Nullable
    @ParametersAreNonnullByDefault
    public static LootTable<ItemStack> getDrops(Material dropFrom, Climate climate) {
        if (dropsByClimateByBlock.containsKey((Object)climate) && dropsByClimateByBlock.get((Object)climate).containsKey(dropFrom)) {
            return dropsByClimateByBlock.get((Object)climate).get(dropFrom);
        }
        return dropsByBlock.getOrDefault(dropFrom, null);
    }

    @Nullable
    public static LootTable<ItemStack> getDrops(@Nonnull EntityType dropFrom) {
        return dropsByMob.getOrDefault(dropFrom, null);
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent e) {
        int fortune;
        if (worldsDisabledIn.contains(e.getBlock().getWorld().getName())) {
            return;
        }
        Block b = e.getBlock();
        if (b == null) {
            return;
        }
        LootTable<ItemStack> drops = WildHarvestListener.getDrops(b.getType(), Climate.of(b.getBiome()));
        if (drops == null) {
            return;
        }
        if (!Slimefun.getProtectionManager().hasPermission((OfflinePlayer)e.getPlayer(), e.getBlock(), Interaction.BREAK_BLOCK)) {
            return;
        }
        ItemStack weapon = e.getPlayer().getInventory().getItemInMainHand();
        int n = fortune = weapon == null ? 0 : weapon.getEnchantmentLevel(Enchantment.LOOT_BONUS_BLOCKS);
        if (NumberUtil.flip(this.getDropChance(b.getType()) * (1.0 + (double)fortune * 0.5))) {
            ItemStack drop = drops.generate();
            if (drop == null) {
                return;
            }
            e.getBlock().getWorld().dropItemNaturally(e.getBlock().getLocation(), drop.clone());
        }
    }

    @EventHandler
    public void onMobKill(EntityDeathEvent e) {
        int looting;
        if (worldsDisabledIn.contains(e.getEntity().getWorld().getName())) {
            return;
        }
        LootTable<ItemStack> drops = WildHarvestListener.getDrops(e.getEntityType());
        if (drops == null) {
            return;
        }
        Player killer = e.getEntity().getKiller();
        int n = looting = killer == null || killer.getInventory().getItemInMainHand() == null ? 0 : killer.getInventory().getItemInMainHand().getEnchantmentLevel(Enchantment.LOOT_BONUS_MOBS);
        if (NumberUtil.flip(this.getDropChance(e.getEntityType()) * (1.0 + (double)looting * 0.5))) {
            ItemStack drop = drops.generate();
            if (drop == null) {
                return;
            }
            e.getDrops().add(drop.clone());
        }
    }

    public static void setup() {
        Bukkit.getPluginManager().registerEvents((Listener)new WildHarvestListener(), (Plugin)Gastronomicon.getInstance());
        worldsDisabledIn.addAll(Gastronomicon.getInstance().getConfig().getStringList("drops.disabled-in"));
        LootTable<ItemStack> DRY_CLIMATE_GRASS_DROPS = LootTable.builder().addItems(new ItemStack[]{GastroStacks.CASSAVA, GastroStacks.LENTILS, GastroStacks.CUMIN_SEEDS, GastroStacks.HONEYDEW_MELON_SEEDS, GastroStacks.SORGHUM_SEEDS}).build();
        LootTable<ItemStack> TEMPERATE_CLIMATE_GRASS_DROPS = LootTable.builder().addItems(6, new ItemStack[]{GastroStacks.RICE, GastroStacks.OATS, GastroStacks.SOYBEANS, GastroStacks.BARLEY_SEEDS, GastroStacks.RYE_SEEDS, GastroStacks.SORGHUM_SEEDS}).addItems(4, new ItemStack[]{GastroStacks.TURNIP_SEEDS, GastroStacks.RED_BEANS, GastroStacks.CANTALOUPE_SEEDS, GastroStacks.HONEYDEW_MELON_SEEDS, GastroStacks.SESAME_SEEDS, GastroStacks.PEANUTS, GastroStacks.BEANS, GastroStacks.PEAS}).addItems(3, new ItemStack[]{GastroStacks.BOK_CHOY_SEEDS, GastroStacks.CUCUMBER_SEEDS, GastroStacks.BASIL_SEEDS, GastroStacks.SPINACH_SEEDS, GastroStacks.MINT_SEEDS, GastroStacks.CHILI_PEPPER_SEEDS, GastroStacks.PARSLEY_SEEDS, GastroStacks.CASSAVA, GastroStacks.LENTILS, GastroStacks.ASPARAGUS_SEEDS, GastroStacks.GREEN_ONION_SEEDS, GastroStacks.CAULIFLOWER_SEEDS, GastroStacks.AVOCADO_PIT, GastroStacks.TURMERIC, GastroStacks.CUMIN_SEEDS, GastroStacks.VANILLA_PLANT}).addItems(2, new ItemStack[]{GastroStacks.LYCHEE_SAPLING, GastroStacks.BANANA_SAPLING}).build();
        LootTable<ItemStack> COLD_CLIMATE_GRASS_DROPS = LootTable.builder().addItems(6, new ItemStack[]{GastroStacks.QUINOA, GastroStacks.OATS, GastroStacks.RYE_SEEDS}).addItems(4, new ItemStack[]{GastroStacks.TURNIP_SEEDS, GastroStacks.SQUASH_SEEDS, GastroStacks.PEAS}).addItems(3, new ItemStack[]{GastroStacks.CELERY, GastroStacks.BROCCOLI_SEEDS, GastroStacks.BRUSSLES_SPROUTS}).addItems(2, new ItemStack[]{GastroStacks.LYCHEE_SAPLING}).build();
        LootTable<ItemStack> SNOWY_CLIMATE_GRASS_DROPS = LootTable.builder().addItems(new ItemStack[]{GastroStacks.RYE_SEEDS}).build();
        LootTable<ItemStack> FERN_DROPS = LootTable.builder().addItems(new ItemStack[]{GastroStacks.FIDDLEHEADS}).build();
        LootTable<ItemStack> DIRT_DROPS = LootTable.builder().addItems(new ItemStack[]{GastroStacks.ENOKI_MUSHROOMS, GastroStacks.KING_OYSTER_MUSHROOM, GastroStacks.BUTTON_MUSHROOM}).build();
        LootTable<ItemStack> PODZOL_DROPS = LootTable.builder().addItems(4, new ItemStack[]{GastroStacks.ENOKI_MUSHROOMS, GastroStacks.KING_OYSTER_MUSHROOM, GastroStacks.BUTTON_MUSHROOM}).addItems(new ItemStack[]{GastroStacks.TRUFFLE}).build();
        LootTable<ItemStack> SEAGRASS_DROPS = LootTable.builder().addItems(new ItemStack[]{GastroStacks.CLAM}).build();
        LootTable<ItemStack> SQUID_DROPS = LootTable.builder().addItems(new ItemStack[]{GastroStacks.RAW_SQUID}).build();
        LootTable<ItemStack> GUARDIAN_DROPS = LootTable.builder().addItems(new ItemStack[]{GastroStacks.GUARDIAN_FIN}).build();
        LootTable<ItemStack> GOAT_DROPS = LootTable.builder().addItems(new ItemStack[]{GastroStacks.RAW_CHEVON}).build();
        LootTable<ItemStack> SALMON_DROPS = LootTable.builder().addItems(new ItemStack[]{GastroStacks.SALMON_ROE}).build();
        WildHarvestListener.registerBlockDrops(Material.GRASS, DRY_CLIMATE_GRASS_DROPS, Climate.DRY);
        WildHarvestListener.registerBlockDrops(Material.TALL_GRASS, DRY_CLIMATE_GRASS_DROPS, Climate.DRY);
        WildHarvestListener.registerBlockDrops(Material.GRASS, TEMPERATE_CLIMATE_GRASS_DROPS, Climate.TEMPERATE);
        WildHarvestListener.registerBlockDrops(Material.TALL_GRASS, TEMPERATE_CLIMATE_GRASS_DROPS, Climate.TEMPERATE);
        WildHarvestListener.registerBlockDrops(Material.GRASS, COLD_CLIMATE_GRASS_DROPS, Climate.COLD);
        WildHarvestListener.registerBlockDrops(Material.TALL_GRASS, COLD_CLIMATE_GRASS_DROPS, Climate.COLD);
        WildHarvestListener.registerBlockDrops(Material.GRASS, SNOWY_CLIMATE_GRASS_DROPS, Climate.SNOWY);
        WildHarvestListener.registerBlockDrops(Material.TALL_GRASS, SNOWY_CLIMATE_GRASS_DROPS, Climate.SNOWY);
        WildHarvestListener.registerBlockDrops(Material.FERN, FERN_DROPS);
        WildHarvestListener.registerBlockDrops(Material.LARGE_FERN, FERN_DROPS);
        WildHarvestListener.registerBlockDrops(Material.PODZOL, PODZOL_DROPS);
        WildHarvestListener.registerBlockDrops(Material.DIRT, DIRT_DROPS);
        WildHarvestListener.registerBlockDrops(Material.GRASS_BLOCK, DIRT_DROPS);
        WildHarvestListener.registerBlockDrops(Material.ROOTED_DIRT, DIRT_DROPS);
        WildHarvestListener.registerBlockDrops(Material.MYCELIUM, DIRT_DROPS);
        WildHarvestListener.registerBlockDrops(Material.SEAGRASS, SEAGRASS_DROPS);
        WildHarvestListener.registerMobDrops(EntityType.SQUID, SQUID_DROPS);
        WildHarvestListener.registerMobDrops(EntityType.GUARDIAN, GUARDIAN_DROPS);
        WildHarvestListener.registerMobDrops(EntityType.GOAT, GOAT_DROPS);
        WildHarvestListener.registerMobDrops(EntityType.SALMON, SALMON_DROPS);
    }
}

