/*
 * Decompiled with CFR 0.152.
 */
package io.github.schntgaispock.gastronomicon.api.recipes.components;

import io.github.schntgaispock.gastronomicon.api.recipes.GastroRecipe;
import io.github.schntgaispock.gastronomicon.api.recipes.components.RecipeComponent;
import io.github.schntgaispock.gastronomicon.util.RecipeUtil;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class RecipeInput {
    private final GastroRecipe.RecipeShape shapedness;
    private final RecipeComponent<?> container;
    private final RecipeComponent<?>[] ingredients;

    public RecipeInput(GastroRecipe.RecipeShape shapedness, RecipeComponent<?> container, RecipeComponent<?> ... ingredients) {
        this.shapedness = shapedness;
        if (shapedness == GastroRecipe.RecipeShape.SHAPELESS) {
            Arrays.sort(ingredients, RecipeUtil::compareComponents);
        }
        this.ingredients = new RecipeComponent[9];
        for (int i = 0; i < Math.min(ingredients.length, 9); ++i) {
            this.ingredients[i] = ingredients[i];
        }
        this.container = container;
    }

    public ItemStack[] getDisplayIngredients() {
        return (ItemStack[])Arrays.stream(this.ingredients).map(ingredient -> ingredient == null ? new ItemStack(Material.AIR) : ingredient.getComponent()).toArray(ItemStack[]::new);
    }

    public RecipeComponent<?>[] getAll() {
        RecipeComponent<?>[] all = Arrays.copyOf(this.ingredients, this.ingredients.length + 1);
        all[this.ingredients.length] = this.container;
        return all;
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + this.shapedness.hashCode();
        if (this.container != null) {
            hash = hash * 31 + this.container.hashCode();
        }
        for (RecipeComponent<?> ingredient : this.ingredients) {
            hash = hash * 31 + ingredient.hashCode();
        }
        return hash;
    }

    public GastroRecipe.RecipeShape getShapedness() {
        return this.shapedness;
    }

    public RecipeComponent<?> getContainer() {
        return this.container;
    }

    public RecipeComponent<?>[] getIngredients() {
        return this.ingredients;
    }

    @Nonnull
    public String toString() {
        return "RecipeInput(shapedness=" + this.getShapedness() + ", container=" + this.getContainer() + ", ingredients=" + Arrays.deepToString(this.getIngredients()) + ")";
    }
}

