/*
 * Decompiled with CFR 0.152.
 */
package io.github.schntgaispock.gastronomicon.core.slimefun.items.workstations.automatic;

import io.github.schntgaispock.gastronomicon.core.slimefun.GastroGroups;
import io.github.schntgaispock.gastronomicon.core.slimefun.GastroStacks;
import io.github.schntgaispock.gastronomicon.util.collections.CollectionUtil;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.MachineProcessHolder;
import io.github.thebusybiscuit.slimefun4.core.machines.MachineOperation;
import io.github.thebusybiscuit.slimefun4.core.machines.MachineProcessor;
import io.github.thebusybiscuit.slimefun4.implementation.handlers.SimpleBlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.implementation.operations.CraftingOperation;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineRecipe;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.interfaces.InventoryBlock;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.inventory.ItemStack;

public class FishingNet
extends SlimefunItem
implements InventoryBlock,
MachineProcessHolder<CraftingOperation> {
    public static final int[] BACKGROUND_SLOTS = new int[]{0, 1, 2, 9, 11, 18, 19, 20};
    public static final int[] OUTPUT_BORDER = new int[]{3, 12, 21};
    public static final int STATUS_SLOT = 10;
    public static final ItemStack[] FISH = new ItemStack[]{GastroStacks.RAW_BASS, GastroStacks.RAW_CARP, GastroStacks.RAW_EEL, GastroStacks.RAW_MACKEREL, GastroStacks.RAW_PIKE, GastroStacks.RAW_SQUID, GastroStacks.RAW_TROUT, GastroStacks.RAW_TUNA, GastroStacks.SHRIMP, new ItemStack(Material.COD), new ItemStack(Material.SALMON), new ItemStack(Material.PUFFERFISH), new ItemStack(Material.TROPICAL_FISH)};
    private final String machineIdentifier = "GN_FISHING_NET";
    private final MachineProcessor<CraftingOperation> machineProcessor = new MachineProcessor((MachineProcessHolder)this);
    private final ItemStack progressBar = new ItemStack(Material.FISHING_ROD);
    private final int[] inputSlots = new int[0];
    private final int[] outputSlots = new int[]{4, 5, 6, 7, 8, 13, 14, 15, 16, 17, 22, 23, 24, 25, 26};
    private final int speed;

    public FishingNet(SlimefunItemStack item, int speed, ItemStack[] recipe) {
        super((ItemGroup)GastroGroups.ELECTRIC_MACHINES, item, RecipeType.ENHANCED_CRAFTING_TABLE, recipe);
        this.speed = speed;
        this.machineProcessor.setProgressBar(this.progressBar);
        this.createPreset(this, this::constructMenu);
    }

    public void preRegister() {
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            public void tick(Block b, SlimefunItem sf, Config data) {
                FishingNet.this.tick(b);
            }

            public boolean isSynchronized() {
                return false;
            }
        }});
        this.addItemHandler(new ItemHandler[]{new SimpleBlockBreakHandler(){

            public void onBlockBreak(Block b) {
                BlockMenu inv = BlockStorage.getInventory((Block)b);
                if (inv != null) {
                    inv.dropItems(b.getLocation(), FishingNet.this.getOutputSlots());
                }
                FishingNet.this.machineProcessor.endOperation(b);
            }
        }});
    }

    protected void constructMenu(BlockMenuPreset menu) {
        this.draw(menu, GastroStacks.MENU_BACKGROUND_ITEM, BACKGROUND_SLOTS);
        this.draw(menu, GastroStacks.MENU_OUTPUT_BORDER, OUTPUT_BORDER);
        this.draw(menu, GastroStacks.MENU_NOT_WATERLOGGED, 10);
    }

    private void draw(BlockMenuPreset preset, ItemStack item, int ... slots) {
        for (int slot : slots) {
            preset.addItem(slot, item, ChestMenuUtils.getEmptyClickHandler());
        }
    }

    protected MachineRecipe findNextRecipe(BlockMenu menu) {
        return new MachineRecipe(240 / this.getSpeed(), new ItemStack[]{new ItemStack(Material.AIR)}, new ItemStack[]{CollectionUtil.choice(FISH)});
    }

    protected void tick(Block b) {
        BlockMenu inv = BlockStorage.getInventory((Block)b);
        CraftingOperation currentOperation = (CraftingOperation)this.getMachineProcessor().getOperation(b);
        if (currentOperation != null) {
            Waterlogged waterlogged;
            ItemStack[] itemStackArray = inv.getBlock().getBlockData();
            if (itemStackArray instanceof Waterlogged && (waterlogged = (Waterlogged)itemStackArray).isWaterlogged()) {
                if (!currentOperation.isFinished()) {
                    this.getMachineProcessor().updateProgressBar(inv, 10, (MachineOperation)currentOperation);
                    currentOperation.addProgress(1);
                } else {
                    inv.replaceExistingItem(10, (ItemStack)new CustomItemStack(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]));
                    for (ItemStack output : currentOperation.getResults()) {
                        inv.pushItem(output.clone(), this.getOutputSlots());
                    }
                    this.getMachineProcessor().endOperation(b);
                }
            }
        } else {
            MachineRecipe next;
            Waterlogged bar;
            BlockData waterlogged = b.getBlockData();
            if (waterlogged instanceof Waterlogged && (bar = (Waterlogged)waterlogged).isWaterlogged() && (next = this.findNextRecipe(inv)) != null) {
                currentOperation = new CraftingOperation(next);
                this.getMachineProcessor().startOperation(b, (MachineOperation)currentOperation);
                this.getMachineProcessor().updateProgressBar(inv, 10, (MachineOperation)currentOperation);
            }
        }
    }

    public String getMachineIdentifier() {
        return this.machineIdentifier;
    }

    public MachineProcessor<CraftingOperation> getMachineProcessor() {
        return this.machineProcessor;
    }

    public ItemStack getProgressBar() {
        return this.progressBar;
    }

    public int[] getInputSlots() {
        return this.inputSlots;
    }

    public int[] getOutputSlots() {
        return this.outputSlots;
    }

    public int getSpeed() {
        return this.speed;
    }
}

