/*
 * Decompiled with CFR 0.152.
 */
package io.github.schntgaispock.gastronomicon.api.items;

import io.github.schntgaispock.gastronomicon.api.food.FoodEffect;
import io.github.schntgaispock.gastronomicon.api.items.FoodItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import org.bukkit.Material;

public class FoodItemStackBuilder {
    private String id;
    private String texture;
    private Material material;
    private String name;
    private String[] lore = new String[0];
    private String[] perfectLore = new String[0];
    private int hunger = 0;
    private double saturationRatio = 1.0;
    private FoodEffect[] effects = new FoodEffect[0];

    public FoodItemStackBuilder id(String id) {
        this.id = id;
        return this;
    }

    public FoodItemStackBuilder texture(String texture) {
        Validate.isTrue((this.material == null ? 1 : 0) != 0, (String)"Cannot set a texture because this item already has a material!");
        this.texture = texture;
        return this;
    }

    public FoodItemStackBuilder material(Material material) {
        Validate.isTrue((this.texture == null ? 1 : 0) != 0, (String)"Cannot set a material because this item already has a texture");
        this.material = material;
        return this;
    }

    public FoodItemStackBuilder name(String name) {
        this.name = name;
        return this;
    }

    public FoodItemStackBuilder lore(String ... lore) {
        this.lore = lore;
        this.perfectLore = lore;
        return this;
    }

    public FoodItemStackBuilder perfectLore(String ... lore) {
        this.perfectLore = lore;
        return this;
    }

    public FoodItemStackBuilder hunger(int hunger, double saturationRatio) {
        this.hunger = hunger;
        this.saturationRatio = saturationRatio;
        return this;
    }

    public FoodItemStackBuilder hunger(int hunger) {
        this.hunger = hunger;
        return this;
    }

    public FoodItemStackBuilder effects(FoodEffect ... effects) {
        this.effects = effects;
        return this;
    }

    public FoodItemStack build() {
        Validate.notNull((Object)this.id, (String)"Must set an id!");
        Validate.notNull((Object)this.name, (String)"Must set a name!");
        Validate.isTrue((this.material != null || this.texture != null ? 1 : 0) != 0, (String)"Must set a material or texture!");
        return this.texture == null ? FoodItemStack.of(this.id, this.material, this.name, this.hunger, this.saturationRatio, this.effects, this.lore, this.perfectLore) : FoodItemStack.of(this.id, this.texture, this.name, this.hunger, this.saturationRatio, this.effects, this.lore, this.perfectLore);
    }
}

