/*
 * Decompiled with CFR 0.152.
 */
package io.github.schntgaispock.gastronomicon.core.slimefun.items.workstations.automatic;

import io.github.schntgaispock.gastronomicon.api.recipes.GastroRecipe;
import io.github.schntgaispock.gastronomicon.api.recipes.components.RecipeComponent;
import io.github.schntgaispock.gastronomicon.core.slimefun.GastroGroups;
import io.github.schntgaispock.gastronomicon.core.slimefun.GastroStacks;
import io.github.schntgaispock.gastronomicon.core.slimefun.items.food.SimpleGastroFood;
import io.github.schntgaispock.gastronomicon.util.collections.Counter;
import io.github.schntgaispock.gastronomicon.util.collections.Pair;
import io.github.schntgaispock.gastronomicon.util.item.GastroKeys;
import io.github.schntgaispock.gastronomicon.util.item.ItemUtil;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.MachineProcessHolder;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.machines.MachineOperation;
import io.github.thebusybiscuit.slimefun4.core.machines.MachineProcessor;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.handlers.SimpleBlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.implementation.operations.CraftingOperation;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ClickAction;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineRecipe;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.inventory.DirtyChestMenu;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;

public class ElectricKitchen
extends AContainer {
    protected static final int[] BACKGROUND_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 13, 16, 17, 22, 23, 24, 25, 26, 31, 32, 33, 34, 35, 40, 44, 45, 46, 47, 48, 49, 50, 51, 52};
    protected static final int[] INPUT_BORDER = new int[]{9, 18, 27, 36};
    protected static final int ANDROID_BORDER = 14;
    protected static final int OUTPUT_BORDER = 41;
    protected static final int ANDROID_SLOT = 15;
    protected static final int STATUS_SLOT = 53;
    private static Map<Location, Pair<Integer, Counter<Integer>>> lastInputHashAndRecipe = new HashMap<Location, Pair<Integer, Counter<Integer>>>();
    private final EnergyNetComponentType energyComponentType = EnergyNetComponentType.CONSUMER;
    private final String machineIdentifier = "GN_ELECTRIC_KITCHEN";
    private final MachineProcessor<CraftingOperation> machineProcessor = new MachineProcessor((MachineProcessHolder)this);
    private final ItemStack progressBar = new ItemStack(Material.FLINT_AND_STEEL);

    public ElectricKitchen(SlimefunItemStack item, int capacity, int energyConsumption, int speed, ItemStack[] recipe) {
        super((ItemGroup)GastroGroups.ELECTRIC_MACHINES, item, RecipeType.ENHANCED_CRAFTING_TABLE, recipe);
        this.setCapacity(capacity);
        this.setEnergyConsumption(energyConsumption);
        this.setProcessingSpeed(speed);
        this.machineProcessor.setProgressBar(this.progressBar);
    }

    public void createPreset(final SlimefunItem item, String title, final Consumer<BlockMenuPreset> setup) {
        new BlockMenuPreset(item.getId(), title){

            public void init() {
                setup.accept(this);
            }

            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                if (flow == ItemTransportFlow.INSERT) {
                    return ElectricKitchen.this.getInputSlots();
                }
                return ElectricKitchen.this.getOutputSlots();
            }

            public int[] getSlotsAccessedByItemTransport(DirtyChestMenu menu, ItemTransportFlow flow, ItemStack item2) {
                if (flow == ItemTransportFlow.INSERT) {
                    int[] slots = Arrays.stream(ElectricKitchen.this.getInputSlots()).mapToObj(slot -> new Pair<Integer, ItemStack>(slot, menu.getItemInSlot(slot))).filter(pair -> pair.second() != null && ((ItemStack)pair.second()).getType() == item2.getType()).mapToInt(pair -> (Integer)pair.first()).toArray();
                    return slots.length == 0 ? ElectricKitchen.this.getInputSlots() : slots;
                }
                return ElectricKitchen.this.getOutputSlots();
            }

            public boolean canOpen(Block b, Player p) {
                if (p.hasPermission("slimefun.inventory.bypass")) {
                    return true;
                }
                return item.canUse(p, false) && Slimefun.getProtectionManager().hasPermission((OfflinePlayer)p, b.getLocation(), Interaction.INTERACT_BLOCK);
            }
        };
    }

    public int[] getInputSlots() {
        return new int[]{10, 11, 12, 19, 20, 21, 28, 29, 30, 37, 38, 39};
    }

    public int[] getOutputSlots() {
        return new int[]{42, 43};
    }

    @Nonnull
    protected BlockBreakHandler onBlockBreak() {
        return new SimpleBlockBreakHandler(){

            public void onBlockBreak(Block b) {
                BlockMenu inv = BlockStorage.getInventory((Block)b);
                if (inv != null) {
                    inv.dropItems(b.getLocation(), ElectricKitchen.this.getInputSlots());
                    inv.dropItems(b.getLocation(), ElectricKitchen.this.getOutputSlots());
                    inv.dropItems(b.getLocation(), new int[]{15});
                }
                ElectricKitchen.this.getMachineProcessor().endOperation(b);
                lastInputHashAndRecipe.remove(b.getLocation());
            }
        };
    }

    protected void constructMenu(BlockMenuPreset preset) {
        this.draw(preset, GastroStacks.MENU_BACKGROUND_ITEM, BACKGROUND_SLOTS);
        this.draw(preset, GastroStacks.MENU_INPUT_BORDER, INPUT_BORDER);
        this.draw(preset, GastroStacks.MENU_ANDROID_BORDER, 14);
        this.draw(preset, GastroStacks.MENU_OUTPUT_BORDER, 41);
        this.draw(preset, GastroStacks.MENU_NO_ANDROID, 53);
        for (int i : this.getOutputSlots()) {
            preset.addMenuClickHandler(i, (ChestMenu.MenuClickHandler)new ChestMenu.AdvancedMenuClickHandler(){

                public boolean onClick(Player p, int slot, ItemStack cursor, ClickAction action) {
                    return false;
                }

                public boolean onClick(InventoryClickEvent e, Player p, int slot, ItemStack cursor, ClickAction action) {
                    return cursor == null || cursor.getType() == null || cursor.getType() == Material.AIR;
                }
            });
        }
    }

    private void draw(BlockMenuPreset preset, ItemStack item, int ... slots) {
        for (int slot : slots) {
            preset.addItem(slot, item, ChestMenuUtils.getEmptyClickHandler());
        }
    }

    protected MachineRecipe findNextRecipe(BlockMenu menu) {
        Counter<Integer> found;
        Pair<Integer, Counter<Integer>> hashRecipePair;
        ItemStack android = menu.getItemInSlot(15);
        if (android == null) {
            menu.replaceExistingItem(53, GastroStacks.MENU_NO_ANDROID);
            return null;
        }
        String foodId = (String)android.getItemMeta().getPersistentDataContainer().get(GastroKeys.CHEF_ANDROID_FOOD, PersistentDataType.STRING);
        if (foodId == null) {
            menu.replaceExistingItem(53, GastroStacks.MENU_NO_ANDROID);
            return null;
        }
        SlimefunItem food = SlimefunItem.getById((String)foodId);
        if (food == null || !(food instanceof SimpleGastroFood)) {
            menu.replaceExistingItem(53, GastroStacks.MENU_NO_ANDROID);
            return null;
        }
        SimpleGastroFood gastroFood = (SimpleGastroFood)food;
        GastroRecipe recipe = gastroFood.getGastroRecipe();
        int hash = 1;
        for (int slot : this.getInputSlots()) {
            hash = hash * 31 + ItemUtil.hashIgnoreAmount(menu.getItemInSlot(slot));
        }
        if (lastInputHashAndRecipe.containsKey(menu.getLocation())) {
            hashRecipePair = lastInputHashAndRecipe.get(menu.getLocation());
        } else {
            hashRecipePair = new Pair<Integer, Object>(0, null);
            lastInputHashAndRecipe.put(menu.getLocation(), hashRecipePair);
        }
        if (hashRecipePair.first() == hash) {
            found = hashRecipePair.second();
        } else {
            found = new Counter();
            for (RecipeComponent<?> component : recipe.getInputs().getAll()) {
                if (component == RecipeComponent.EMPTY) continue;
                boolean matched = false;
                for (int slot : this.getInputSlots()) {
                    ItemStack input = menu.getItemInSlot(slot);
                    if (!component.matches(input) || input.getAmount() <= found.get((Integer)slot)) continue;
                    matched = true;
                    found.add(slot);
                    break;
                }
                if (matched) continue;
                menu.replaceExistingItem(53, GastroStacks.MENU_INCORRECT_RECIPE);
                return null;
            }
            hashRecipePair.first(hash);
            hashRecipePair.second(found);
        }
        MachineRecipe newRecipe = new MachineRecipe(60 / this.getSpeed(), (ItemStack[])found.entries().stream().filter(pair -> pair.first() != null).map(pair -> {
            ItemStack input = menu.getItemInSlot(((Integer)pair.first()).intValue());
            ItemStack clone = input.asQuantity(((Integer)pair.second()).intValue());
            input.subtract(((Integer)pair.second()).intValue());
            return clone;
        }).toArray(ItemStack[]::new), new ItemStack[]{recipe.getOutputs()[0]});
        return newRecipe;
    }

    protected void tick(Block b) {
        BlockMenu inv = BlockStorage.getInventory((Block)b);
        CraftingOperation currentOperation = (CraftingOperation)this.getMachineProcessor().getOperation(b);
        if (currentOperation != null) {
            if (this.takeCharge(b.getLocation())) {
                if (!currentOperation.isFinished()) {
                    this.getMachineProcessor().updateProgressBar(inv, 53, (MachineOperation)currentOperation);
                    currentOperation.addProgress(1);
                } else {
                    inv.replaceExistingItem(53, (ItemStack)new CustomItemStack(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]));
                    for (ItemStack output : currentOperation.getResults()) {
                        inv.pushItem(output.clone(), this.getOutputSlots());
                    }
                    this.getMachineProcessor().endOperation(b);
                }
            } else {
                inv.replaceExistingItem(53, GastroStacks.MENU_NOT_ENOUGH_ENERGY);
            }
        } else {
            MachineRecipe next = this.findNextRecipe(inv);
            if (next != null && next.getInput() != null) {
                currentOperation = new CraftingOperation(next);
                this.getMachineProcessor().startOperation(b, (MachineOperation)currentOperation);
                this.getMachineProcessor().updateProgressBar(inv, 53, (MachineOperation)currentOperation);
            }
        }
    }

    public EnergyNetComponentType getEnergyComponentType() {
        return this.energyComponentType;
    }

    public String getMachineIdentifier() {
        return this.machineIdentifier;
    }

    public MachineProcessor<CraftingOperation> getMachineProcessor() {
        return this.machineProcessor;
    }

    public ItemStack getProgressBar() {
        return this.progressBar;
    }
}

