/*
 * Decompiled with CFR 0.152.
 */
package io.github.schntgaispock.gastronomicon.core.slimefun.items.seeds;

import io.github.schntgaispock.gastronomicon.Gastronomicon;
import io.github.schntgaispock.gastronomicon.core.slimefun.items.seeds.AbstractSeed;
import io.github.schntgaispock.gastronomicon.util.RecipeUtil;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;

public class DuplicatingSeed
extends AbstractSeed {
    @ParametersAreNonnullByDefault
    public DuplicatingSeed(SlimefunItemStack item, ItemStack[] gatherSources) {
        super(item, gatherSources);
        switch (item.getType()) {
            case CACTUS: 
            case SUGAR_CANE: {
                break;
            }
            default: {
                Gastronomicon.log(Level.WARNING, "Registering a DuplicatingSeed that isn't a cactus or sugar cane!");
            }
        }
    }

    @ParametersAreNonnullByDefault
    public DuplicatingSeed(SlimefunItemStack item, SlimefunItemStack harvestSource) {
        this(item, RecipeUtil.singleCenter((ItemStack)harvestSource));
    }

    @Override
    public void preRegister() {
        this.addItemHandler(new ItemHandler[]{new BlockPlaceHandler(true){

            public void onPlayerPlace(BlockPlaceEvent e) {
                if (e.getBlock().getState().getLightLevel() <= 7) {
                    e.setCancelled(true);
                    BlockStorage.clearBlockInfo((Block)e.getBlock(), (boolean)true);
                }
            }
        }});
    }

    @Override
    public boolean isMature(BlockState b) {
        return false;
    }

    @Override
    public List<ItemStack> getHarvestDrops(BlockState e, ItemStack item, boolean brokenByPlayer) {
        return brokenByPlayer ? new ArrayList<ItemStack>() : Arrays.asList(this.getItem().clone());
    }
}

