/*
 * Decompiled with CFR 0.152.
 */
package io.github.schntgaispock.gastronomicon.util;

import java.util.concurrent.ThreadLocalRandom;

public final class NumberUtil {
    private static ThreadLocalRandom random = ThreadLocalRandom.current();

    public static int clamp(int x, int lowerBound, int upperBound) {
        return Math.min(Math.max(x, lowerBound), upperBound);
    }

    public static double clamp(double x, double lowerBound, double upperBound) {
        return Math.min(Math.max(x, lowerBound), upperBound);
    }

    public static String asRomanNumeral(int x) {
        if (x >= 4000 || x <= 0) {
            return Integer.toString(x);
        }
        String[] thousands = new String[]{"", "M", "MM", "MMM"};
        String[] hundreds = new String[]{"", "C", "CC", "CCC", "CD", "D", "DC", "DCC", "DCCC", "CM"};
        String[] tens = new String[]{"", "X", "XX", "XXX", "XL", "L", "LX", "LXX", "LXXX", "XC"};
        String[] ones = new String[]{"", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX"};
        return thousands[x / 1000] + hundreds[x / 100 % 10] + tens[x / 10 % 10] + ones[x % 10];
    }

    public static boolean flip(double chance) {
        return random.nextDouble(1.0) < chance;
    }

    public static int randomRound(double x) {
        int c;
        int f = (int)Math.floor(x);
        if (f == (c = (int)Math.ceil(x))) {
            return f;
        }
        return NumberUtil.flip(x - (double)f) ? f : c;
    }

    public static double roundToPrecision(double x, int precision) {
        double magn = Math.pow(10.0, precision);
        return (double)Math.round(x * magn) / magn;
    }

    public static double roundToPercent(double x, int precision) {
        return NumberUtil.roundToPrecision(x * 100.0, precision);
    }

    public static int getFortuneAmount(int fortuneLevel, int sickleTier, int baseAmount) {
        return NumberUtil.getFortuneAmount(fortuneLevel + sickleTier, baseAmount);
    }

    public static int getFortuneAmount(int fortuneLevel, int baseAmount) {
        return baseAmount + ThreadLocalRandom.current().nextInt(fortuneLevel, 1 + (int)Math.ceil((double)fortuneLevel * 1.5));
    }

    private NumberUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static ThreadLocalRandom getRandom() {
        return random;
    }
}

