/*
 * Decompiled with CFR 0.152.
 */
package io.github.schntgaispock.gastronomicon.core.listeners;

import com.destroystokyo.paper.event.block.BlockDestroyEvent;
import io.github.schntgaispock.gastronomicon.Gastronomicon;
import io.github.schntgaispock.gastronomicon.core.slimefun.items.seeds.AbstractSeed;
import io.github.schntgaispock.gastronomicon.core.slimefun.items.seeds.DuplicatingSeed;
import io.github.schntgaispock.gastronomicon.core.slimefun.items.seeds.FruitingSeed;
import io.github.schntgaispock.gastronomicon.core.slimefun.items.seeds.VineSeed;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Directional;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class SeedListener
implements Listener {
    @EventHandler
    public void onCropGrow(@Nonnull BlockGrowEvent e) {
        switch (e.getNewState().getType()) {
            case SUGAR_CANE: 
            case CACTUS: {
                this.assignGastroSeed(BlockStorage.check((Block)e.getBlock().getRelative(BlockFace.DOWN)), e.getNewState().getLocation());
                break;
            }
            case PUMPKIN: 
            case MELON: {
                Bukkit.getScheduler().runTaskLater((Plugin)Gastronomicon.getInstance(), () -> {
                    for (BlockFace face : new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST}) {
                        Directional stemData;
                        Block checking = e.getBlock().getRelative(face);
                        if (checking.getType() != Material.ATTACHED_MELON_STEM && checking.getType() != Material.ATTACHED_PUMPKIN_STEM || !(stemData = (Directional)checking.getBlockData()).getFacing().getOppositeFace().equals((Object)face)) continue;
                        this.assignGastroSeed(BlockStorage.check((Block)checking), e.getNewState().getLocation());
                        break;
                    }
                }, 1L);
                break;
            }
        }
    }

    @EventHandler
    public void onVineGrow(BlockSpreadEvent e) {
        switch (e.getNewState().getType()) {
            case VINE: {
                this.assignGastroSeed(BlockStorage.check((Block)e.getSource()), e.getNewState().getLocation());
                break;
            }
        }
    }

    @EventHandler
    public void onCropDestroy(BlockDestroyEvent e) {
        AbstractSeed seed = this.getGastroSeed(e.getBlock());
        if (seed != null) {
            e.setWillDrop(false);
            seed.getHarvestDrops(e.getBlock().getState(), new ItemStack(Material.AIR), false).forEach(drop -> e.getBlock().getWorld().dropItemNaturally(e.getBlock().getLocation(), drop));
            BlockStorage.clearBlockInfo((Block)e.getBlock(), (boolean)true);
        }
    }

    @EventHandler
    public void onLiquidCropDestroy(BlockFromToEvent e) {
        Block b = e.getToBlock();
        AbstractSeed seed = this.getGastroSeed(b);
        if (seed != null) {
            e.setCancelled(true);
            b.getWorld().playSound(b.getLocation(), Sound.BLOCK_CROP_BREAK, SoundCategory.BLOCKS, 1.0f, 1.0f);
            seed.getHarvestDrops(e.getBlock().getState(), new ItemStack(Material.AIR), false).forEach(drop -> e.getBlock().getWorld().dropItemNaturally(e.getBlock().getLocation(), drop));
            b.setType(Material.AIR);
            BlockStorage.clearBlockInfo((Block)b, (boolean)true);
        }
    }

    @EventHandler
    public void onVillagerCropDestroy(EntityChangeBlockEvent e) {
        if (this.getGastroSeed(e.getBlock()) != null) {
            e.setCancelled(true);
        }
    }

    private void assignGastroSeed(SlimefunItem item, @Nonnull Location l) {
        if (item == null) {
            return;
        }
        if (item instanceof DuplicatingSeed || item instanceof VineSeed) {
            BlockStorage.addBlockInfo((Location)l, (String)"id", (String)item.getId());
        } else if (item instanceof FruitingSeed) {
            FruitingSeed fgs = (FruitingSeed)item;
            BlockStorage.addBlockInfo((Location)l, (String)"id", (String)fgs.getFruitingBody().getId());
        }
    }

    private AbstractSeed getGastroSeed(Block cropBlock) {
        if (cropBlock == null) {
            return null;
        }
        switch (cropBlock.getType()) {
            case SUGAR_CANE: 
            case CACTUS: 
            case VINE: 
            case WHEAT: 
            case POTATOES: 
            case CARROTS: 
            case BEETROOTS: 
            case PUMPKIN_STEM: 
            case ATTACHED_PUMPKIN_STEM: 
            case MELON_STEM: 
            case ATTACHED_MELON_STEM: {
                break;
            }
            default: {
                return null;
            }
        }
        SlimefunItem item = BlockStorage.check((Block)cropBlock);
        if (item == null) {
            return null;
        }
        if (item instanceof AbstractSeed) {
            AbstractSeed seed = (AbstractSeed)item;
            return seed;
        }
        return null;
    }

    public static void setup() {
        Bukkit.getPluginManager().registerEvents((Listener)new SeedListener(), (Plugin)Gastronomicon.getInstance());
    }
}

