/*
 * Decompiled with CFR 0.152.
 */
package io.github.schntgaispock.gastronomicon.api.recipes.components;

import io.github.schntgaispock.gastronomicon.api.recipes.components.RecipeComponent;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;

public class GroupRecipeComponent
extends RecipeComponent<Set<ItemStack>> {
    private final NamespacedKey id;

    public GroupRecipeComponent(NamespacedKey id, Set<ItemStack> component) {
        super(component);
        this.id = id;
    }

    public GroupRecipeComponent(NamespacedKey id, ItemStack ... component) {
        this(id, Set.of(component));
    }

    public GroupRecipeComponent(NamespacedKey id, Material ... component) {
        this(id, Set.of((ItemStack[])Arrays.stream(component).map(material -> new ItemStack(material)).toArray(ItemStack[]::new)));
    }

    @Override
    public boolean matches(@Nullable ItemStack item) {
        if (item == null) {
            return false;
        }
        Iterator iterator = ((Set)this.component).iterator();
        if (iterator.hasNext()) {
            ItemStack groupItem = (ItemStack)iterator.next();
            if (groupItem instanceof SlimefunItemStack) {
                SlimefunItemStack sfStack = (SlimefunItemStack)groupItem;
                return SlimefunItem.getById((String)sfStack.getItemId()).isItem(item);
            }
            return item.isSimilar(groupItem);
        }
        return false;
    }

    @Override
    public ItemStack getDisplayItem() {
        ItemStack displayitem = ((ItemStack)((Set)this.component).stream().findFirst().get()).clone();
        List lore = displayitem.lore();
        lore.add(Component.text((String)""));
        for (ItemStack itemStack : (Set)this.component) {
            lore.add(Component.text((String)"\u00a78\u2011 \u00a7f").append(itemStack.getItemMeta().displayName()));
        }
        displayitem.lore(lore);
        return displayitem;
    }

    @Override
    public int hashCode() {
        return this.id.hashCode();
    }

    public NamespacedKey getId() {
        return this.id;
    }
}

