/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.api.universe;

import io.github.addoncommunity.galactifun.api.universe.attributes.Orbit;
import io.github.addoncommunity.galactifun.api.universe.types.UniversalType;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.bukkit.inventory.ItemStack;

public abstract class UniversalObject {
    private final List<UniversalObject> orbiters = new ArrayList<UniversalObject>();
    private final String name;
    protected final String id;
    private final ItemStack item;
    private final UniversalObject orbiting;
    private final Orbit orbit;
    protected final int orbitLevel;

    UniversalObject(@Nonnull String name, @Nonnull UniversalType type, @Nonnull Orbit orbit, @Nonnull UniversalObject orbiting, @Nonnull ItemStack baseItem) {
        this.name = ChatUtils.removeColorCodes((String)name);
        this.item = CustomItemStack.create((ItemStack)baseItem, (String)name, (String[])new String[]{"&7Type: " + type.description()});
        this.orbiting = orbiting;
        this.orbit = orbit;
        this.orbitLevel = orbiting.orbitLevel + 1;
        this.id = this.name.toLowerCase(Locale.ROOT).replace(' ', '_');
        orbiting.orbiters.add(this);
    }

    UniversalObject(String name) {
        this.name = ChatUtils.removeColorCodes((String)name);
        this.id = this.name.toLowerCase(Locale.ROOT).replace(' ', '_');
        this.item = null;
        this.orbiting = null;
        this.orbit = null;
        this.orbitLevel = 0;
    }

    public double distanceTo(@Nonnull UniversalObject other) {
        if (this.orbiting == other.orbiting) {
            double thisDist = this.orbit.currentDistance();
            double otherDist = other.orbit.currentDistance();
            double cosAngle = Math.cos(this.orbit.position() - other.orbit.position());
            return Math.sqrt(thisDist * thisDist + otherDist * otherDist - 2.0 * thisDist * otherDist * cosAngle);
        }
        if (this.orbiting == null || this.orbitLevel < other.orbitLevel) {
            return other.orbit.currentDistance() + this.distanceTo(other.orbiting);
        }
        return this.orbit.currentDistance() + this.orbiting.distanceTo(other);
    }

    @Nonnull
    public List<UniversalObject> orbiters() {
        return Collections.unmodifiableList(this.orbiters);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ItemStack item() {
        return this.item;
    }

    public UniversalObject orbiting() {
        return this.orbiting;
    }

    public Orbit orbit() {
        return this.orbit;
    }
}

