/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.base.aliens;

import io.github.addoncommunity.galactifun.api.aliens.Alien;
import io.github.addoncommunity.galactifun.base.BaseMats;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import org.bukkit.GameMode;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.projectiles.ProjectileSource;

public final class MutantCreeper
extends Alien<Creeper> {
    public MutantCreeper(String id, String name, double maxHealth, double spawnChance) {
        super(Creeper.class, id, name, maxHealth, spawnChance);
    }

    @Override
    public void onSpawn(@Nonnull Creeper spawned) {
        spawned.setPowered(true);
    }

    @Override
    public void onDeath(@Nonnull EntityDeathEvent e) {
        e.getDrops().clear();
        e.getDrops().add(CustomItemStack.create((ItemStack)BaseMats.MUNPOWDER.item(), (int)ThreadLocalRandom.current().nextInt(2)));
    }

    @Override
    public void onTarget(@Nonnull EntityTargetEvent e) {
        e.setCancelled(true);
    }

    @Override
    public void onHit(@Nonnull EntityDamageByEntityEvent e) {
        Creeper creeper = (Creeper)e.getEntity();
        Entity entity = e.getDamager();
        if (entity instanceof Player) {
            Player p = (Player)entity;
            if (p.getGameMode() != GameMode.CREATIVE) {
                creeper.setTarget((LivingEntity)((Player)e.getDamager()));
            }
        } else {
            Player p;
            Projectile pr;
            ProjectileSource projectileSource;
            entity = e.getDamager();
            if (entity instanceof Projectile && (projectileSource = (pr = (Projectile)entity).getShooter()) instanceof Player && (p = (Player)projectileSource).getGameMode() != GameMode.CREATIVE) {
                creeper.setTarget((LivingEntity)p);
            }
        }
    }
}

