/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.base.universe.saturn;

import io.github.addoncommunity.galactifun.base.universe.saturn.TitanBiome;
import it.unimi.dsi.fastutil.ints.IntIntImmutablePair;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.bukkit.block.Biome;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.WorldInfo;
import org.bukkit.util.noise.SimplexOctaveGenerator;

final class TitanBiomeProvider
extends BiomeProvider {
    private volatile SimplexOctaveGenerator heat;
    private volatile SimplexOctaveGenerator humidity;
    private final Map<IntIntPair, TitanBiome> cachedData = Collections.synchronizedMap(new LinkedHashMap<IntIntPair, TitanBiome>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<IntIntPair, TitanBiome> eldest) {
            return this.size() > 200;
        }
    });
    private final List<Biome> allBiomes = Arrays.stream(TitanBiome.values()).map(TitanBiome::biome).collect(Collectors.toList());

    TitanBiomeProvider() {
    }

    @Nonnull
    public Biome getBiome(@Nonnull WorldInfo worldInfo, int x, int y, int z) {
        return this.getBiome(worldInfo, x, z).biome();
    }

    @Nonnull
    TitanBiome getBiome(WorldInfo info, int x, int z) {
        this.init(info);
        TitanBiome cached = this.cachedData.get(new IntIntImmutablePair(x, z));
        if (cached != null) {
            return cached;
        }
        double heat = this.heat.noise((double)x, (double)z, 0.01, 0.03, true);
        double humidity = this.humidity.noise((double)x, (double)z, 0.01, 0.03, true);
        TitanBiome biome = humidity > 0.2 ? (heat > 0.2 ? TitanBiome.FOREST : (heat > 0.0 ? TitanBiome.FROZEN_FOREST : TitanBiome.DRY_ICE_FLATS)) : (humidity > -0.1 ? (heat > 0.2 ? TitanBiome.CARBON_FOREST : TitanBiome.FROZEN_CARBON_FOREST) : TitanBiome.WASTELAND);
        this.cachedData.put((IntIntPair)new IntIntImmutablePair(x, z), biome);
        return biome;
    }

    @Nonnull
    public List<Biome> getBiomes(@Nonnull WorldInfo worldInfo) {
        return this.allBiomes;
    }

    private void init(WorldInfo worldInfo) {
        if (this.heat == null) {
            this.heat = new SimplexOctaveGenerator(worldInfo.getSeed(), 8);
            this.heat.setScale(0.001);
        }
        if (this.humidity == null) {
            this.humidity = new SimplexOctaveGenerator(new Random(worldInfo.getSeed()).nextLong(), 8);
            this.humidity.setScale(0.003);
        }
    }
}

