/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.base.universe;

import io.github.addoncommunity.galactifun.api.universe.StarSystem;
import io.github.addoncommunity.galactifun.api.universe.attributes.DayCycle;
import io.github.addoncommunity.galactifun.api.universe.attributes.Gravity;
import io.github.addoncommunity.galactifun.api.universe.attributes.Orbit;
import io.github.addoncommunity.galactifun.api.universe.attributes.atmosphere.Atmosphere;
import io.github.addoncommunity.galactifun.api.universe.types.PlanetaryType;
import io.github.addoncommunity.galactifun.api.worlds.SimpleAlienWorld;
import io.github.addoncommunity.galactifun.api.worlds.populators.LakePopulator;
import io.github.addoncommunity.galactifun.api.worlds.populators.VolcanoPopulator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.inventory.ItemStack;

public final class Venus
extends SimpleAlienWorld {
    public Venus(String name, PlanetaryType type, Orbit orbit, StarSystem orbiting, ItemStack baseItem, DayCycle dayCycle, Atmosphere atmosphere, Gravity gravity) {
        super(name, type, orbit, orbiting, baseItem, dayCycle, atmosphere, gravity);
    }

    @Override
    public void getPopulators(@Nonnull List<BlockPopulator> populators) {
        populators.add(new VolcanoPopulator(117, Material.MAGMA_BLOCK, Material.LAVA));
        populators.add(new LakePopulator(75, Material.LAVA));
    }

    @Override
    @Nonnull
    protected Material generateMaterial(@Nonnull Random random, int x, int y, int z, int top) {
        if (y > 75) {
            return Material.BLACKSTONE;
        }
        if (y > 9) {
            return Material.BASALT;
        }
        if (y > 8) {
            return Material.YELLOW_TERRACOTTA;
        }
        return Material.BASALT;
    }

    @Override
    @Nonnull
    protected Biome getBiome() {
        return Biome.BASALT_DELTAS;
    }

    @Override
    protected int getAverageHeight() {
        return 100;
    }

    @Override
    protected int getMaxDeviation() {
        return 50;
    }

    @Override
    protected double getScale() {
        return 0.02;
    }

    @Override
    protected double getFrequency() {
        return 0.3;
    }
}

