/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.api.items.spacesuit;

import io.github.addoncommunity.galactifun.Galactifun;
import io.github.addoncommunity.galactifun.infinitylib.common.StackUtils;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.ProtectionType;
import io.github.thebusybiscuit.slimefun4.core.attributes.ProtectiveArmor;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.ChatColors;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

@ParametersAreNonnullByDefault
public class SpaceSuit
extends SlimefunItem
implements ProtectiveArmor {
    private static final Map<String, SpaceSuit> SPACE_SUITS = new HashMap<String, SpaceSuit>();
    private static final NamespacedKey SPACE_SUIT_KEY = Galactifun.createKey("space_suit");
    private static final NamespacedKey OXYGEN_KEY = Galactifun.createKey("oxygen");
    private static final String OXYGEN_LORE = ChatColors.color((String)"&bOxygen: &7");
    private final int maxUpgrades;
    private final int maxOxygen;

    public SpaceSuit(ItemGroup category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, int maxUpgrades, int maxOxygen) {
        super(category, item, recipeType, recipe);
        this.maxUpgrades = maxUpgrades;
        this.maxOxygen = maxOxygen;
    }

    @Nonnull
    public ProtectionType[] getProtectionTypes() {
        return new ProtectionType[]{ProtectionType.RADIATION, ProtectionType.BEES};
    }

    public void postRegister() {
        SPACE_SUITS.put(this.getId(), this);
    }

    public boolean isFullSetRequired() {
        return true;
    }

    @Nonnull
    public final NamespacedKey getArmorSetId() {
        return SPACE_SUIT_KEY;
    }

    public static int getOxygen(ItemStack item, ItemMeta meta, int change) {
        SpaceSuit suit = SPACE_SUITS.get(StackUtils.getId(meta));
        if (suit == null) {
            return 0;
        }
        int oxygen = suit.getOxygen(meta);
        int oxygenChanged = Math.max(0, Math.min(suit.maxOxygen, oxygen + change));
        if (oxygenChanged != oxygen) {
            suit.setOxygen(meta, oxygenChanged);
            item.setItemMeta(meta);
        }
        return oxygenChanged;
    }

    public final int getOxygen(ItemMeta meta) {
        return Math.min(this.maxOxygen, (Integer)meta.getPersistentDataContainer().getOrDefault(OXYGEN_KEY, PersistentDataType.INTEGER, (Object)0));
    }

    public final void setOxygen(ItemMeta meta, int oxygen) {
        oxygen = Math.max(0, Math.min(oxygen, this.maxOxygen));
        meta.getPersistentDataContainer().set(OXYGEN_KEY, PersistentDataType.INTEGER, (Object)oxygen);
        if (meta.hasLore()) {
            List lore = meta.getLore();
            for (int i = 0; i < lore.size(); ++i) {
                if (!((String)lore.get(i)).startsWith(OXYGEN_LORE)) continue;
                lore.set(i, SpaceSuit.oxygenLore(oxygen, this.maxOxygen));
            }
            meta.setLore(lore);
        }
    }

    public static String oxygenLore(int amount, int max) {
        return OXYGEN_LORE + amount + " / " + max;
    }

    public int maxUpgrades() {
        return this.maxUpgrades;
    }

    public int maxOxygen() {
        return this.maxOxygen;
    }
}

