/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.api.aliens.behaviors;

import com.destroystokyo.paper.entity.ai.GoalType;
import io.github.addoncommunity.galactifun.Galactifun;
import io.github.addoncommunity.galactifun.api.aliens.behaviors.AlienBehavior;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Mob;

public final class LookGoal<T extends Mob>
extends AlienBehavior<T> {
    private int time = 0;

    public LookGoal(@Nonnull Class<T> entityClass, @Nonnull T mob) {
        super(entityClass, Galactifun.createKey("look"), (Mob)mob);
    }

    public boolean shouldActivate() {
        return true;
    }

    public void start() {
        this.time = 80;
    }

    public void stop() {
        this.time = 0;
    }

    public void tick() {
        if (this.time >= 80) {
            this.time = 0;
            List nearby = this.mob.getNearbyEntities(20.0, 5.0, 10.0);
            if (nearby.isEmpty()) {
                return;
            }
            this.mob.lookAt((Entity)nearby.get(ThreadLocalRandom.current().nextInt(nearby.size())), 1.0f, 90.0f);
        } else {
            --this.time;
        }
    }

    @Override
    @Nonnull
    public EnumSet<GoalType> getTypes() {
        return EnumSet.of(GoalType.MOVE, GoalType.LOOK, GoalType.JUMP);
    }
}

