/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.api.universe.attributes.atmosphere;

import io.github.addoncommunity.galactifun.Galactifun;
import io.github.addoncommunity.galactifun.api.universe.PlanetaryObject;
import io.github.addoncommunity.galactifun.base.BaseItems;
import io.github.addoncommunity.galactifun.base.BaseMats;
import io.github.addoncommunity.galactifun.base.BaseUniverse;
import io.github.addoncommunity.galactifun.base.items.DiamondAnvil;
import io.github.addoncommunity.galactifun.core.CoreItemGroup;
import io.github.addoncommunity.galactifun.core.CoreRecipeType;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.items.electric.generators.CombustionGenerator;
import io.github.thebusybiscuit.slimefun4.implementation.items.electric.machines.Freezer;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineFuel;
import org.bukkit.inventory.ItemStack;

public final class Gas
extends Enum<Gas> {
    public static final /* enum */ Gas OXYGEN;
    public static final /* enum */ Gas NITROGEN;
    public static final /* enum */ Gas CARBON_DIOXIDE;
    public static final /* enum */ Gas WATER;
    public static final /* enum */ Gas HELIUM;
    public static final /* enum */ Gas ARGON;
    public static final /* enum */ Gas METHANE;
    public static final /* enum */ Gas HYDROCARBONS;
    public static final /* enum */ Gas HYDROGEN;
    public static final /* enum */ Gas AMMONIA;
    public static final /* enum */ Gas OTHER;
    private final SlimefunItemStack item;
    private final SlimefunItem slimefunItem;
    private static final /* synthetic */ Gas[] $VALUES;

    public static Gas[] values() {
        return (Gas[])$VALUES.clone();
    }

    public static Gas valueOf(String name) {
        return Enum.valueOf(Gas.class, name);
    }

    private Gas(String texture) {
        this(texture, CoreRecipeType.ATMOSPHERIC_HARVESTER);
    }

    @ParametersAreNonnullByDefault
    private Gas(String texture, RecipeType recipeType) {
        this(texture, recipeType, new ItemStack[9]);
    }

    @ParametersAreNonnullByDefault
    private Gas(String texture, RecipeType recipeType, ItemStack[] recipe) {
        this.item = new SlimefunItemStack("ATMOSPHERIC_GAS_" + this.name(), SlimefunUtils.getCustomHead((String)texture), "&f" + ChatUtils.humanize((String)this.name()) + " Gas Canister", new String[]{"", "&f&oTexture by Sefiraat"});
        this.slimefunItem = new SlimefunItem(CoreItemGroup.ITEMS, this.item, recipeType, recipe);
        this.slimefunItem.register((SlimefunAddon)Galactifun.instance());
    }

    private Gas() {
        this.item = null;
        this.slimefunItem = null;
    }

    @Nonnull
    public String toString() {
        return ChatUtils.humanize((String)this.name());
    }

    public static void setRecipes() {
        Gas.setRecipe(OXYGEN, BaseUniverse.EARTH);
        Gas.setRecipe(NITROGEN, BaseUniverse.EARTH);
        Gas.setRecipe(CARBON_DIOXIDE, BaseUniverse.EARTH);
        Gas.setRecipe(WATER, BaseUniverse.EARTH);
        Gas.setRecipe(HELIUM, BaseUniverse.JUPITER);
        Gas.setRecipe(ARGON, BaseUniverse.EARTH);
        Gas.setRecipe(METHANE, BaseUniverse.SATURN);
        Gas.setRecipe(HYDROCARBONS, BaseUniverse.TITAN);
        Gas.setRecipe(HYDROGEN, BaseUniverse.JUPITER);
    }

    @ParametersAreNonnullByDefault
    private static void setRecipe(Gas gas, PlanetaryObject planetaryObject) {
        gas.slimefunItem().setRecipe(new ItemStack[]{null, null, null, null, planetaryObject.item(), null, null, null, null});
    }

    public SlimefunItemStack item() {
        return this.item;
    }

    public SlimefunItem slimefunItem() {
        return this.slimefunItem;
    }

    private static /* synthetic */ Gas[] $values() {
        return new Gas[]{OXYGEN, NITROGEN, CARBON_DIOXIDE, WATER, HELIUM, ARGON, METHANE, HYDROCARBONS, HYDROGEN, AMMONIA, OTHER};
    }

    static {
        Freezer freezer;
        OXYGEN = new Gas("5b3ad76aadb80ecf4b4cdbe76b8704b0f2dc090b49b65c36d87ed879f1065ef2");
        NITROGEN = new Gas("5b3ad76aadb80ecf4b4cdbe76b8704b0f2dc090b49b65c36d87ed879f1065ef2");
        CARBON_DIOXIDE = new Gas("5b3ad76aadb80ecf4b4cdbe76b8704b0f2dc090b49b65c36d87ed879f1065ef2");
        WATER = new Gas("5b3ad76aadb80ecf4b4cdbe76b8704b0f2dc090b49b65c36d87ed879f1065ef2");
        HELIUM = new Gas("93dfa904fe3d0306666a573c22eec1dd0a8051e32a38ea2d19c4b5867e232a49");
        ARGON = new Gas("ea005531b6167a86fb09d6c0f3db60f2650162d0656c2908d07b377111d8f2a2");
        METHANE = new Gas("ea005531b6167a86fb09d6c0f3db60f2650162d0656c2908d07b377111d8f2a2");
        HYDROCARBONS = new Gas("725691372e0734bfb57bb03690490661a83f053a3488860df3436ce1caa24d11");
        HYDROGEN = new Gas("725691372e0734bfb57bb03690490661a83f053a3488860df3436ce1caa24d11");
        AMMONIA = new Gas("c7a1ece691ad28d17bbbcecb22270c85e1c9581485806264c676de67c272e2d0", CoreRecipeType.CHEMICAL_REACTOR, new ItemStack[]{Gas.NITROGEN.item, Gas.HYDROGEN.item.asQuantity(3), null, null, null, null, null, null, null});
        OTHER = new Gas();
        $VALUES = Gas.$values();
        SlimefunItem slimefunItem = SlimefunItems.FREEZER_2.getItem();
        if (slimefunItem instanceof Freezer) {
            freezer = (Freezer)slimefunItem;
            freezer.registerRecipe(10, (ItemStack)NITROGEN.item(), SlimefunItems.REACTOR_COOLANT_CELL.asQuantity(4));
        }
        if ((slimefunItem = SlimefunItems.FREEZER_3.getItem()) instanceof Freezer) {
            freezer = (Freezer)slimefunItem;
            freezer.registerRecipe(7, (ItemStack)NITROGEN.item(), SlimefunItems.REACTOR_COOLANT_CELL.asQuantity(4));
        }
        if ((slimefunItem = SlimefunItems.COMBUSTION_REACTOR.getItem()) instanceof CombustionGenerator) {
            CombustionGenerator generator = (CombustionGenerator)slimefunItem;
            generator.registerFuel(new MachineFuel(15, (ItemStack)HYDROGEN.item()));
            generator.registerFuel(new MachineFuel(30, (ItemStack)HYDROCARBONS.item()));
            generator.registerFuel(new MachineFuel(70, (ItemStack)AMMONIA.item()));
            generator.registerFuel(new MachineFuel(200, (ItemStack)METHANE.item()));
        }
        if ((slimefunItem = BaseItems.DIAMOND_ANVIL.getItem()) instanceof DiamondAnvil) {
            DiamondAnvil anvil = (DiamondAnvil)slimefunItem;
            anvil.registerRecipe(10, HYDROGEN.item().asQuantity(4), (ItemStack)HELIUM.item());
            anvil.registerRecipe(10, HELIUM.item().asQuantity(4), (ItemStack)BaseMats.FUSION_PELLET);
        }
    }
}

