/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.api.worlds;

import io.github.addoncommunity.galactifun.api.universe.PlanetaryObject;
import io.github.addoncommunity.galactifun.api.universe.StarSystem;
import io.github.addoncommunity.galactifun.api.universe.attributes.DayCycle;
import io.github.addoncommunity.galactifun.api.universe.attributes.Gravity;
import io.github.addoncommunity.galactifun.api.universe.attributes.Orbit;
import io.github.addoncommunity.galactifun.api.universe.attributes.atmosphere.Atmosphere;
import io.github.addoncommunity.galactifun.api.universe.types.PlanetaryType;
import io.github.addoncommunity.galactifun.api.worlds.AlienWorld;
import java.util.Random;
import javax.annotation.Nonnull;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.noise.SimplexOctaveGenerator;

public abstract class SimpleAlienWorld
extends AlienWorld {
    private SimplexOctaveGenerator generator;

    public SimpleAlienWorld(String name, PlanetaryType type, Orbit orbit, StarSystem orbiting, ItemStack baseItem, DayCycle dayCycle, Atmosphere atmosphere, Gravity gravity) {
        super(name, type, orbit, orbiting, baseItem, dayCycle, atmosphere, gravity);
    }

    public SimpleAlienWorld(String name, PlanetaryType type, Orbit orbit, PlanetaryObject orbiting, ItemStack baseItem, DayCycle dayCycle, Atmosphere atmosphere, Gravity gravity) {
        super(name, type, orbit, orbiting, baseItem, dayCycle, atmosphere, gravity);
    }

    @Override
    protected final void generateChunk(@Nonnull ChunkGenerator.ChunkData chunk, @Nonnull ChunkGenerator.BiomeGrid grid, @Nonnull Random random, @Nonnull World world, int chunkX, int chunkZ) {
        if (this.generator == null) {
            this.generator = new SimplexOctaveGenerator(world, this.getOctaves());
            this.generator.setScale(this.getScale());
        }
        int x = 0;
        int realX = chunkX << 4;
        while (x < 16) {
            int z = 0;
            int realZ = chunkZ << 4;
            while (z < 16) {
                double temp;
                double noise = this.generator.noise((double)realX, (double)realZ, this.getFrequency(), this.getAmplitude(), true);
                if (this.smoothenTerrain()) {
                    noise *= noise;
                }
                int height = (temp = (double)this.getAverageHeight() + (double)this.getMaxDeviation() * noise) >= 0.0 ? (int)temp : (int)temp - 1;
                chunk.setBlock(x, 0, z, Material.BEDROCK);
                grid.setBiome(x, 0, z, this.getBiome());
                int y = 1;
                while (y <= height) {
                    chunk.setBlock(x, y++, z, this.generateMaterial(random, x, y, z, height));
                    grid.setBiome(x, y, z, this.getBiome());
                }
                while (y < 256) {
                    grid.setBiome(x, y++, z, this.getBiome());
                }
                this.generateMore(chunk, this.generator, random, realX, realZ, x, z, height);
                ++z;
                ++realZ;
            }
            ++x;
            ++realX;
        }
    }

    @Nonnull
    protected abstract Material generateMaterial(@Nonnull Random var1, int var2, int var3, int var4, int var5);

    @Nonnull
    protected abstract Biome getBiome();

    protected void generateMore(@Nonnull ChunkGenerator.ChunkData chunk, @Nonnull SimplexOctaveGenerator generator, @Nonnull Random random, int realX, int realZ, int x, int z, int height) {
    }

    protected int getAverageHeight() {
        return 75;
    }

    protected int getMaxDeviation() {
        return 35;
    }

    protected int getOctaves() {
        return 8;
    }

    protected double getScale() {
        return 0.01;
    }

    protected double getAmplitude() {
        return 0.5;
    }

    protected double getFrequency() {
        return 0.5;
    }

    protected boolean smoothenTerrain() {
        return false;
    }
}

