/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.api.universe.attributes.atmosphere;

import io.github.addoncommunity.galactifun.Galactifun;
import io.github.addoncommunity.galactifun.api.items.spacesuit.SpaceSuitProfile;
import io.github.addoncommunity.galactifun.api.items.spacesuit.SpaceSuitStat;
import io.github.addoncommunity.galactifun.api.universe.attributes.atmosphere.AtmosphereBuilder;
import io.github.addoncommunity.galactifun.api.universe.attributes.atmosphere.AtmosphericEffect;
import io.github.addoncommunity.galactifun.api.universe.attributes.atmosphere.Gas;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.GameRule;
import org.bukkit.World;
import org.bukkit.entity.Player;

@ParametersAreNonnullByDefault
public final class Atmosphere {
    private static final double EARTH_CARBON_DIOXIDE = 0.0415;
    public static final Atmosphere NONE = new AtmosphereBuilder().setEnd().setPressure(0.0).addEffect(AtmosphericEffect.COLD, 3).build();
    public static final Atmosphere EARTH_LIKE = new AtmosphereBuilder().enableWeather().add(Gas.NITROGEN, 77.084).add(Gas.OXYGEN, 20.946).add(Gas.WATER, 0.95).add(Gas.ARGON, 0.934).add(Gas.CARBON_DIOXIDE, 0.0415).build();
    private final boolean weatherEnabled;
    private final boolean storming;
    private final boolean thundering;
    private final boolean flammable;
    private final int growthAttempts;
    private final double pressure;
    private final World.Environment environment;
    private final Map<AtmosphericEffect, Integer> effects;
    private final Map<Gas, Double> composition = new EnumMap<Gas, Double>(Gas.class);

    Atmosphere(boolean weatherEnabled, boolean storming, boolean thundering, @Nonnull World.Environment environment, @Nonnull Map<Gas, Double> composition, double pressure, @Nonnull Map<AtmosphericEffect, Integer> effects) {
        this.weatherEnabled = weatherEnabled;
        this.environment = environment;
        this.thundering = thundering;
        this.storming = storming;
        this.pressure = pressure;
        this.effects = effects;
        this.composition.putAll(composition);
        this.flammable = composition.getOrDefault((Object)Gas.OXYGEN, 0.0) > 5.0;
        this.growthAttempts = (int)(this.pressurizedCompositionOf(Gas.CARBON_DIOXIDE) / 0.0415);
    }

    public void applyEffects(@Nonnull World world) {
        world.setGameRule(GameRule.DO_WEATHER_CYCLE, (Object)this.weatherEnabled);
        world.setStorm(this.storming);
        if (this.storming) {
            world.setWeatherDuration(Integer.MAX_VALUE);
        }
        world.setThundering(this.thundering);
        if (this.thundering) {
            world.setThunderDuration(Integer.MAX_VALUE);
        }
        world.setGameRule(GameRule.DO_FIRE_TICK, (Object)this.flammable);
    }

    public void applyEffects(@Nonnull Player player) {
        for (Map.Entry<AtmosphericEffect, Integer> entry : this.effects.entrySet()) {
            AtmosphericEffect effect = entry.getKey();
            int protection = Galactifun.protectionManager().protectionAt(player.getLocation(), effect);
            SpaceSuitStat stat = effect.stat();
            if (stat != null) {
                protection += SpaceSuitProfile.get(player).getStat(stat);
            }
            effect.apply(player, entry.getValue() - protection);
        }
    }

    public double compositionOf(@Nonnull Gas gas) {
        return this.composition.getOrDefault((Object)gas, 0.0);
    }

    public double pressurizedCompositionOf(@Nonnull Gas gas) {
        return this.compositionOf(gas) * this.pressure;
    }

    public boolean requiresOxygenTank() {
        return this.compositionOf(Gas.OXYGEN) < 16.0;
    }

    public AtmosphereBuilder toBuilder() {
        AtmosphereBuilder builder = new AtmosphereBuilder();
        switch (this.environment) {
            case NETHER: {
                builder.setNether();
                break;
            }
            case THE_END: {
                builder.setEnd();
            }
        }
        for (Map.Entry<AtmosphericEffect, Integer> entry : this.effects.entrySet()) {
            builder.addEffect(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Object, Number> entry : this.composition.entrySet()) {
            builder.add((Gas)((Object)entry.getKey()), (Double)entry.getValue());
        }
        if (this.storming) {
            builder.addStorm();
        }
        if (this.thundering) {
            builder.addThunder();
        }
        if (this.weatherEnabled) {
            builder.enableWeather();
        }
        return builder;
    }

    public boolean weatherEnabled() {
        return this.weatherEnabled;
    }

    public boolean storming() {
        return this.storming;
    }

    public boolean thundering() {
        return this.thundering;
    }

    public boolean flammable() {
        return this.flammable;
    }

    public int growthAttempts() {
        return this.growthAttempts;
    }

    public double pressure() {
        return this.pressure;
    }

    public World.Environment environment() {
        return this.environment;
    }

    public Map<AtmosphericEffect, Integer> effects() {
        return this.effects;
    }

    public Map<Gas, Double> composition() {
        return this.composition;
    }
}

