/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.api.aliens;

import io.github.addoncommunity.galactifun.core.managers.AlienManager;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.ChatColors;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.Validate;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntitySpellCastEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.persistence.PersistentDataHolder;

public class Alien<T extends Mob> {
    private final Class<T> clazz;
    private final String id;
    private final String name;
    private final double spawnChance;
    private final double maxHealth;
    private AlienManager alienManager;

    @ParametersAreNonnullByDefault
    public Alien(@Nonnull Class<T> clazz, @Nonnull String id, @Nonnull String name, double maxHealth, double spawnChance) {
        Validate.isTrue((maxHealth > 0.0 ? 1 : 0) != 0);
        Validate.isTrue((spawnChance > 0.0 && spawnChance <= 100.0 ? 1 : 0) != 0);
        this.clazz = clazz;
        this.id = id;
        this.name = ChatColors.color((String)name);
        this.maxHealth = maxHealth;
        this.spawnChance = spawnChance;
    }

    @Nonnull
    public final T spawn(@Nonnull Location loc, @Nonnull World world) {
        Mob mob = (Mob)world.spawn(loc, this.clazz);
        PersistentDataAPI.setString((PersistentDataHolder)mob, (NamespacedKey)this.alienManager.key(), (String)this.id);
        this.alienManager.addAlien(mob.getUniqueId());
        Objects.requireNonNull(mob.getAttribute(Attribute.GENERIC_MAX_HEALTH)).setBaseValue(this.maxHealth);
        mob.setHealth(this.maxHealth);
        mob.setCustomName(this.name);
        mob.setCustomNameVisible(true);
        mob.setRemoveWhenFarAway(true);
        this.onSpawn(mob);
        return (T)mob;
    }

    public final void register(@Nonnull AlienManager alienManager) {
        if (this.isRegistered()) {
            throw new IllegalStateException("Alien already registered!");
        }
        this.alienManager = alienManager;
        alienManager.register(this);
    }

    public final boolean isRegistered() {
        return this.alienManager != null;
    }

    public final int attemptSpawn(Random rand, World world) {
        int spawned = 0;
        for (Chunk chunk : world.getLoadedChunks()) {
            int z;
            int x;
            Block b;
            if (rand.nextDouble() * 100.0 > this.spawnChance || !(b = world.getHighestBlockAt(x = rand.nextInt(16) + (chunk.getX() << 4), z = rand.nextInt(16) + (chunk.getZ() << 4)).getRelative(0, 1, 0)).getType().isAir() || !this.canSpawnInLightLevel(b.getLightLevel())) continue;
            this.spawn(b.getLocation().add(0.0, this.getSpawnHeightOffset(), 0.0), world);
            ++spawned;
        }
        return spawned;
    }

    public final void onEntityTick(@Nonnull LivingEntity mob) {
        this.onTick((Mob)this.clazz.cast(mob));
    }

    public void onSpawn(@Nonnull T spawned) {
    }

    public void onUniqueTick() {
    }

    public void onTick(@Nonnull T mob) {
    }

    public void onInteract(@Nonnull PlayerInteractEntityEvent e) {
    }

    public void onHit(@Nonnull EntityDamageByEntityEvent e) {
    }

    public void onAttack(@Nonnull EntityDamageByEntityEvent e) {
    }

    public void onTarget(@Nonnull EntityTargetEvent e) {
    }

    public void onDeath(@Nonnull EntityDeathEvent e) {
    }

    public void onCastSpell(@Nonnull EntitySpellCastEvent e) {
    }

    public void onDamage(@Nonnull EntityDamageEvent e) {
    }

    public void onShoot(@Nonnull ProjectileLaunchEvent e) {
    }

    protected boolean canSpawnInLightLevel(int lightLevel) {
        return lightLevel <= 7;
    }

    protected double getSpawnHeightOffset() {
        return 0.0;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public Class<T> clazz() {
        return this.clazz;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public double spawnChance() {
        return this.spawnChance;
    }

    public double maxHealth() {
        return this.maxHealth;
    }

    public AlienManager alienManager() {
        return this.alienManager;
    }
}

