/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.core.commands;

import io.github.addoncommunity.galactifun.Galactifun;
import io.github.addoncommunity.galactifun.infinitylib.commands.SubCommand;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class AlienRemoveCommand
extends SubCommand {
    public AlienRemoveCommand() {
        super("remove", "Removes an alien based on uuid", true);
    }

    @Override
    public void execute(@Nonnull CommandSender commandSender, @Nonnull String[] strings) {
        Player p;
        block9: {
            block8: {
                if (!(commandSender instanceof Player)) break block8;
                p = (Player)commandSender;
                if (strings.length == 1) break block9;
            }
            return;
        }
        if (strings[0].equalsIgnoreCase("all")) {
            for (UUID uuid : new HashSet<UUID>(Galactifun.alienManager().alienIds())) {
                Entity entity = Bukkit.getEntity((UUID)uuid);
                if (entity == null || Galactifun.alienManager().getAlien(entity) == null) continue;
                entity.remove();
            }
            return;
        }
        try {
            UUID uuid = UUID.fromString(strings[0]);
            Entity entity = Bukkit.getEntity((UUID)uuid);
            if (entity == null || Galactifun.alienManager().getAlien(entity) == null) {
                throw new IllegalArgumentException();
            }
            entity.remove();
        }
        catch (IllegalArgumentException ignored) {
            p.sendMessage(String.valueOf(ChatColor.RED) + "Invalid UUID!");
        }
    }

    @Override
    public void complete(@Nonnull CommandSender commandSender, @Nonnull String[] strings, @Nonnull List<String> ids) {
        if (strings.length == 1) {
            ids.add("all");
            for (UUID uuid : new HashSet<UUID>(Galactifun.alienManager().alienIds())) {
                ids.add(uuid.toString());
            }
        }
    }
}

