/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun;

import io.github.addoncommunity.galactifun.api.worlds.AlienWorld;
import io.github.addoncommunity.galactifun.api.worlds.PlanetaryWorld;
import io.github.addoncommunity.galactifun.base.BaseAlien;
import io.github.addoncommunity.galactifun.base.BaseItems;
import io.github.addoncommunity.galactifun.base.BaseMats;
import io.github.addoncommunity.galactifun.base.BaseUniverse;
import io.github.addoncommunity.galactifun.core.CoreItemGroup;
import io.github.addoncommunity.galactifun.core.commands.AlienRemoveCommand;
import io.github.addoncommunity.galactifun.core.commands.AlienSpawnCommand;
import io.github.addoncommunity.galactifun.core.commands.EffectsCommand;
import io.github.addoncommunity.galactifun.core.commands.GalactiportCommand;
import io.github.addoncommunity.galactifun.core.commands.SealedCommand;
import io.github.addoncommunity.galactifun.core.commands.StructureCommand;
import io.github.addoncommunity.galactifun.core.managers.AlienManager;
import io.github.addoncommunity.galactifun.core.managers.ProtectionManager;
import io.github.addoncommunity.galactifun.core.managers.WorldManager;
import io.github.addoncommunity.galactifun.infinitylib.common.Scheduler;
import io.github.addoncommunity.galactifun.infinitylib.core.AbstractAddon;
import io.github.addoncommunity.galactifun.infinitylib.metrics.bukkit.Metrics;
import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.updater.BlobBuildUpdater;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import java.io.File;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPluginLoader;

public final class Galactifun
extends AbstractAddon {
    private static Galactifun instance;
    private boolean isTest = false;
    private AlienManager alienManager;
    private WorldManager worldManager;
    private ProtectionManager protectionManager;
    private boolean shouldDisable = false;

    public Galactifun() {
        super("Slimefun-Addon-Community", "Galactifun", "master", "auto-update");
    }

    public Galactifun(JavaPluginLoader loader, PluginDescriptionFile description, File dataFolder, File file) {
        super(loader, description, dataFolder, file, "Slimefun-Addon-Community", "Galactifun", "master", "auto-update");
        this.isTest = true;
    }

    public static AlienManager alienManager() {
        return Galactifun.instance.alienManager;
    }

    public static WorldManager worldManager() {
        return Galactifun.instance.worldManager;
    }

    public static ProtectionManager protectionManager() {
        return Galactifun.instance.protectionManager;
    }

    @Override
    protected void enable() {
        instance = this;
        if (!this.isTest) {
            if (!PaperLib.isPaper()) {
                Galactifun.log(Level.SEVERE, "Galactifun only supports Paper and its forks (i.e. Airplane and Purpur)");
                Galactifun.log(Level.SEVERE, "Please use Paper or a fork of Paper");
                this.shouldDisable = true;
            }
            if (Slimefun.getMinecraftVersion().isBefore(MinecraftVersion.MINECRAFT_1_17)) {
                Galactifun.log(Level.SEVERE, "Galactifun only supports Minecraft 1.17 and above");
                Galactifun.log(Level.SEVERE, "Please use Minecraft 1.17 or above");
                this.shouldDisable = true;
            }
            if (Bukkit.getPluginManager().isPluginEnabled("ClayTech")) {
                Galactifun.log(Level.SEVERE, "Galactifun will not work properly with ClayTech");
                Galactifun.log(Level.SEVERE, "Please disable ClayTech");
                this.shouldDisable = true;
            }
            if (Bukkit.getPluginManager().isPluginEnabled("ChatColor2")) {
                Galactifun.log(Level.SEVERE, "Galactifun will not work properly with ChatColor2");
                Galactifun.log(Level.SEVERE, "Please disable ChatColor2");
                this.shouldDisable = true;
            }
            if (this.shouldDisable) {
                Bukkit.getPluginManager().disablePlugin((Plugin)this);
                return;
            }
        }
        new Metrics(this, 11613);
        if (!this.isTest && this.getConfig().getBoolean("auto-update") && !this.getPluginVersion().contains("MODIFIED")) {
            new BlobBuildUpdater((Plugin)this, this.getFile(), "Galactifun").start();
        }
        this.alienManager = new AlienManager(this);
        this.worldManager = new WorldManager(this);
        this.protectionManager = new ProtectionManager();
        BaseAlien.setup(this.alienManager);
        if (!this.isTest) {
            BaseUniverse.setup(this);
        }
        CoreItemGroup.setup(this);
        BaseMats.setup();
        BaseItems.setup(this);
        Scheduler.run(() -> Galactifun.log(Level.INFO, "################# Galactifun " + this.getPluginVersion() + " #################", "", "Galactifun is open source, you can contribute or report bugs at: ", this.getBugTrackerURL(), "Join the Slimefun Addon Community Discord: discord.gg/SqD3gg5SAU", "", "###################################################"));
        this.getAddonCommand().addSub(new GalactiportCommand()).addSub(new AlienSpawnCommand()).addSub(new AlienRemoveCommand()).addSub(new StructureCommand(this)).addSub(new SealedCommand()).addSub(new EffectsCommand());
    }

    @Override
    protected void disable() {
        if (this.shouldDisable) {
            return;
        }
        this.alienManager.onDisable();
        instance = null;
    }

    @Override
    public void load() {
        if (!this.isTest) {
            Bukkit.spigot().getConfig().set("world-settings.default.verbose", (Object)false);
        }
    }

    @Nullable
    public ChunkGenerator getDefaultWorldGenerator(@Nonnull String worldName, @Nullable String id) {
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            return null;
        }
        PlanetaryWorld planetaryWorld = this.worldManager.getWorld(world);
        if (planetaryWorld instanceof AlienWorld) {
            return planetaryWorld.world().getGenerator();
        }
        return null;
    }

    public static Galactifun instance() {
        return instance;
    }
}

