/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.base.items.knowledge;

import io.github.addoncommunity.galactifun.Galactifun;
import io.github.addoncommunity.galactifun.api.universe.attributes.atmosphere.AtmosphericEffect;
import io.github.addoncommunity.galactifun.api.universe.attributes.atmosphere.Gas;
import io.github.addoncommunity.galactifun.api.worlds.PlanetaryWorld;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataHolder;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum KnowledgeLevel {
    NONE{

        @Override
        public void addLore(@Nonnull List<Component> lore, @Nonnull PlanetaryWorld world) {
        }
    }
    ,
    BASIC{

        @Override
        public void addLore(@Nonnull List<Component> lore, @Nonnull PlanetaryWorld world) {
            if (!world.atmosphere().effects().isEmpty()) {
                lore.add((Component)Component.empty());
                lore.add(Component.text((String)"Effects:").color((TextColor)NamedTextColor.GRAY));
                for (Map.Entry<AtmosphericEffect, Integer> effect : world.atmosphere().effects().entrySet()) {
                    lore.add(((TextComponent)((TextComponent)Component.text((String)effect.getKey().toString()).color((TextColor)NamedTextColor.RED)).append((Component)Component.text((String)": "))).append((Component)Component.text((int)effect.getValue())));
                }
            }
            lore.add((Component)Component.empty());
            lore.add(((TextComponent)Component.text((String)"Day/Night Cycle: ").color((TextColor)NamedTextColor.GRAY)).append((Component)Component.text((String)world.dayCycle().description())));
            lore.add((Component)Component.empty());
            lore.add(((TextComponent)((TextComponent)Component.text((String)"Atmospheric Pressure: ").color((TextColor)NamedTextColor.GRAY)).append((Component)Component.text((String)formatter.format(world.atmosphere().pressure())))).append((Component)Component.text((String)" atm")));
        }
    }
    ,
    ADVANCED{

        @Override
        public void addLore(@Nonnull List<Component> lore, @Nonnull PlanetaryWorld world) {
            BASIC.addLore(lore, world);
            if (Math.abs(world.atmosphere().pressure()) > 1.0E-6) {
                lore.add((Component)Component.empty());
                lore.add(Component.text((String)"Atmospheric Composition:").color((TextColor)NamedTextColor.GRAY));
                LinkedHashMap<Gas, Double> gases = new LinkedHashMap<Gas, Double>(world.atmosphere().composition());
                KnowledgeLevel.orderByValue(gases, Comparator.reverseOrder());
                for (Map.Entry<Gas, Double> gas : gases.entrySet()) {
                    lore.add(((TextComponent)((TextComponent)((TextComponent)Component.text((String)ChatUtils.humanize((String)gas.getKey().name())).color((TextColor)NamedTextColor.GREEN)).append((Component)Component.text((String)": "))).append((Component)Component.text((String)formatter.format(gas.getValue())))).append((Component)Component.text((char)'%')));
                }
            }
            lore.add((Component)Component.empty());
            lore.add(((TextComponent)((TextComponent)Component.text((String)"Gravity: ").color((TextColor)NamedTextColor.GRAY)).append((Component)Component.text((String)formatter.format(world.gravity().percent())))).append((Component)Component.text((String)" g")));
        }
    };

    private static final DecimalFormat formatter;

    private static <K, V> void orderByValue(LinkedHashMap<K, V> m, Comparator<? super V> c) {
        ArrayList entries = new ArrayList(m.entrySet());
        entries.sort((lhs, rhs) -> c.compare((Object)lhs.getValue(), (Object)rhs.getValue()));
        m.clear();
        for (Map.Entry entry : entries) {
            m.put(entry.getKey(), entry.getValue());
        }
    }

    public static KnowledgeLevel get(@Nonnull Player p, @Nonnull PlanetaryWorld world) {
        return KnowledgeLevel.valueOf(PersistentDataAPI.getString((PersistentDataHolder)world.worldStorage(), (NamespacedKey)Galactifun.createKey("player_knowledge_" + p.getUniqueId()), (String)NONE.name()));
    }

    public abstract void addLore(@Nonnull List<Component> var1, @Nonnull PlanetaryWorld var2);

    public void set(@Nonnull Player p, @Nonnull PlanetaryWorld world) {
        PersistentDataAPI.setString((PersistentDataHolder)world.worldStorage(), (NamespacedKey)Galactifun.createKey("player_knowledge_" + p.getUniqueId()), (String)this.name());
    }

    static {
        formatter = new DecimalFormat("0.###");
    }
}

