/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.util;

import com.google.common.collect.Iterables;
import io.github.addoncommunity.galactifun.Galactifun;
import io.github.addoncommunity.galactifun.util.BlockPositionsDataType;
import io.github.thebusybiscuit.slimefun4.libraries.dough.blocks.BlockPosition;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.bukkit.Chunk;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public final class ChunkStorage {
    private static final BlockPositionsDataType DATA_TYPE = new BlockPositionsDataType();

    private ChunkStorage() {
    }

    public static Set<BlockPosition> getTagged(@Nonnull Chunk chunk, @Nonnull String tag) {
        NamespacedKey key = new NamespacedKey((Plugin)Galactifun.instance(), tag);
        ChunkStorage.DATA_TYPE.currentWorld = chunk.getWorld();
        return (Set)chunk.getPersistentDataContainer().getOrDefault(key, (PersistentDataType)DATA_TYPE, new HashSet());
    }

    public static void setTagged(@Nonnull Collection<BlockPosition> positions, @Nonnull String tag) {
        NamespacedKey key = new NamespacedKey((Plugin)Galactifun.instance(), tag);
        if (positions.isEmpty()) {
            return;
        }
        HashSet<BlockPosition> toTag = new HashSet<BlockPosition>(positions);
        BlockPosition first = (BlockPosition)Iterables.get(positions, (int)0);
        Chunk chunk = first.getChunk();
        toTag.removeIf(pos -> pos.getChunk() != chunk);
        ChunkStorage.DATA_TYPE.currentWorld = chunk.getWorld();
        chunk.getPersistentDataContainer().set(key, (PersistentDataType)DATA_TYPE, toTag);
    }

    public static boolean isTagged(@Nonnull BlockPosition pos, @Nonnull String tag) {
        return ChunkStorage.getTagged(pos.getChunk(), tag).contains(pos);
    }

    public static boolean isTagged(@Nonnull Block block, @Nonnull String tag) {
        return ChunkStorage.isTagged(new BlockPosition(block), tag);
    }

    public static void tag(@Nonnull BlockPosition pos, @Nonnull String tag) {
        Set<BlockPosition> tagged = ChunkStorage.getTagged(pos.getChunk(), tag);
        tagged.add(pos);
        ChunkStorage.setTagged(tagged, tag);
    }

    public static void tag(@Nonnull Block block, @Nonnull String tag) {
        ChunkStorage.tag(new BlockPosition(block), tag);
    }

    public static boolean untag(@Nonnull BlockPosition pos, @Nonnull String tag) {
        Set<BlockPosition> tagged = ChunkStorage.getTagged(pos.getChunk(), tag);
        if (tagged.remove(pos)) {
            ChunkStorage.setTagged(tagged, tag);
            return true;
        }
        return false;
    }

    public static boolean untag(@Nonnull Block block, @Nonnull String tag) {
        return ChunkStorage.untag(new BlockPosition(block), tag);
    }
}

