/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.api.items;

import io.github.addoncommunity.galactifun.api.worlds.PlanetaryWorld;
import io.github.addoncommunity.galactifun.core.CoreItemGroup;
import io.github.addoncommunity.galactifun.core.CoreRecipeType;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.collections.RandomizedSet;
import it.unimi.dsi.fastutil.ints.IntIntImmutablePair;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.bukkit.inventory.ItemStack;

public class Relic
extends SlimefunItem {
    private final RandomizedSet<ItemStack> optionals;
    private final Map<ItemStack, IntIntPair> required = new HashMap<ItemStack, IntIntPair>();

    public Relic(SlimefunItemStack item, RelicSettings settings, PlanetaryWorld ... planets) {
        super(CoreItemGroup.RELICS, item, CoreRecipeType.WORLD_GEN, Relic.getFromPlanets(planets));
        this.optionals = settings.optionals;
        this.required.putAll(settings.required);
    }

    private static ItemStack[] getFromPlanets(PlanetaryWorld[] planets) {
        ItemStack[] items = new ItemStack[planets.length];
        for (int i = 0; i < planets.length; ++i) {
            items[i] = planets[i].item();
        }
        return Arrays.copyOf(items, 9);
    }

    public RandomizedSet<ItemStack> optionals() {
        return this.optionals;
    }

    public Map<ItemStack, IntIntPair> required() {
        return this.required;
    }

    public static final class RelicSettings {
        private final RandomizedSet<ItemStack> optionals = new RandomizedSet();
        private final Map<ItemStack, IntIntPair> required = new HashMap<ItemStack, IntIntPair>();

        public RelicSettings addOptional(@NonNull ItemStack item, float weight) {
            if (item == null) {
                throw new NullPointerException("item is marked non-null but is null");
            }
            this.optionals.add((Object)item, weight);
            return this;
        }

        public RelicSettings addRequired(@NonNull ItemStack item, int min, int max) {
            if (item == null) {
                throw new NullPointerException("item is marked non-null but is null");
            }
            this.required.put(item, (IntIntPair)new IntIntImmutablePair(min, max));
            return this;
        }
    }
}

