/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.base.items;

import com.destroystokyo.paper.event.player.PlayerTeleportEndGatewayEvent;
import io.github.addoncommunity.galactifun.Galactifun;
import io.github.addoncommunity.galactifun.api.worlds.AlienWorld;
import io.github.addoncommunity.galactifun.base.BaseItems;
import io.github.addoncommunity.galactifun.base.items.StargateRing;
import io.github.addoncommunity.galactifun.infinitylib.common.Events;
import io.github.addoncommunity.galactifun.infinitylib.common.Scheduler;
import io.github.addoncommunity.galactifun.infinitylib.machines.MenuBlock;
import io.github.addoncommunity.galactifun.util.BSUtils;
import io.github.thebusybiscuit.slimefun4.api.events.PlayerRightClickEvent;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.EndGateway;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public final class StargateController
extends SlimefunItem
implements Listener {
    private static final int[] BACKGROUND = new int[]{1, 2, 6, 7, 8};
    private static final int ADDRESS_SLOT = 3;
    private static final int DESTINATION_SLOT = 4;
    private static final int DEACTIVATE_SLOT = 5;
    private static final ComponentPosition[] RING_POSITIONS = new ComponentPosition[]{new ComponentPosition(0, 1), new ComponentPosition(0, -1), new ComponentPosition(1, -2), new ComponentPosition(1, 2), new ComponentPosition(5, -2), new ComponentPosition(5, 2), new ComponentPosition(2, 3), new ComponentPosition(3, 3), new ComponentPosition(4, 3), new ComponentPosition(2, -3), new ComponentPosition(3, -3), new ComponentPosition(4, -3), new ComponentPosition(6, -1), new ComponentPosition(6, 0), new ComponentPosition(6, 1)};
    private static final ComponentPosition[] PORTAL_POSITIONS;
    private static final int GATEWAY_TICKS = 201;

    public StargateController(ItemGroup category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        Events.registerListener(this);
        this.addItemHandler(new ItemHandler[]{e -> e.getClickedBlock().ifPresent(b -> this.onUse(e, e.getPlayer(), (Block)b))});
        this.addItemHandler(new ItemHandler[]{new BlockBreakHandler(true, true){

            @ParametersAreNonnullByDefault
            public void onPlayerBreak(BlockBreakEvent e, ItemStack item, List<ItemStack> drops) {
                if (Boolean.parseBoolean(BlockStorage.getLocationInfo((Location)e.getBlock().getLocation(), (String)"locked"))) {
                    e.setCancelled(true);
                    e.getPlayer().sendMessage(ChatColor.RED + "Deactivate the Stargate before destroying it");
                }
            }
        }});
    }

    public static boolean isPartOfStargate(@Nonnull Block b) {
        for (ComponentPosition position : RING_POSITIONS) {
            if (position.isInSameRing(b)) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public static Optional<List<Block>> getRingBlocks(@Nonnull Block b) {
        ArrayList<Block> rings = new ArrayList<Block>();
        for (ComponentPosition position : RING_POSITIONS) {
            if (!position.isInSameRing(b)) {
                return Optional.empty();
            }
            rings.add(position.getBlock(b));
        }
        return Optional.of(rings);
    }

    @Nonnull
    public static Optional<List<Block>> getPortalBlocks(@Nonnull Block b) {
        ArrayList<Block> portals = new ArrayList<Block>();
        for (ComponentPosition position : PORTAL_POSITIONS) {
            if (!position.isPortal(b)) {
                return Optional.empty();
            }
            portals.add(position.getBlock(b));
        }
        return Optional.of(portals);
    }

    public static void lockBlocks(Block controller, boolean lock) {
        String data = Boolean.toString(lock);
        StargateController.getRingBlocks(controller).ifPresent(l -> l.forEach(b -> BlockStorage.addBlockInfo((Block)b, (String)"locked", (String)data)));
        StargateController.getPortalBlocks(controller).ifPresent(l -> l.forEach(b -> BlockStorage.addBlockInfo((Block)b, (String)"locked", (String)data)));
    }

    private void onUse(PlayerRightClickEvent event, Player p, Block b) {
        if (!StargateController.isPartOfStargate(b)) {
            p.sendMessage(ChatColor.RED + "The Stargate is not assembled!");
            return;
        }
        event.cancel();
        if (StargateController.getPortalBlocks(b).isEmpty()) {
            for (ComponentPosition position : PORTAL_POSITIONS) {
                Block portal = position.getBlock(b);
                portal.setType(Material.END_GATEWAY);
                EndGateway gateway = (EndGateway)portal.getState();
                gateway.setAge(201L);
                gateway.setExitLocation(b.getLocation());
                gateway.update(false, false);
                BlockStorage.addBlockInfo((Block)portal, (String)"portal", (String)"true");
            }
            String destAddress = BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"destination");
            if (destAddress != null) {
                StargateController.setDestination(destAddress, b, p);
            }
            StargateController.lockBlocks(b, true);
            p.sendMessage(ChatColor.YELLOW + "Stargate activated!");
            return;
        }
        ChestMenu menu = this.getMenu(b);
        menu.open(new Player[]{p});
    }

    @Nonnull
    private ChestMenu getMenu(@Nonnull Block b) {
        String destination;
        ChestMenu menu = new ChestMenu(this.getItemName());
        for (int i2 : BACKGROUND) {
            menu.addItem(i2, MenuBlock.BACKGROUND_ITEM, ChestMenuUtils.getEmptyClickHandler());
        }
        Location l = b.getLocation();
        String address = BlockStorage.getLocationInfo((Location)l, (String)"gfsgAddress");
        if (address == null) {
            String lString = String.format("%s-%d-%d-%d", b.getWorld().getName(), l.getBlockX(), l.getBlockY(), l.getBlockZ());
            address = Integer.toHexString(lString.hashCode());
            BlockStorage.addBlockInfo((Block)b, (String)"gfsgAddress", (String)address);
        }
        destination = (destination = BlockStorage.getLocationInfo((Location)l, (String)"destination")) == null ? "" : destination;
        String temp = address;
        menu.addItem(3, (ItemStack)new CustomItemStack(Material.BOOK, "&fAddress: " + address, new String[]{"&7Click to send the address to chat"}), (p, i, s, c) -> {
            p.sendMessage((Component)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.YELLOW)).content("Address (click to copy): " + temp).clickEvent(ClickEvent.copyToClipboard((String)temp))).build());
            p.closeInventory();
            return false;
        });
        menu.addItem(5, (ItemStack)new CustomItemStack(Material.BARRIER, "&fClick to Deactivate the Stargate", new String[0]), (p, i, s, c) -> {
            StargateController.getPortalBlocks(b).ifPresent(li -> {
                for (Block block : li) {
                    block.setType(Material.AIR);
                    BlockStorage.clearBlockInfo((Block)block);
                }
            });
            StargateController.lockBlocks(b, false);
            p.closeInventory();
            return false;
        });
        menu.addItem(4, (ItemStack)new CustomItemStack(Material.RAIL, "&fClick to Set Destination", new String[]{"&7Current Destination: " + destination}), (p, i, s, c) -> {
            p.sendMessage(ChatColor.YELLOW + "Type in the destination address");
            ChatUtils.awaitInput((Player)p, st -> StargateController.setDestination(st, b, p));
            p.closeInventory();
            return false;
        });
        return menu;
    }

    private static void setDestination(String destination, Block b, Player p) {
        Map.Entry configEntry2;
        block3: {
            for (BlockStorage storage : Slimefun.getRegistry().getWorlds().values()) {
                for (Map.Entry configEntry2 : storage.getRawStorage().entrySet()) {
                    String bAddress = ((Config)configEntry2.getValue()).getString("gfsgAddress");
                    if (bAddress == null || !bAddress.equals(destination)) continue;
                    break block3;
                }
            }
            p.sendMessage(ChatColor.RED + "No destination found!");
            return;
        }
        Location dest = (Location)configEntry2.getKey();
        Optional<List<Block>> portalOptional = StargateController.getPortalBlocks(b);
        if (portalOptional.isEmpty()) {
            p.sendMessage(ChatColor.RED + "The Stargate is not lit for some reason...");
            return;
        }
        BSUtils.setStoredLocation(b.getLocation(), "dest", dest);
        p.sendMessage(ChatColor.YELLOW + String.format("Set Stargate destination to %d %d %d in %s", dest.getBlockX(), dest.getBlockY(), dest.getBlockZ(), dest.getWorld().getName()));
        BlockStorage.addBlockInfo((Block)b, (String)"destination", (String)destination);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onGateBreak(BlockBreakEvent e) {
        Block b = e.getBlock();
        if (b.getType() == Material.END_GATEWAY && Boolean.parseBoolean(BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"locked"))) {
            e.setCancelled(true);
            e.getPlayer().sendMessage(ChatColor.RED + "Deactivate the Stargate before destroying it");
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onUsePortal(PlayerTeleportEndGatewayEvent e) {
        if (!BSUtils.getStoredBoolean(e.getGateway().getLocation(), "portal")) {
            return;
        }
        Location dest = BSUtils.getStoredLocation(e.getGateway().getExitLocation(), "dest");
        if (dest == null) {
            return;
        }
        e.setCancelled(true);
        Player p = e.getPlayer();
        if (p.hasMetadata("disableStargate")) {
            return;
        }
        Block b = dest.getBlock();
        if (BlockStorage.check((Block)b, (String)BaseItems.STARGATE_CONTROLLER.getItemId()) && StargateController.getPortalBlocks(b).isEmpty()) {
            e.getPlayer().sendMessage(ChatColor.RED + "The destination Stargate is not activated");
            return;
        }
        Block destBlock = b.getRelative(1, 0, 0);
        if (destBlock.getType().isEmpty()) {
            AlienWorld world = Galactifun.worldManager().getAlienWorld(destBlock.getWorld());
            if (world != null) {
                e.getPlayer().setMetadata("CanTpAlienWorld", (MetadataValue)new FixedMetadataValue((Plugin)Galactifun.instance(), (Object)true));
            }
            PaperLib.teleportAsync((Entity)e.getPlayer(), (Location)destBlock.getLocation());
            p.setMetadata("disableStargate", (MetadataValue)new FixedMetadataValue((Plugin)Galactifun.instance(), (Object)true));
            Scheduler.run(10, () -> p.removeMetadata("disableStargate", (Plugin)Galactifun.instance()));
        } else {
            e.getPlayer().sendMessage(ChatColor.RED + "The destination is blocked");
        }
    }

    static {
        LinkedList<ComponentPosition> portalPositions = new LinkedList<ComponentPosition>(Arrays.asList(new ComponentPosition(1, -1), new ComponentPosition(1, 0), new ComponentPosition(1, 1)));
        for (int y = 2; y <= 4; ++y) {
            for (int z = -2; z <= 2; ++z) {
                portalPositions.add(new ComponentPosition(y, z));
            }
        }
        portalPositions.add(new ComponentPosition(5, -1));
        portalPositions.add(new ComponentPosition(5, 0));
        portalPositions.add(new ComponentPosition(5, 1));
        PORTAL_POSITIONS = portalPositions.toArray(new ComponentPosition[0]);
    }

    private record ComponentPosition(int y, int z) {
        public boolean isInSameRing(@Nonnull Block b) {
            return BlockStorage.check((Block)b.getRelative(0, this.y, this.z)) instanceof StargateRing;
        }

        @Nonnull
        public Block getBlock(@Nonnull Block b) {
            return b.getRelative(0, this.y, this.z);
        }

        public boolean isPortal(@Nonnull Block b) {
            return b.getRelative(0, this.y, this.z).getType() == Material.END_GATEWAY;
        }
    }
}

