/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.base.aliens;

import io.github.addoncommunity.galactifun.Galactifun;
import io.github.addoncommunity.galactifun.api.aliens.Alien;
import io.github.addoncommunity.galactifun.infinitylib.common.PersistentType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Silverfish;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.persistence.PersistentDataContainer;

public final class Leech
extends Alien<Silverfish> {
    private final NamespacedKey eatenKey = Galactifun.createKey("eaten");

    public Leech(String id, String name, double maxHealth, int spawnChance) {
        super(Silverfish.class, id, name, maxHealth, spawnChance);
    }

    @Override
    public void onAttack(@Nonnull EntityDamageByEntityEvent e) {
        PlayerInventory inv = ((Player)e.getEntity()).getInventory();
        ArrayList<Integer> slots = new ArrayList<Integer>();
        ItemStack[] contents = inv.getContents();
        for (int i = 0; i < contents.length; ++i) {
            if (contents[i] == null) continue;
            slots.add(i);
        }
        if (slots.isEmpty()) {
            return;
        }
        int slot = (Integer)slots.get(ThreadLocalRandom.current().nextInt(slots.size()));
        ItemStack item = contents[slot];
        PersistentDataContainer container = e.getEntity().getPersistentDataContainer();
        List eatenItems = (List)container.get(this.eatenKey, PersistentType.ITEM_STACK_LIST);
        if (eatenItems != null) {
            eatenItems.add(item);
            container.set(this.eatenKey, PersistentType.ITEM_STACK_LIST, (Object)eatenItems);
        } else {
            container.set(this.eatenKey, PersistentType.ITEM_STACK_LIST, Collections.singletonList(item));
        }
        inv.setItem(slot, null);
        LivingEntity attacker = (LivingEntity)e.getDamager();
        attacker.setHealth(Math.min(this.maxHealth(), attacker.getHealth() + 2.0));
    }

    @Override
    public void onDeath(@Nonnull EntityDeathEvent e) {
        e.getDrops().clear();
        List eatenItems = (List)e.getEntity().getPersistentDataContainer().get(this.eatenKey, PersistentType.ITEM_STACK_LIST);
        if (eatenItems != null) {
            e.getDrops().addAll(eatenItems);
        }
    }
}

