/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.core.managers;

import io.github.addoncommunity.galactifun.Galactifun;
import io.github.addoncommunity.galactifun.api.items.ExclusiveGEOResource;
import io.github.addoncommunity.galactifun.api.items.spacesuit.SpaceSuitProfile;
import io.github.addoncommunity.galactifun.api.universe.PlanetaryObject;
import io.github.addoncommunity.galactifun.api.universe.attributes.atmosphere.AtmosphericEffect;
import io.github.addoncommunity.galactifun.api.worlds.AlienWorld;
import io.github.addoncommunity.galactifun.api.worlds.OrbitWorld;
import io.github.addoncommunity.galactifun.api.worlds.PlanetaryWorld;
import io.github.addoncommunity.galactifun.base.BaseUniverse;
import io.github.addoncommunity.galactifun.base.universe.earth.Earth;
import io.github.addoncommunity.galactifun.core.managers.ProtectionManager;
import io.github.addoncommunity.galactifun.infinitylib.common.Events;
import io.github.addoncommunity.galactifun.infinitylib.common.Scheduler;
import io.github.addoncommunity.galactifun.util.ChunkStorage;
import io.github.thebusybiscuit.slimefun4.api.events.ExplosiveToolBreakBlocksEvent;
import io.github.thebusybiscuit.slimefun4.api.events.GEOResourceGenerationEvent;
import io.github.thebusybiscuit.slimefun4.api.events.WaypointCreateEvent;
import io.github.thebusybiscuit.slimefun4.api.geo.GEOResource;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemUtils;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import io.github.thebusybiscuit.slimefun4.utils.tags.SlimefunTag;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public final class WorldManager
implements Listener {
    private static final String PLACED = "placed";
    private final int maxAliensPerPlayer;
    private final Map<World, PlanetaryWorld> spaceWorlds = new HashMap<World, PlanetaryWorld>();
    private final Map<World, AlienWorld> alienWorlds = new HashMap<World, AlienWorld>();
    private final YamlConfiguration config;
    private final YamlConfiguration defaultConfig;
    private final Map<UUID, Integer> respawnTimes = new HashMap<UUID, Integer>();
    private final Map<UUID, Long> lastDeaths = new HashMap<UUID, Long>();

    public WorldManager(Galactifun galactifun) {
        this.maxAliensPerPlayer = galactifun.getConfig().getInt("aliens.max-per-player", 4, 64);
        Events.registerListener(this);
        Scheduler.repeat(100, () -> this.alienWorlds.values().forEach(AlienWorld::tickWorld));
        Scheduler.repeat(20, this::tickOxygen);
        File configFile = new File("plugins/Galactifun", "worlds.yml");
        this.config = new YamlConfiguration();
        this.defaultConfig = new YamlConfiguration();
        this.config.setDefaults((Configuration)this.defaultConfig);
        if (configFile.exists()) {
            try {
                this.config.load(configFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Scheduler.run(() -> {
            try {
                this.config.options().copyDefaults(true);
                this.config.save(configFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    public void register(PlanetaryWorld world) {
        if (this.spaceWorlds.containsKey(world.world())) {
            throw new IllegalArgumentException("Alien World " + world.id() + " is already registered!");
        }
        this.spaceWorlds.put(world.world(), world);
        if (world instanceof AlienWorld) {
            AlienWorld alienWorld = (AlienWorld)world;
            this.alienWorlds.put(world.world(), alienWorld);
        }
    }

    public <T> T getSetting(AlienWorld world, String path, Class<T> clazz, T defaultValue) {
        path = world.id() + "." + (String)path;
        this.defaultConfig.set((String)path, defaultValue);
        if (clazz == String.class) {
            return (T)this.config.getString((String)path);
        }
        return (T)this.config.getObject((String)path, clazz);
    }

    private void tickOxygen() {
        for (Player p : Bukkit.getOnlinePlayers()) {
            PlanetaryWorld world;
            if (p.getGameMode() != GameMode.SURVIVAL || (world = this.spaceWorlds.get(p.getWorld())) == null || !world.atmosphere().requiresOxygenTank() || Galactifun.protectionManager().isOxygenBlock(p.getLocation()) || SpaceSuitProfile.get(p).consumeOxygen(20)) continue;
            p.sendMessage(ChatColor.RED + "You have run out of oxygen!");
            p.setHealth(Math.max(p.getHealth() - 8.0, 0.0));
        }
    }

    @Nullable
    public PlanetaryWorld getWorld(@Nonnull World world) {
        return this.spaceWorlds.get(world);
    }

    @Nullable
    public AlienWorld getAlienWorld(@Nonnull World world) {
        return this.alienWorlds.get(world);
    }

    @Nonnull
    public Collection<PlanetaryWorld> spaceWorlds() {
        return Collections.unmodifiableCollection(this.spaceWorlds.values());
    }

    @Nonnull
    public Collection<AlienWorld> alienWorlds() {
        return Collections.unmodifiableCollection(this.alienWorlds.values());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlanetChange(@Nonnull PlayerChangedWorldEvent e) {
        AlienWorld object = this.getAlienWorld(e.getFrom());
        if (object != null) {
            object.gravity().removeGravity(e.getPlayer());
        }
        if ((object = this.getAlienWorld(e.getPlayer().getWorld())) != null) {
            object.applyEffects(e.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    private void onPlanetJoin(@Nonnull PlayerJoinEvent e) {
        AlienWorld object = this.getAlienWorld(e.getPlayer().getWorld());
        if (object != null) {
            object.applyEffects(e.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    private void onPlayerChangeGameMode(@Nonnull PlayerGameModeChangeEvent e) {
        AlienWorld object = this.getAlienWorld(e.getPlayer().getWorld());
        if (object != null && e.getNewGameMode() != GameMode.CREATIVE && e.getNewGameMode() != GameMode.SPECTATOR) {
            object.applyEffects(e.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onPlayerTeleport(@Nonnull PlayerTeleportEvent e) {
        if (!e.getPlayer().hasPermission("galactifun.admin") && e.getTo().getWorld() != null && e.getFrom().getWorld() != e.getTo().getWorld()) {
            PlanetaryWorld world = this.getWorld(e.getTo().getWorld());
            PlanetaryWorld world2 = this.getWorld(e.getFrom().getWorld());
            if (world != null && world2 != null) {
                boolean canTp = false;
                for (MetadataValue value : e.getPlayer().getMetadata("CanTpAlienWorld")) {
                    canTp = value.asBoolean();
                }
                if (canTp || e.getFrom().getWorld().equals(e.getTo().getWorld())) {
                    e.getPlayer().removeMetadata("CanTpAlienWorld", (Plugin)Galactifun.instance());
                } else {
                    e.setCancelled(true);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onCreatureSpawn(@Nonnull CreatureSpawnEvent e) {
        AlienWorld world;
        if (e.getSpawnReason() == CreatureSpawnEvent.SpawnReason.NATURAL && (world = this.getAlienWorld(e.getEntity().getWorld())) != null && !world.canSpawnVanillaMobs()) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onWaypointCreate(@Nonnull WaypointCreateEvent e) {
        if (this.alienWorlds.containsKey(e.getPlayer().getWorld())) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    private void onCropGrow(@Nonnull BlockGrowEvent e) {
        Block block = e.getBlock();
        AlienWorld world = this.getAlienWorld(block.getWorld());
        if (world != null) {
            Location l;
            ProtectionManager manager = Galactifun.protectionManager();
            if (manager.getEffectAt(l = block.getLocation(), AtmosphericEffect.COLD) > 1) {
                Scheduler.run(() -> block.setType(Material.ICE));
            } else if (manager.getEffectAt(l, AtmosphericEffect.HEAT) > 1) {
                Scheduler.run(() -> ((Block)block).breakNaturally());
            } else {
                BlockData data;
                int attempts = world.atmosphere().growthAttempts();
                if (attempts != 0 && SlimefunTag.CROPS.isTagged((Keyed)block.getType()) && (data = block.getBlockData()) instanceof Ageable) {
                    Ageable ageable = (Ageable)data;
                    ageable.setAge(ageable.getAge() + attempts);
                    block.setBlockData((BlockData)ageable);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onBreak(BlockBreakEvent e) {
        SlimefunItemStack item;
        Block b = e.getBlock();
        World w = b.getWorld();
        AlienWorld world = this.alienWorlds.get(w);
        if (world != null && (item = world.getMappedItem(b)) != null && !this.removePlacedBlock(b)) {
            e.setDropItems(false);
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            drops.add(item.clone());
            item.getItem().callItemHandler(BlockBreakHandler.class, h -> h.onPlayerBreak(e, (ItemStack)item, drops));
            for (ItemStack drop : drops) {
                w.dropItemNaturally(b.getLocation().add(0.5, 0.0, 0.5), drop);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onBlockExplode(BlockExplodeEvent e) {
        this.handleExplosion(e.blockList().iterator());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onEntityExplode(EntityExplodeEvent e) {
        this.handleExplosion(e.blockList().iterator());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onExplosivePickUse(ExplosiveToolBreakBlocksEvent e) {
        this.handleExplosion(e.getAdditionalBlocks().iterator());
    }

    private void handleExplosion(Iterator<Block> blocks) {
        while (blocks.hasNext()) {
            SlimefunItemStack item;
            Block b = blocks.next();
            World w = b.getWorld();
            AlienWorld world = this.getAlienWorld(w);
            if (world == null || (item = world.getMappedItem(b)) == null || this.removePlacedBlock(b)) continue;
            blocks.remove();
            w.dropItemNaturally(b.getLocation().add(0.5, 0.0, 0.5), item.clone());
            Scheduler.run(() -> b.setType(Material.AIR));
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    private void onSleep(PlayerInteractEvent e) {
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player p = e.getPlayer();
        PlanetaryWorld world = this.getWorld(p.getWorld());
        if (world == null || world.atmosphere().environment() == World.Environment.NORMAL) {
            return;
        }
        Block b = e.getClickedBlock();
        if (b != null && Tag.BEDS.isTagged((Keyed)b.getType())) {
            e.setCancelled(true);
            p.setBedSpawnLocation(p.getLocation(), true);
            p.sendMessage("Respawn point set");
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    private void onPlace(BlockPlaceEvent e) {
        Block b = e.getBlock();
        AlienWorld world = this.getAlienWorld(b.getWorld());
        if (world != null && world.getMappedItem(b) != null) {
            this.addPlacedBlock(b);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    private void onRespawnLoop(PlayerDeathEvent e) {
        Player p = e.getEntity();
        if (this.getWorld(p.getWorld()) != null) {
            int times;
            long timeSince;
            Long lastBoxed = this.lastDeaths.get(p.getUniqueId());
            if (lastBoxed != null && (timeSince = System.currentTimeMillis() - lastBoxed) < 60000L && (times = this.respawnTimes.merge(p.getUniqueId(), 1, Integer::sum).intValue()) > 3) {
                p.sendMessage(ChatColor.YELLOW + "A possible respawn loop has been detected!\nDo you wish to go back to Earth? (yes/no)");
                ChatUtils.awaitInput((Player)p, s -> {
                    if (s.equalsIgnoreCase("yes")) {
                        PaperLib.teleportAsync((Entity)p, (Location)BaseUniverse.EARTH.world().getSpawnLocation());
                        this.respawnTimes.remove(p.getUniqueId());
                    }
                });
            }
            this.lastDeaths.put(p.getUniqueId(), System.currentTimeMillis());
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    private void onPlayerPlaceWater(PlayerBucketEmptyEvent e) {
        if (e.getBucket() != Material.WATER_BUCKET) {
            return;
        }
        Player p = e.getPlayer();
        PlanetaryWorld world = this.getWorld(p.getWorld());
        if (world != null && world != BaseUniverse.EARTH) {
            Block clicked;
            Block toBePlaced;
            Location l;
            ProtectionManager manager;
            ItemStack item;
            e.setCancelled(true);
            if (p.getGameMode() != GameMode.CREATIVE && (item = p.getInventory().getItem(e.getHand())) != null) {
                ItemUtils.consumeItem((ItemStack)item, (boolean)true);
            }
            if ((manager = Galactifun.protectionManager()).getEffectAt(l = (toBePlaced = (clicked = e.getBlockClicked()).getRelative(e.getBlockFace())).getLocation(), AtmosphericEffect.COLD) > 1) {
                if (toBePlaced.isEmpty()) {
                    toBePlaced.setType(Material.ICE);
                }
            } else if (manager.getEffectAt(l, AtmosphericEffect.HEAT) > 1) {
                p.getWorld().spawnParticle(Particle.SMOKE_NORMAL, l, 5);
            } else {
                e.setCancelled(false);
            }
        }
    }

    @EventHandler
    private void onGEOResourceGenerate(GEOResourceGenerationEvent e) {
        PlanetaryWorld world = this.getWorld(e.getWorld());
        if (world == null) {
            return;
        }
        GEOResource gEOResource = e.getResource();
        if (gEOResource instanceof ExclusiveGEOResource) {
            ExclusiveGEOResource exclusiveResource = (ExclusiveGEOResource)gEOResource;
            if (exclusiveResource.getWorlds().contains(world)) {
                return;
            }
        } else {
            if (world instanceof Earth) {
                return;
            }
            for (GEOResource resource : world.resources()) {
                if (!resource.equals(e.getResource())) continue;
                return;
            }
        }
        e.setValue(0);
    }

    @EventHandler(ignoreCancelled=true)
    private void onPlayerFallInOrbit(EntityDamageEvent e) {
        OrbitWorld orbitWorld;
        PlanetaryObject planetaryObject;
        if (e.getCause() != EntityDamageEvent.DamageCause.VOID) {
            return;
        }
        PlanetaryWorld world = this.getWorld(e.getEntity().getWorld());
        if (world instanceof OrbitWorld && (planetaryObject = (orbitWorld = (OrbitWorld)((Object)world)).getPlanet()) instanceof PlanetaryWorld) {
            PlanetaryWorld planet = (PlanetaryWorld)planetaryObject;
            e.setCancelled(true);
            Location l = e.getEntity().getLocation();
            e.getEntity().teleport(new Location(planet.world(), l.getX(), (double)planet.world().getMaxHeight(), l.getZ()));
        }
    }

    public void addPlacedBlock(Block b) {
        ChunkStorage.tag(b, PLACED);
    }

    public boolean removePlacedBlock(Block b) {
        return ChunkStorage.untag(b, PLACED);
    }

    public int maxAliensPerPlayer() {
        return this.maxAliensPerPlayer;
    }
}

