/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.util;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.RegionAccessor;
import org.bukkit.block.Biome;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.WorldInfo;

public final class GenUtils {
    @ParametersAreNonnullByDefault
    public static void generateSquare(RegionAccessor accessor, Location center, Material material, int radius) {
        int startX = center.getBlockX();
        int startZ = center.getBlockZ();
        for (int x = startX - radius; x <= startX + radius; ++x) {
            for (int z = startZ - radius; z <= startZ + radius; ++z) {
                accessor.setType(x, center.getBlockY(), z, material);
            }
        }
    }

    public static void generatePlus(@Nonnull RegionAccessor accessor, @Nonnull Location center, @Nonnull Material material) {
        accessor.setType(center.getBlockX(), center.getBlockY(), center.getBlockZ(), material);
        accessor.setType(center.getBlockX() + 1, center.getBlockY(), center.getBlockZ(), material);
        accessor.setType(center.getBlockX() - 1, center.getBlockY(), center.getBlockZ(), material);
        accessor.setType(center.getBlockX(), center.getBlockY(), center.getBlockZ() + 1, material);
        accessor.setType(center.getBlockX(), center.getBlockY(), center.getBlockZ() - 1, material);
    }

    public static void generateOakTop(@Nonnull RegionAccessor accessor, @Nonnull Location topLog, @Nonnull Material leaves) {
        GenUtils.generateSquare(accessor, topLog, leaves, 1);
        GenUtils.generatePlus(accessor, topLog.add(0.0, 1.0, 0.0), leaves);
        GenUtils.generateSquare(accessor, topLog.subtract(0.0, 2.0, 0.0), leaves, 2);
        GenUtils.generateSquare(accessor, topLog.subtract(0.0, 1.0, 0.0), leaves, 2);
    }

    private GenUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static final class SingleBiomeProvider
    extends BiomeProvider {
        private final Biome biome;
        private final List<Biome> singletonBiome;

        public SingleBiomeProvider(Biome biome) {
            this.biome = biome;
            this.singletonBiome = List.of(biome);
        }

        @Nonnull
        public Biome getBiome(@Nonnull WorldInfo worldInfo, int x, int y, int z) {
            return this.biome;
        }

        @Nonnull
        public List<Biome> getBiomes(@Nonnull WorldInfo worldInfo) {
            return this.singletonBiome;
        }
    }
}

