/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.base.items;

import io.github.addoncommunity.galactifun.Galactifun;
import io.github.addoncommunity.galactifun.api.items.spacesuit.SpaceSuit;
import io.github.addoncommunity.galactifun.api.worlds.PlanetaryWorld;
import io.github.addoncommunity.galactifun.util.Util;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public final class OxygenFiller
extends AContainer {
    public OxygenFiller(ItemGroup category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
    }

    protected void tick(Block b) {
        PlanetaryWorld world = Galactifun.worldManager().getWorld(b.getWorld());
        if (!this.isInSealed(b) && world != null && world.atmosphere().requiresOxygenTank()) {
            return;
        }
        if (this.getCharge(b.getLocation()) < this.getEnergyConsumption()) {
            return;
        }
        BlockMenu inv = BlockStorage.getInventory((Block)b);
        for (int slot : this.getInputSlots()) {
            ItemStack item = inv.getItemInSlot(slot);
            if (item == null || !item.hasItemMeta() || !this.addOxygen(b, inv, slot, item)) continue;
            return;
        }
    }

    private boolean addOxygen(Block b, BlockMenu inv, int slot, ItemStack item) {
        ItemMeta meta;
        SpaceSuit suit;
        int oxygen;
        SlimefunItem sfItem = SlimefunItem.getByItem((ItemStack)item);
        if (sfItem instanceof SpaceSuit && (oxygen = (suit = (SpaceSuit)sfItem).getOxygen(meta = item.getItemMeta())) < suit.maxOxygen()) {
            this.removeCharge(b.getLocation(), this.getEnergyConsumption());
            suit.setOxygen(meta, oxygen + this.getSpeed());
            item.setItemMeta(meta);
            return true;
        }
        if (inv.fits(item, this.getOutputSlots())) {
            inv.pushItem(item, this.getOutputSlots());
            inv.replaceExistingItem(slot, null);
        }
        return false;
    }

    public ItemStack getProgressBar() {
        return new ItemStack(Material.WATER_BUCKET);
    }

    @Nonnull
    public String getMachineIdentifier() {
        return "OXYGEN_FILLER";
    }

    private boolean isInSealed(@Nonnull Block b) {
        for (BlockFace face : Util.ALL_SIDES) {
            if (!Galactifun.protectionManager().isOxygenBlock(b.getRelative(face).getLocation())) continue;
            return true;
        }
        return false;
    }
}

