/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.api.worlds;

import io.github.addoncommunity.galactifun.api.universe.PlanetaryObject;
import io.github.addoncommunity.galactifun.api.universe.StarSystem;
import io.github.addoncommunity.galactifun.api.universe.attributes.DayCycle;
import io.github.addoncommunity.galactifun.api.universe.attributes.Gravity;
import io.github.addoncommunity.galactifun.api.universe.attributes.Orbit;
import io.github.addoncommunity.galactifun.api.universe.attributes.atmosphere.Atmosphere;
import io.github.addoncommunity.galactifun.api.universe.types.PlanetaryType;
import io.github.addoncommunity.galactifun.api.worlds.AlienWorld;
import io.github.addoncommunity.galactifun.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import io.github.addoncommunity.galactifun.fastutil.ints.Int2ObjectMap;
import io.github.addoncommunity.galactifun.fastutil.ints.Int2ObjectSortedMap;
import io.github.addoncommunity.galactifun.fastutil.ints.Int2ObjectSortedMaps;
import io.github.addoncommunity.galactifun.fastutil.ints.IntIterator;
import io.github.addoncommunity.galactifun.util.GenUtils;
import java.util.Random;
import javax.annotation.Nonnull;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;
import org.bukkit.inventory.ItemStack;

public abstract class FlatWorld
extends AlienWorld {
    private volatile Int2ObjectMap<Material> top = null;
    private volatile Int2ObjectMap<Material> bottom = null;

    public FlatWorld(String name, PlanetaryType type, Orbit orbit, StarSystem orbiting, ItemStack baseItem, DayCycle dayCycle, Atmosphere atmosphere, Gravity gravity) {
        super(name, type, orbit, orbiting, baseItem, dayCycle, atmosphere, gravity);
    }

    public FlatWorld(String name, PlanetaryType type, Orbit orbit, PlanetaryObject orbiting, ItemStack baseItem, DayCycle dayCycle, Atmosphere atmosphere, Gravity gravity) {
        super(name, type, orbit, orbiting, baseItem, dayCycle, atmosphere, gravity);
    }

    @Nonnull
    protected abstract Int2ObjectSortedMap<Material> getLayers();

    @Nonnull
    protected abstract Biome getBiome();

    @Override
    protected final void generateChunk(@Nonnull ChunkGenerator.ChunkData chunk, @Nonnull Random random, @Nonnull WorldInfo world, int chunkX, int chunkZ) {
        this.apportionLayers();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int y = this.getBedrockLayer() + 1;
                IntIterator heights = this.top.keySet().intIterator();
                while (heights.hasNext() && y < world.getMaxHeight()) {
                    int height = heights.nextInt();
                    Material material = (Material)this.top.get(height);
                    while (y <= height) {
                        chunk.setBlock(x, y, z, material);
                        ++y;
                    }
                }
            }
        }
    }

    @Override
    protected final void generateSurface(@Nonnull ChunkGenerator.ChunkData chunk, @Nonnull Random random, @Nonnull WorldInfo world, int chunkX, int chunkZ) {
        this.apportionLayers();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int y = this.getBedrockLayer() + 1;
                IntIterator heights = this.bottom.keySet().intIterator();
                while (heights.hasNext() && y < world.getMaxHeight()) {
                    int height = heights.nextInt();
                    Material material = (Material)this.bottom.get(height);
                    while (y <= height) {
                        chunk.setBlock(x, y, z, material);
                        ++y;
                    }
                }
            }
        }
    }

    @Override
    @Nonnull
    protected final BiomeProvider getBiomeProvider(@Nonnull WorldInfo info) {
        return new GenUtils.SingleBiomeProvider(this.getBiome());
    }

    private void apportionLayers() {
        IntIterator iter;
        Int2ObjectSortedMap<Material> layers;
        if (this.top == null) {
            layers = this.getLayers();
            Int2ObjectLinkedOpenHashMap newTop = new Int2ObjectLinkedOpenHashMap();
            iter = layers.keySet().intIterator();
            iter.skip(layers.size() / 2 + 1);
            iter.forEachRemaining(i -> newTop.put(i, (Material)layers.get(i)));
            this.top = Int2ObjectSortedMaps.unmodifiable(newTop);
        }
        if (this.bottom == null) {
            layers = this.getLayers();
            Int2ObjectLinkedOpenHashMap<Material> newBottom = new Int2ObjectLinkedOpenHashMap<Material>();
            iter = layers.keySet().intIterator();
            int amount = layers.size() / 2 + 1;
            for (int i2 = 0; i2 < amount; ++i2) {
                int layer = iter.nextInt();
                newBottom.put(layer, (Material)layers.get(layer));
            }
            this.bottom = Int2ObjectSortedMaps.unmodifiable(newBottom);
        }
    }
}

