/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.base.items.protection;

import io.github.addoncommunity.galactifun.core.CoreItemGroup;
import io.github.addoncommunity.galactifun.util.BSUtils;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.type.Light;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;

public final class ForcefieldGenerator
extends SlimefunItem
implements EnergyNetComponent {
    private static final String ACTIVE = "active";
    private static final int ENERGY_CONSUMPTION = 64;

    public ForcefieldGenerator(SlimefunItemStack item, ItemStack[] recipe) {
        super(CoreItemGroup.MACHINES, item, RecipeType.ENHANCED_CRAFTING_TABLE, recipe);
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            public boolean isSynchronized() {
                return true;
            }

            public void tick(Block b, SlimefunItem item, Config data) {
                ForcefieldGenerator.this.tick(b, data);
            }
        }});
        this.addItemHandler(new ItemHandler[]{new BlockPlaceHandler(false){

            public void onPlayerPlace(@Nonnull BlockPlaceEvent e) {
                ForcefieldGenerator.this.activate(e.getBlock());
            }
        }});
        this.addItemHandler(new ItemHandler[]{new BlockBreakHandler(false, false){

            @ParametersAreNonnullByDefault
            public void onPlayerBreak(BlockBreakEvent e, ItemStack item, List<ItemStack> drops) {
                ForcefieldGenerator.this.deactivate(e.getBlock());
            }
        }});
        this.addItemHandler(new ItemHandler[]{e -> {
            e.cancel();
            Block b = (Block)e.getClickedBlock().orElseThrow();
            if (b.getType() != Material.DISPENSER) {
                return;
            }
            Player p = e.getPlayer();
            if (BSUtils.getStoredBoolean(b, ACTIVE)) {
                this.deactivate(b);
                p.sendMessage("Deactivated");
            } else {
                this.activate(b);
                p.sendMessage("Activated");
            }
        }});
    }

    private void tick(Block b, Config data) {
        boolean active = Boolean.parseBoolean(data.getString(ACTIVE));
        if (active && this.getCharge(b.getLocation()) < 64) {
            this.deactivate(b);
        } else {
            this.removeCharge(b.getLocation(), 64);
        }
    }

    private void activate(Block b) {
        if (BSUtils.getStoredBoolean(b, ACTIVE)) {
            return;
        }
        BlockFace direction = ((Directional)b.getBlockData()).getFacing();
        Block next = b.getRelative(direction);
        for (int steps = 0; !next.getType().isSolid() && steps < 64; ++steps) {
            next.setType(Material.LIGHT);
            Light light = (Light)next.getBlockData();
            light.setLevel(6);
            next.setBlockData((BlockData)light);
            next = next.getRelative(direction);
        }
        BSUtils.addBlockInfo(b, ACTIVE, true);
    }

    private void deactivate(Block b) {
        if (!BSUtils.getStoredBoolean(b, ACTIVE)) {
            return;
        }
        BlockFace direction = ((Directional)b.getBlockData()).getFacing();
        Block next = b.getRelative(direction);
        for (int steps = 0; next.getType() == Material.LIGHT && steps < 64; ++steps) {
            next.setType(Material.AIR);
            next = next.getRelative(direction);
        }
        BSUtils.addBlockInfo(b, ACTIVE, false);
    }

    @Nonnull
    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    public int getCapacity() {
        return 256;
    }
}

