/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.util;

import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.generator.LimitedRegion;

public final class Sphere {
    public static final int MIN_RADIUS = 3;
    public static final int MAX_RADIUS = 125;
    private final Material[] materials;
    private Location currentMiddle;
    private int currentMaterial;
    private LimitedRegion currentRegion;

    public Sphere(Material ... materials) {
        this.materials = materials;
        Validate.isTrue((materials.length != 0 ? 1 : 0) != 0);
    }

    public void generate(@Nonnull Location middle, @Nonnull LimitedRegion region, int min, int dev) {
        Validate.isTrue((min >= 3 && dev >= 0 && min + dev <= 125 ? 1 : 0) != 0, (String)"Generation parameters out of bounds!");
        this.currentMiddle = middle;
        int radius = min + ThreadLocalRandom.current().nextInt(dev + 1);
        int radiusSquared = radius * radius;
        this.gen(0, 0, 0);
        this.genMiddles(radius);
        int x = 1;
        int vector1 = 1;
        while (x < radius) {
            this.genMiddles(x);
            int y = x;
            for (int vector2 = vector1 + y * y; y < radius && vector2 < radiusSquared; vector2 += (y++ << 1) + 1) {
                this.genEdges(x, y);
                if (x != y) {
                    this.genEdges(y, x);
                }
                int z = y;
                for (int vector3 = vector2 + z * z; z < radius && vector3 < radiusSquared; vector3 += (z++ << 1) + 1) {
                    this.genCorners(x, y, z);
                    if (x != y) {
                        this.genCorners(y, x, z);
                        this.genCorners(z, y, x);
                        if (y == z) continue;
                        this.genCorners(x, z, y);
                        this.genCorners(z, x, y);
                        this.genCorners(y, z, x);
                        continue;
                    }
                    if (x == z) continue;
                    this.genCorners(z, y, x);
                    this.genCorners(x, z, y);
                }
            }
            vector1 += (x++ << 1) + 1;
        }
        this.currentMiddle = null;
    }

    private void genMiddles(int a) {
        this.gen(a, 0, 0);
        this.gen(-a, 0, 0);
        this.gen(0, a, 0);
        this.randomize();
        this.gen(0, -a, 0);
        this.gen(0, 0, a);
        this.gen(0, 0, -a);
    }

    private void genEdges(int a, int b) {
        this.gen(a, b, 0);
        this.gen(-a, b, 0);
        this.randomize();
        this.gen(a, -b, 0);
        this.gen(-a, -b, 0);
        this.gen(0, a, b);
        this.gen(0, -a, b);
        this.randomize();
        this.gen(0, a, -b);
        this.gen(0, -a, -b);
        this.gen(a, 0, b);
        this.gen(-a, 0, b);
        this.randomize();
        this.gen(a, 0, -b);
        this.gen(-a, 0, -b);
    }

    private void genCorners(int a, int b, int c) {
        this.gen(a, b, c);
        this.gen(-a, b, c);
        this.gen(a, -b, c);
        this.gen(a, b, -c);
        this.randomize();
        this.gen(-a, -b, c);
        this.gen(a, -b, -c);
        this.gen(-a, b, -c);
        this.gen(-a, -b, -c);
    }

    private void gen(int x, int y, int z) {
        this.currentRegion.setType(this.currentMiddle.clone().add((double)x, (double)y, (double)z), this.materials[this.currentMaterial++]);
        if (this.currentMaterial == this.materials.length) {
            this.currentMaterial = 0;
        }
    }

    private void randomize() {
        this.currentMaterial = ThreadLocalRandom.current().nextInt(this.materials.length);
    }
}

